package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupSetList invokes the polardbx.DescribeBackupSetList API synchronously
func (client *Client) DescribeBackupSetList(request *DescribeBackupSetListRequest) (response *DescribeBackupSetListResponse, err error) {
	response = CreateDescribeBackupSetListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupSetListWithChan invokes the polardbx.DescribeBackupSetList API asynchronously
func (client *Client) DescribeBackupSetListWithChan(request *DescribeBackupSetListRequest) (<-chan *DescribeBackupSetListResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupSetListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupSetList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupSetListWithCallback invokes the polardbx.DescribeBackupSetList API asynchronously
func (client *Client) DescribeBackupSetListWithCallback(request *DescribeBackupSetListRequest, callback func(response *DescribeBackupSetListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupSetListResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupSetList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupSetListRequest is the request struct for api DescribeBackupSetList
type DescribeBackupSetListRequest struct {
	*requests.RpcRequest
	DBInstanceName  string           `position:"Query" name:"DBInstanceName"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	DestCrossRegion string           `position:"Query" name:"DestCrossRegion"`
}

// DescribeBackupSetListResponse is the response struct for api DescribeBackupSetList
type DescribeBackupSetListResponse struct {
	*responses.BaseResponse
	Message   string      `json:"Message" xml:"Message"`
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Success   bool        `json:"Success" xml:"Success"`
	Data      []BackupSet `json:"Data" xml:"Data"`
}

// CreateDescribeBackupSetListRequest creates a request to invoke DescribeBackupSetList API
func CreateDescribeBackupSetListRequest() (request *DescribeBackupSetListRequest) {
	request = &DescribeBackupSetListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeBackupSetList", "polardbx", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeBackupSetListResponse creates a response to parse from DescribeBackupSetList response
func CreateDescribeBackupSetListResponse() (response *DescribeBackupSetListResponse) {
	response = &DescribeBackupSetListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
