package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePtsScene invokes the pts.DeletePtsScene API synchronously
func (client *Client) DeletePtsScene(request *DeletePtsSceneRequest) (response *DeletePtsSceneResponse, err error) {
	response = CreateDeletePtsSceneResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePtsSceneWithChan invokes the pts.DeletePtsScene API asynchronously
func (client *Client) DeletePtsSceneWithChan(request *DeletePtsSceneRequest) (<-chan *DeletePtsSceneResponse, <-chan error) {
	responseChan := make(chan *DeletePtsSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePtsScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePtsSceneWithCallback invokes the pts.DeletePtsScene API asynchronously
func (client *Client) DeletePtsSceneWithCallback(request *DeletePtsSceneRequest, callback func(response *DeletePtsSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePtsSceneResponse
		var err error
		defer close(result)
		response, err = client.DeletePtsScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePtsSceneRequest is the request struct for api DeletePtsScene
type DeletePtsSceneRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// DeletePtsSceneResponse is the response struct for api DeletePtsScene
type DeletePtsSceneResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeletePtsSceneRequest creates a request to invoke DeletePtsScene API
func CreateDeletePtsSceneRequest() (request *DeletePtsSceneRequest) {
	request = &DeletePtsSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "DeletePtsScene", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePtsSceneResponse creates a response to parse from DeletePtsScene response
func CreateDeletePtsSceneResponse() (response *DeletePtsSceneResponse) {
	response = &DeletePtsSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
