package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHitResult invokes the qualitycheck.GetHitResult API synchronously
func (client *Client) GetHitResult(request *GetHitResultRequest) (response *GetHitResultResponse, err error) {
	response = CreateGetHitResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetHitResultWithChan invokes the qualitycheck.GetHitResult API asynchronously
func (client *Client) GetHitResultWithChan(request *GetHitResultRequest) (<-chan *GetHitResultResponse, <-chan error) {
	responseChan := make(chan *GetHitResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHitResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHitResultWithCallback invokes the qualitycheck.GetHitResult API asynchronously
func (client *Client) GetHitResultWithCallback(request *GetHitResultRequest, callback func(response *GetHitResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHitResultResponse
		var err error
		defer close(result)
		response, err = client.GetHitResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHitResultRequest is the request struct for api GetHitResult
type GetHitResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// GetHitResultResponse is the response struct for api GetHitResult
type GetHitResultResponse struct {
	*responses.BaseResponse
	RequestId  string             `json:"RequestId" xml:"RequestId"`
	Success    bool               `json:"Success" xml:"Success"`
	Code       string             `json:"Code" xml:"Code"`
	Message    string             `json:"Message" xml:"Message"`
	PageNumber int                `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                `json:"PageSize" xml:"PageSize"`
	Count      int                `json:"Count" xml:"Count"`
	Data       DataInGetHitResult `json:"Data" xml:"Data"`
}

// CreateGetHitResultRequest creates a request to invoke GetHitResult API
func CreateGetHitResultRequest() (request *GetHitResultRequest) {
	request = &GetHitResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetHitResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHitResultResponse creates a response to parse from GetHitResult response
func CreateGetHitResultResponse() (response *GetHitResultResponse) {
	response = &GetHitResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
