package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevertAssignedSessionGroup invokes the qualitycheck.RevertAssignedSessionGroup API synchronously
func (client *Client) RevertAssignedSessionGroup(request *RevertAssignedSessionGroupRequest) (response *RevertAssignedSessionGroupResponse, err error) {
	response = CreateRevertAssignedSessionGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RevertAssignedSessionGroupWithChan invokes the qualitycheck.RevertAssignedSessionGroup API asynchronously
func (client *Client) RevertAssignedSessionGroupWithChan(request *RevertAssignedSessionGroupRequest) (<-chan *RevertAssignedSessionGroupResponse, <-chan error) {
	responseChan := make(chan *RevertAssignedSessionGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevertAssignedSessionGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevertAssignedSessionGroupWithCallback invokes the qualitycheck.RevertAssignedSessionGroup API asynchronously
func (client *Client) RevertAssignedSessionGroupWithCallback(request *RevertAssignedSessionGroupRequest, callback func(response *RevertAssignedSessionGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevertAssignedSessionGroupResponse
		var err error
		defer close(result)
		response, err = client.RevertAssignedSessionGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevertAssignedSessionGroupRequest is the request struct for api RevertAssignedSessionGroup
type RevertAssignedSessionGroupRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// RevertAssignedSessionGroupResponse is the response struct for api RevertAssignedSessionGroup
type RevertAssignedSessionGroupResponse struct {
	*responses.BaseResponse
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	Success        bool                                 `json:"Success" xml:"Success"`
	Code           string                               `json:"Code" xml:"Code"`
	Message        string                               `json:"Message" xml:"Message"`
	HttpStatusCode int                                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInRevertAssignedSessionGroup `json:"Messages" xml:"Messages"`
}

// CreateRevertAssignedSessionGroupRequest creates a request to invoke RevertAssignedSessionGroup API
func CreateRevertAssignedSessionGroupRequest() (request *RevertAssignedSessionGroupRequest) {
	request = &RevertAssignedSessionGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "RevertAssignedSessionGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateRevertAssignedSessionGroupResponse creates a response to parse from RevertAssignedSessionGroup response
func CreateRevertAssignedSessionGroupResponse() (response *RevertAssignedSessionGroupResponse) {
	response = &RevertAssignedSessionGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
