package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRuleById invokes the qualitycheck.UpdateRuleById API synchronously
func (client *Client) UpdateRuleById(request *UpdateRuleByIdRequest) (response *UpdateRuleByIdResponse, err error) {
	response = CreateUpdateRuleByIdResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRuleByIdWithChan invokes the qualitycheck.UpdateRuleById API asynchronously
func (client *Client) UpdateRuleByIdWithChan(request *UpdateRuleByIdRequest) (<-chan *UpdateRuleByIdResponse, <-chan error) {
	responseChan := make(chan *UpdateRuleByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRuleById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRuleByIdWithCallback invokes the qualitycheck.UpdateRuleById API asynchronously
func (client *Client) UpdateRuleByIdWithCallback(request *UpdateRuleByIdRequest, callback func(response *UpdateRuleByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRuleByIdResponse
		var err error
		defer close(result)
		response, err = client.UpdateRuleById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRuleByIdRequest is the request struct for api UpdateRuleById
type UpdateRuleByIdRequest struct {
	*requests.RpcRequest
	IsSchemeData         requests.Integer `position:"Body" name:"IsSchemeData"`
	ReturnRelatedSchemes requests.Boolean `position:"Body" name:"ReturnRelatedSchemes"`
	IsCopy               requests.Boolean `position:"Body" name:"IsCopy"`
	JsonStrForRule       string           `position:"Body" name:"JsonStrForRule"`
	RuleId               requests.Integer `position:"Body" name:"RuleId"`
	BaseMeAgentId        requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateRuleByIdResponse is the response struct for api UpdateRuleById
type UpdateRuleByIdResponse struct {
	*responses.BaseResponse
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	Code           string                   `json:"Code" xml:"Code"`
	Message        string                   `json:"Message" xml:"Message"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInUpdateRuleById `json:"Messages" xml:"Messages"`
}

// CreateUpdateRuleByIdRequest creates a request to invoke UpdateRuleById API
func CreateUpdateRuleByIdRequest() (request *UpdateRuleByIdRequest) {
	request = &UpdateRuleByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateRuleById", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRuleByIdResponse creates a response to parse from UpdateRuleById response
func CreateUpdateRuleByIdResponse() (response *UpdateRuleByIdResponse) {
	response = &UpdateRuleByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
