package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuotaTemplateServiceStatus invokes the quotas.GetQuotaTemplateServiceStatus API synchronously
func (client *Client) GetQuotaTemplateServiceStatus(request *GetQuotaTemplateServiceStatusRequest) (response *GetQuotaTemplateServiceStatusResponse, err error) {
	response = CreateGetQuotaTemplateServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuotaTemplateServiceStatusWithChan invokes the quotas.GetQuotaTemplateServiceStatus API asynchronously
func (client *Client) GetQuotaTemplateServiceStatusWithChan(request *GetQuotaTemplateServiceStatusRequest) (<-chan *GetQuotaTemplateServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetQuotaTemplateServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuotaTemplateServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuotaTemplateServiceStatusWithCallback invokes the quotas.GetQuotaTemplateServiceStatus API asynchronously
func (client *Client) GetQuotaTemplateServiceStatusWithCallback(request *GetQuotaTemplateServiceStatusRequest, callback func(response *GetQuotaTemplateServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuotaTemplateServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetQuotaTemplateServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuotaTemplateServiceStatusRequest is the request struct for api GetQuotaTemplateServiceStatus
type GetQuotaTemplateServiceStatusRequest struct {
	*requests.RpcRequest
	OriginalContext     string `position:"Body" name:"OriginalContext"`
	ResourceDirectoryId string `position:"Body" name:"ResourceDirectoryId"`
}

// GetQuotaTemplateServiceStatusResponse is the response struct for api GetQuotaTemplateServiceStatus
type GetQuotaTemplateServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	TemplateServiceStatus TemplateServiceStatus `json:"TemplateServiceStatus" xml:"TemplateServiceStatus"`
}

// CreateGetQuotaTemplateServiceStatusRequest creates a request to invoke GetQuotaTemplateServiceStatus API
func CreateGetQuotaTemplateServiceStatusRequest() (request *GetQuotaTemplateServiceStatusRequest) {
	request = &GetQuotaTemplateServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "GetQuotaTemplateServiceStatus", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQuotaTemplateServiceStatusResponse creates a response to parse from GetQuotaTemplateServiceStatus response
func CreateGetQuotaTemplateServiceStatusResponse() (response *GetQuotaTemplateServiceStatusResponse) {
	response = &GetQuotaTemplateServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
