package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHADiagnoseConfig invokes the rds.DescribeHADiagnoseConfig API synchronously
func (client *Client) DescribeHADiagnoseConfig(request *DescribeHADiagnoseConfigRequest) (response *DescribeHADiagnoseConfigResponse, err error) {
	response = CreateDescribeHADiagnoseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHADiagnoseConfigWithChan invokes the rds.DescribeHADiagnoseConfig API asynchronously
func (client *Client) DescribeHADiagnoseConfigWithChan(request *DescribeHADiagnoseConfigRequest) (<-chan *DescribeHADiagnoseConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeHADiagnoseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHADiagnoseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHADiagnoseConfigWithCallback invokes the rds.DescribeHADiagnoseConfig API asynchronously
func (client *Client) DescribeHADiagnoseConfigWithCallback(request *DescribeHADiagnoseConfigRequest, callback func(response *DescribeHADiagnoseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHADiagnoseConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeHADiagnoseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHADiagnoseConfigRequest is the request struct for api DescribeHADiagnoseConfig
type DescribeHADiagnoseConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DescribeHADiagnoseConfigResponse is the response struct for api DescribeHADiagnoseConfig
type DescribeHADiagnoseConfigResponse struct {
	*responses.BaseResponse
	TcpConnectionType string `json:"TcpConnectionType" xml:"TcpConnectionType"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeHADiagnoseConfigRequest creates a request to invoke DescribeHADiagnoseConfig API
func CreateDescribeHADiagnoseConfigRequest() (request *DescribeHADiagnoseConfigRequest) {
	request = &DescribeHADiagnoseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeHADiagnoseConfig", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHADiagnoseConfigResponse creates a response to parse from DescribeHADiagnoseConfig response
func CreateDescribeHADiagnoseConfigResponse() (response *DescribeHADiagnoseConfigResponse) {
	response = &DescribeHADiagnoseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
