package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUpgradeMajorVersionPrecheckTask invokes the rds.DescribeUpgradeMajorVersionPrecheckTask API synchronously
func (client *Client) DescribeUpgradeMajorVersionPrecheckTask(request *DescribeUpgradeMajorVersionPrecheckTaskRequest) (response *DescribeUpgradeMajorVersionPrecheckTaskResponse, err error) {
	response = CreateDescribeUpgradeMajorVersionPrecheckTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUpgradeMajorVersionPrecheckTaskWithChan invokes the rds.DescribeUpgradeMajorVersionPrecheckTask API asynchronously
func (client *Client) DescribeUpgradeMajorVersionPrecheckTaskWithChan(request *DescribeUpgradeMajorVersionPrecheckTaskRequest) (<-chan *DescribeUpgradeMajorVersionPrecheckTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeUpgradeMajorVersionPrecheckTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUpgradeMajorVersionPrecheckTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUpgradeMajorVersionPrecheckTaskWithCallback invokes the rds.DescribeUpgradeMajorVersionPrecheckTask API asynchronously
func (client *Client) DescribeUpgradeMajorVersionPrecheckTaskWithCallback(request *DescribeUpgradeMajorVersionPrecheckTaskRequest, callback func(response *DescribeUpgradeMajorVersionPrecheckTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUpgradeMajorVersionPrecheckTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeUpgradeMajorVersionPrecheckTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUpgradeMajorVersionPrecheckTaskRequest is the request struct for api DescribeUpgradeMajorVersionPrecheckTask
type DescribeUpgradeMajorVersionPrecheckTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TargetMajorVersion   string           `position:"Query" name:"TargetMajorVersion"`
}

// DescribeUpgradeMajorVersionPrecheckTaskResponse is the response struct for api DescribeUpgradeMajorVersionPrecheckTask
type DescribeUpgradeMajorVersionPrecheckTaskResponse struct {
	*responses.BaseResponse
	RequestId        string                                           `json:"RequestId" xml:"RequestId"`
	PageNumber       int                                              `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int                                              `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int                                              `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Items            []TasksInDescribeUpgradeMajorVersionPrecheckTask `json:"Items" xml:"Items"`
}

// CreateDescribeUpgradeMajorVersionPrecheckTaskRequest creates a request to invoke DescribeUpgradeMajorVersionPrecheckTask API
func CreateDescribeUpgradeMajorVersionPrecheckTaskRequest() (request *DescribeUpgradeMajorVersionPrecheckTaskRequest) {
	request = &DescribeUpgradeMajorVersionPrecheckTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeUpgradeMajorVersionPrecheckTask", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUpgradeMajorVersionPrecheckTaskResponse creates a response to parse from DescribeUpgradeMajorVersionPrecheckTask response
func CreateDescribeUpgradeMajorVersionPrecheckTaskResponse() (response *DescribeUpgradeMajorVersionPrecheckTaskResponse) {
	response = &DescribeUpgradeMajorVersionPrecheckTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
