package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFilter invokes the resourcecenter.DeleteFilter API synchronously
func (client *Client) DeleteFilter(request *DeleteFilterRequest) (response *DeleteFilterResponse, err error) {
	response = CreateDeleteFilterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFilterWithChan invokes the resourcecenter.DeleteFilter API asynchronously
func (client *Client) DeleteFilterWithChan(request *DeleteFilterRequest) (<-chan *DeleteFilterResponse, <-chan error) {
	responseChan := make(chan *DeleteFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFilterWithCallback invokes the resourcecenter.DeleteFilter API asynchronously
func (client *Client) DeleteFilterWithCallback(request *DeleteFilterRequest, callback func(response *DeleteFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFilterResponse
		var err error
		defer close(result)
		response, err = client.DeleteFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFilterRequest is the request struct for api DeleteFilter
type DeleteFilterRequest struct {
	*requests.RpcRequest
	FilterName string `position:"Query" name:"FilterName"`
}

// DeleteFilterResponse is the response struct for api DeleteFilter
type DeleteFilterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFilterRequest creates a request to invoke DeleteFilter API
func CreateDeleteFilterRequest() (request *DeleteFilterRequest) {
	request = &DeleteFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "DeleteFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteFilterResponse creates a response to parse from DeleteFilter response
func CreateDeleteFilterResponse() (response *DeleteFilterResponse) {
	response = &DeleteFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
