package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetControlPolicy invokes the resourcemanager.GetControlPolicy API synchronously
func (client *Client) GetControlPolicy(request *GetControlPolicyRequest) (response *GetControlPolicyResponse, err error) {
	response = CreateGetControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetControlPolicyWithChan invokes the resourcemanager.GetControlPolicy API asynchronously
func (client *Client) GetControlPolicyWithChan(request *GetControlPolicyRequest) (<-chan *GetControlPolicyResponse, <-chan error) {
	responseChan := make(chan *GetControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetControlPolicyWithCallback invokes the resourcemanager.GetControlPolicy API asynchronously
func (client *Client) GetControlPolicyWithCallback(request *GetControlPolicyRequest, callback func(response *GetControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetControlPolicyRequest is the request struct for api GetControlPolicy
type GetControlPolicyRequest struct {
	*requests.RpcRequest
	Language string `position:"Query" name:"Language"`
	PolicyId string `position:"Query" name:"PolicyId"`
}

// GetControlPolicyResponse is the response struct for api GetControlPolicy
type GetControlPolicyResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ControlPolicy ControlPolicy `json:"ControlPolicy" xml:"ControlPolicy"`
}

// CreateGetControlPolicyRequest creates a request to invoke GetControlPolicy API
func CreateGetControlPolicyRequest() (request *GetControlPolicyRequest) {
	request = &GetControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetControlPolicy", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetControlPolicyResponse creates a response to parse from GetControlPolicy response
func CreateGetControlPolicyResponse() (response *GetControlPolicyResponse) {
	response = &GetControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
