package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataSource invokes the retailadvqa_public.CreateDataSource API synchronously
func (client *Client) CreateDataSource(request *CreateDataSourceRequest) (response *CreateDataSourceResponse, err error) {
	response = CreateCreateDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataSourceWithChan invokes the retailadvqa_public.CreateDataSource API asynchronously
func (client *Client) CreateDataSourceWithChan(request *CreateDataSourceRequest) (<-chan *CreateDataSourceResponse, <-chan error) {
	responseChan := make(chan *CreateDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataSourceWithCallback invokes the retailadvqa_public.CreateDataSource API asynchronously
func (client *Client) CreateDataSourceWithCallback(request *CreateDataSourceRequest, callback func(response *CreateDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataSourceRequest is the request struct for api CreateDataSource
type CreateDataSourceRequest struct {
	*requests.RpcRequest
	DatabaseAddress  string `position:"Query" name:"DatabaseAddress"`
	DataSourceType   string `position:"Query" name:"DataSourceType"`
	RegionCode       string `position:"Query" name:"RegionCode"`
	DatabaseUserName string `position:"Query" name:"DatabaseUserName"`
	DatabasePassword string `position:"Query" name:"DatabasePassword"`
	DatabasePort     string `position:"Query" name:"DatabasePort"`
	AccessId         string `position:"Query" name:"AccessId"`
	DisplayName      string `position:"Query" name:"DisplayName"`
	DatabaseName     string `position:"Query" name:"DatabaseName"`
	DataSourceId     string `position:"Query" name:"DataSourceId"`
	CreateType       string `position:"Query" name:"CreateType"`
	WorkspaceId      string `position:"Query" name:"WorkspaceId"`
}

// CreateDataSourceResponse is the response struct for api CreateDataSource
type CreateDataSourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ExStack   string `json:"ExStack" xml:"ExStack"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDataSourceRequest creates a request to invoke CreateDataSource API
func CreateCreateDataSourceRequest() (request *CreateDataSourceRequest) {
	request = &CreateDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "CreateDataSource", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDataSourceResponse creates a response to parse from CreateDataSource response
func CreateCreateDataSourceResponse() (response *CreateDataSourceResponse) {
	response = &CreateDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
