package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationGroups invokes the sae.DescribeApplicationGroups API synchronously
func (client *Client) DescribeApplicationGroups(request *DescribeApplicationGroupsRequest) (response *DescribeApplicationGroupsResponse, err error) {
	response = CreateDescribeApplicationGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationGroupsWithChan invokes the sae.DescribeApplicationGroups API asynchronously
func (client *Client) DescribeApplicationGroupsWithChan(request *DescribeApplicationGroupsRequest) (<-chan *DescribeApplicationGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationGroupsWithCallback invokes the sae.DescribeApplicationGroups API asynchronously
func (client *Client) DescribeApplicationGroupsWithCallback(request *DescribeApplicationGroupsRequest, callback func(response *DescribeApplicationGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationGroupsRequest is the request struct for api DescribeApplicationGroups
type DescribeApplicationGroupsRequest struct {
	*requests.RoaRequest
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// DescribeApplicationGroupsResponse is the response struct for api DescribeApplicationGroups
type DescribeApplicationGroupsResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Message   string             `json:"Message" xml:"Message"`
	TraceId   string             `json:"TraceId" xml:"TraceId"`
	ErrorCode string             `json:"ErrorCode" xml:"ErrorCode"`
	Code      string             `json:"Code" xml:"Code"`
	Success   bool               `json:"Success" xml:"Success"`
	Data      []ApplicationGroup `json:"Data" xml:"Data"`
}

// CreateDescribeApplicationGroupsRequest creates a request to invoke DescribeApplicationGroups API
func CreateDescribeApplicationGroupsRequest() (request *DescribeApplicationGroupsRequest) {
	request = &DescribeApplicationGroupsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeApplicationGroups", "/pop/v1/sam/app/describeApplicationGroups", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeApplicationGroupsResponse creates a response to parse from DescribeApplicationGroups response
func CreateDescribeApplicationGroupsResponse() (response *DescribeApplicationGroupsResponse) {
	response = &DescribeApplicationGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
