package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppVersions invokes the sae.ListAppVersions API synchronously
func (client *Client) ListAppVersions(request *ListAppVersionsRequest) (response *ListAppVersionsResponse, err error) {
	response = CreateListAppVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppVersionsWithChan invokes the sae.ListAppVersions API asynchronously
func (client *Client) ListAppVersionsWithChan(request *ListAppVersionsRequest) (<-chan *ListAppVersionsResponse, <-chan error) {
	responseChan := make(chan *ListAppVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppVersionsWithCallback invokes the sae.ListAppVersions API asynchronously
func (client *Client) ListAppVersionsWithCallback(request *ListAppVersionsRequest, callback func(response *ListAppVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppVersionsResponse
		var err error
		defer close(result)
		response, err = client.ListAppVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppVersionsRequest is the request struct for api ListAppVersions
type ListAppVersionsRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// ListAppVersionsResponse is the response struct for api ListAppVersions
type ListAppVersionsResponse struct {
	*responses.BaseResponse
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	ErrorCode string                 `json:"ErrorCode" xml:"ErrorCode"`
	Code      string                 `json:"Code" xml:"Code"`
	Success   bool                   `json:"Success" xml:"Success"`
	Data      []PackageVersionEntity `json:"Data" xml:"Data"`
}

// CreateListAppVersionsRequest creates a request to invoke ListAppVersions API
func CreateListAppVersionsRequest() (request *ListAppVersionsRequest) {
	request = &ListAppVersionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ListAppVersions", "/pop/v1/sam/app/listAppVersions", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAppVersionsResponse creates a response to parse from ListAppVersions response
func CreateListAppVersionsResponse() (response *ListAppVersionsResponse) {
	response = &ListAppVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
