package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeEnd invokes the safe.ChangeEnd API synchronously
func (client *Client) ChangeEnd(request *ChangeEndRequest) (response *ChangeEndResponse, err error) {
	response = CreateChangeEndResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeEndWithChan invokes the safe.ChangeEnd API asynchronously
func (client *Client) ChangeEndWithChan(request *ChangeEndRequest) (<-chan *ChangeEndResponse, <-chan error) {
	responseChan := make(chan *ChangeEndResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeEnd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeEndWithCallback invokes the safe.ChangeEnd API asynchronously
func (client *Client) ChangeEndWithCallback(request *ChangeEndRequest, callback func(response *ChangeEndResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeEndResponse
		var err error
		defer close(result)
		response, err = client.ChangeEnd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeEndRequest is the request struct for api ChangeEnd
type ChangeEndRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Query" name:"AuthKey"`
	TotalBatchNo  requests.Integer `position:"Query" name:"TotalBatchNo"`
	ReqTimestamp  requests.Integer `position:"Query" name:"ReqTimestamp"`
	ChangeEndTime requests.Integer `position:"Query" name:"ChangeEndTime"`
	ExecutorEmpId string           `position:"Query" name:"ExecutorEmpId"`
	CurBatchNo    requests.Integer `position:"Query" name:"CurBatchNo"`
	SourceOrderId string           `position:"Query" name:"SourceOrderId"`
	AuthSign      string           `position:"Query" name:"AuthSign"`
	ChangeResult  string           `position:"Query" name:"ChangeResult"`
}

// ChangeEndResponse is the response struct for api ChangeEnd
type ChangeEndResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateChangeEndRequest creates a request to invoke ChangeEnd API
func CreateChangeEndRequest() (request *ChangeEndRequest) {
	request = &ChangeEndRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "ChangeEnd", "", "")
	request.Method = requests.POST
	return
}

// CreateChangeEndResponse creates a response to parse from ChangeEnd response
func CreateChangeEndResponse() (response *ChangeEndResponse) {
	response = &ChangeEndResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
