package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckQuaraFileId invokes the sas.CheckQuaraFileId API synchronously
func (client *Client) CheckQuaraFileId(request *CheckQuaraFileIdRequest) (response *CheckQuaraFileIdResponse, err error) {
	response = CreateCheckQuaraFileIdResponse()
	err = client.DoAction(request, response)
	return
}

// CheckQuaraFileIdWithChan invokes the sas.CheckQuaraFileId API asynchronously
func (client *Client) CheckQuaraFileIdWithChan(request *CheckQuaraFileIdRequest) (<-chan *CheckQuaraFileIdResponse, <-chan error) {
	responseChan := make(chan *CheckQuaraFileIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckQuaraFileId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckQuaraFileIdWithCallback invokes the sas.CheckQuaraFileId API asynchronously
func (client *Client) CheckQuaraFileIdWithCallback(request *CheckQuaraFileIdRequest, callback func(response *CheckQuaraFileIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckQuaraFileIdResponse
		var err error
		defer close(result)
		response, err = client.CheckQuaraFileId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckQuaraFileIdRequest is the request struct for api CheckQuaraFileId
type CheckQuaraFileIdRequest struct {
	*requests.RpcRequest
	QuaraFileIds *[]string `position:"Query" name:"QuaraFileIds"  type:"Repeated"`
	Uuid         string    `position:"Query" name:"Uuid"`
	SourceIp     string    `position:"Query" name:"SourceIp"`
}

// CheckQuaraFileIdResponse is the response struct for api CheckQuaraFileId
type CheckQuaraFileIdResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckQuaraFileIdRequest creates a request to invoke CheckQuaraFileId API
func CreateCheckQuaraFileIdRequest() (request *CheckQuaraFileIdRequest) {
	request = &CheckQuaraFileIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CheckQuaraFileId", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckQuaraFileIdResponse creates a response to parse from CheckQuaraFileId response
func CreateCheckQuaraFileIdResponse() (response *CheckQuaraFileIdResponse) {
	response = &CheckQuaraFileIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
