package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpcHoneyPot invokes the sas.DeleteVpcHoneyPot API synchronously
func (client *Client) DeleteVpcHoneyPot(request *DeleteVpcHoneyPotRequest) (response *DeleteVpcHoneyPotResponse, err error) {
	response = CreateDeleteVpcHoneyPotResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpcHoneyPotWithChan invokes the sas.DeleteVpcHoneyPot API asynchronously
func (client *Client) DeleteVpcHoneyPotWithChan(request *DeleteVpcHoneyPotRequest) (<-chan *DeleteVpcHoneyPotResponse, <-chan error) {
	responseChan := make(chan *DeleteVpcHoneyPotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpcHoneyPot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpcHoneyPotWithCallback invokes the sas.DeleteVpcHoneyPot API asynchronously
func (client *Client) DeleteVpcHoneyPotWithCallback(request *DeleteVpcHoneyPotRequest, callback func(response *DeleteVpcHoneyPotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpcHoneyPotResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpcHoneyPot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpcHoneyPotRequest is the request struct for api DeleteVpcHoneyPot
type DeleteVpcHoneyPotRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	VpcId    string `position:"Query" name:"VpcId"`
}

// DeleteVpcHoneyPotResponse is the response struct for api DeleteVpcHoneyPot
type DeleteVpcHoneyPotResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpcHoneyPotRequest creates a request to invoke DeleteVpcHoneyPot API
func CreateDeleteVpcHoneyPotRequest() (request *DeleteVpcHoneyPotRequest) {
	request = &DeleteVpcHoneyPotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DeleteVpcHoneyPot", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpcHoneyPotResponse creates a response to parse from DeleteVpcHoneyPot response
func CreateDeleteVpcHoneyPotResponse() (response *DeleteVpcHoneyPotResponse) {
	response = &DeleteVpcHoneyPotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
