package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccessKeyLeakDetail invokes the sas.DescribeAccessKeyLeakDetail API synchronously
func (client *Client) DescribeAccessKeyLeakDetail(request *DescribeAccessKeyLeakDetailRequest) (response *DescribeAccessKeyLeakDetailResponse, err error) {
	response = CreateDescribeAccessKeyLeakDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccessKeyLeakDetailWithChan invokes the sas.DescribeAccessKeyLeakDetail API asynchronously
func (client *Client) DescribeAccessKeyLeakDetailWithChan(request *DescribeAccessKeyLeakDetailRequest) (<-chan *DescribeAccessKeyLeakDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeAccessKeyLeakDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccessKeyLeakDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccessKeyLeakDetailWithCallback invokes the sas.DescribeAccessKeyLeakDetail API asynchronously
func (client *Client) DescribeAccessKeyLeakDetailWithCallback(request *DescribeAccessKeyLeakDetailRequest, callback func(response *DescribeAccessKeyLeakDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccessKeyLeakDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccessKeyLeakDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccessKeyLeakDetailRequest is the request struct for api DescribeAccessKeyLeakDetail
type DescribeAccessKeyLeakDetailRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	Id       requests.Integer `position:"Query" name:"Id"`
}

// DescribeAccessKeyLeakDetailResponse is the response struct for api DescribeAccessKeyLeakDetail
type DescribeAccessKeyLeakDetailResponse struct {
	*responses.BaseResponse
	Type                 string `json:"Type" xml:"Type"`
	GithubUserPicUrl     string `json:"GithubUserPicUrl" xml:"GithubUserPicUrl"`
	GithubUser           string `json:"GithubUser" xml:"GithubUser"`
	GithubRepoName       string `json:"GithubRepoName" xml:"GithubRepoName"`
	GithubFileType       string `json:"GithubFileType" xml:"GithubFileType"`
	Remark               string `json:"Remark" xml:"Remark"`
	GithubFileUpdateTime string `json:"GithubFileUpdateTime" xml:"GithubFileUpdateTime"`
	WhitelistStatus      string `json:"WhitelistStatus" xml:"WhitelistStatus"`
	GithubFileName       string `json:"GithubFileName" xml:"GithubFileName"`
	Source               string `json:"Source" xml:"Source"`
	GmtModified          string `json:"GmtModified" xml:"GmtModified"`
	Asset                string `json:"Asset" xml:"Asset"`
	DealTime             string `json:"DealTime" xml:"DealTime"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	AccesskeyId          string `json:"AccesskeyId" xml:"AccesskeyId"`
	GithubFileUrl        string `json:"GithubFileUrl" xml:"GithubFileUrl"`
	DealType             string `json:"DealType" xml:"DealType"`
	Code                 string `json:"Code" xml:"Code"`
	GmtCreate            string `json:"GmtCreate" xml:"GmtCreate"`
	GithubRepoUrl        string `json:"GithubRepoUrl" xml:"GithubRepoUrl"`
}

// CreateDescribeAccessKeyLeakDetailRequest creates a request to invoke DescribeAccessKeyLeakDetail API
func CreateDescribeAccessKeyLeakDetailRequest() (request *DescribeAccessKeyLeakDetailRequest) {
	request = &DescribeAccessKeyLeakDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeAccessKeyLeakDetail", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccessKeyLeakDetailResponse creates a response to parse from DescribeAccessKeyLeakDetail response
func CreateDescribeAccessKeyLeakDetailResponse() (response *DescribeAccessKeyLeakDetailResponse) {
	response = &DescribeAccessKeyLeakDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
