package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroupedInstances invokes the sas.DescribeGroupedInstances API synchronously
func (client *Client) DescribeGroupedInstances(request *DescribeGroupedInstancesRequest) (response *DescribeGroupedInstancesResponse, err error) {
	response = CreateDescribeGroupedInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupedInstancesWithChan invokes the sas.DescribeGroupedInstances API asynchronously
func (client *Client) DescribeGroupedInstancesWithChan(request *DescribeGroupedInstancesRequest) (<-chan *DescribeGroupedInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupedInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroupedInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupedInstancesWithCallback invokes the sas.DescribeGroupedInstances API asynchronously
func (client *Client) DescribeGroupedInstancesWithCallback(request *DescribeGroupedInstancesRequest, callback func(response *DescribeGroupedInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupedInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroupedInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupedInstancesRequest is the request struct for api DescribeGroupedInstances
type DescribeGroupedInstancesRequest struct {
	*requests.RpcRequest
	Criteria     string           `position:"Query" name:"Criteria"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	GroupField   string           `position:"Query" name:"GroupField"`
	NoPage       requests.Boolean `position:"Query" name:"NoPage"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Lang         string           `position:"Query" name:"Lang"`
	FieldValue   string           `position:"Query" name:"FieldValue"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	MachineTypes string           `position:"Query" name:"MachineTypes"`
}

// DescribeGroupedInstancesResponse is the response struct for api DescribeGroupedInstances
type DescribeGroupedInstancesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo   `json:"PageInfo" xml:"PageInfo"`
	Instances []Instance `json:"Instances" xml:"Instances"`
}

// CreateDescribeGroupedInstancesRequest creates a request to invoke DescribeGroupedInstances API
func CreateDescribeGroupedInstancesRequest() (request *DescribeGroupedInstancesRequest) {
	request = &DescribeGroupedInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeGroupedInstances", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGroupedInstancesResponse creates a response to parse from DescribeGroupedInstances response
func CreateDescribeGroupedInstancesResponse() (response *DescribeGroupedInstancesResponse) {
	response = &DescribeGroupedInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
