package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstallCodes invokes the sas.DescribeInstallCodes API synchronously
func (client *Client) DescribeInstallCodes(request *DescribeInstallCodesRequest) (response *DescribeInstallCodesResponse, err error) {
	response = CreateDescribeInstallCodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstallCodesWithChan invokes the sas.DescribeInstallCodes API asynchronously
func (client *Client) DescribeInstallCodesWithChan(request *DescribeInstallCodesRequest) (<-chan *DescribeInstallCodesResponse, <-chan error) {
	responseChan := make(chan *DescribeInstallCodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstallCodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstallCodesWithCallback invokes the sas.DescribeInstallCodes API asynchronously
func (client *Client) DescribeInstallCodesWithCallback(request *DescribeInstallCodesRequest, callback func(response *DescribeInstallCodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstallCodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstallCodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstallCodesRequest is the request struct for api DescribeInstallCodes
type DescribeInstallCodesRequest struct {
	*requests.RpcRequest
	SubAccountName string           `position:"Query" name:"SubAccountName"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	Status         requests.Integer `position:"Query" name:"Status"`
}

// DescribeInstallCodesResponse is the response struct for api DescribeInstallCodes
type DescribeInstallCodesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	InstallCodes []InstallCode `json:"InstallCodes" xml:"InstallCodes"`
}

// CreateDescribeInstallCodesRequest creates a request to invoke DescribeInstallCodes API
func CreateDescribeInstallCodesRequest() (request *DescribeInstallCodesRequest) {
	request = &DescribeInstallCodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeInstallCodes", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstallCodesResponse creates a response to parse from DescribeInstallCodes response
func CreateDescribeInstallCodesResponse() (response *DescribeInstallCodesResponse) {
	response = &DescribeInstallCodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
