package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainRealTimeQpsData invokes the scdn.DescribeScdnDomainRealTimeQpsData API synchronously
func (client *Client) DescribeScdnDomainRealTimeQpsData(request *DescribeScdnDomainRealTimeQpsDataRequest) (response *DescribeScdnDomainRealTimeQpsDataResponse, err error) {
	response = CreateDescribeScdnDomainRealTimeQpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainRealTimeQpsDataWithChan invokes the scdn.DescribeScdnDomainRealTimeQpsData API asynchronously
func (client *Client) DescribeScdnDomainRealTimeQpsDataWithChan(request *DescribeScdnDomainRealTimeQpsDataRequest) (<-chan *DescribeScdnDomainRealTimeQpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainRealTimeQpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainRealTimeQpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainRealTimeQpsDataWithCallback invokes the scdn.DescribeScdnDomainRealTimeQpsData API asynchronously
func (client *Client) DescribeScdnDomainRealTimeQpsDataWithCallback(request *DescribeScdnDomainRealTimeQpsDataRequest, callback func(response *DescribeScdnDomainRealTimeQpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainRealTimeQpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainRealTimeQpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainRealTimeQpsDataRequest is the request struct for api DescribeScdnDomainRealTimeQpsData
type DescribeScdnDomainRealTimeQpsDataRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
}

// DescribeScdnDomainRealTimeQpsDataResponse is the response struct for api DescribeScdnDomainRealTimeQpsData
type DescribeScdnDomainRealTimeQpsDataResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeScdnDomainRealTimeQpsData `json:"Data" xml:"Data"`
}

// CreateDescribeScdnDomainRealTimeQpsDataRequest creates a request to invoke DescribeScdnDomainRealTimeQpsData API
func CreateDescribeScdnDomainRealTimeQpsDataRequest() (request *DescribeScdnDomainRealTimeQpsDataRequest) {
	request = &DescribeScdnDomainRealTimeQpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainRealTimeQpsData", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeScdnDomainRealTimeQpsDataResponse creates a response to parse from DescribeScdnDomainRealTimeQpsData response
func CreateDescribeScdnDomainRealTimeQpsDataResponse() (response *DescribeScdnDomainRealTimeQpsDataResponse) {
	response = &DescribeScdnDomainRealTimeQpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
