package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainRealTimeTrafficData invokes the scdn.DescribeScdnDomainRealTimeTrafficData API synchronously
func (client *Client) DescribeScdnDomainRealTimeTrafficData(request *DescribeScdnDomainRealTimeTrafficDataRequest) (response *DescribeScdnDomainRealTimeTrafficDataResponse, err error) {
	response = CreateDescribeScdnDomainRealTimeTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainRealTimeTrafficDataWithChan invokes the scdn.DescribeScdnDomainRealTimeTrafficData API asynchronously
func (client *Client) DescribeScdnDomainRealTimeTrafficDataWithChan(request *DescribeScdnDomainRealTimeTrafficDataRequest) (<-chan *DescribeScdnDomainRealTimeTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainRealTimeTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainRealTimeTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainRealTimeTrafficDataWithCallback invokes the scdn.DescribeScdnDomainRealTimeTrafficData API asynchronously
func (client *Client) DescribeScdnDomainRealTimeTrafficDataWithCallback(request *DescribeScdnDomainRealTimeTrafficDataRequest, callback func(response *DescribeScdnDomainRealTimeTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainRealTimeTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainRealTimeTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainRealTimeTrafficDataRequest is the request struct for api DescribeScdnDomainRealTimeTrafficData
type DescribeScdnDomainRealTimeTrafficDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeScdnDomainRealTimeTrafficDataResponse is the response struct for api DescribeScdnDomainRealTimeTrafficData
type DescribeScdnDomainRealTimeTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime                        string                         `json:"EndTime" xml:"EndTime"`
	StartTime                      string                         `json:"StartTime" xml:"StartTime"`
	RequestId                      string                         `json:"RequestId" xml:"RequestId"`
	DomainName                     string                         `json:"DomainName" xml:"DomainName"`
	DataInterval                   string                         `json:"DataInterval" xml:"DataInterval"`
	RealTimeTrafficDataPerInterval RealTimeTrafficDataPerInterval `json:"RealTimeTrafficDataPerInterval" xml:"RealTimeTrafficDataPerInterval"`
}

// CreateDescribeScdnDomainRealTimeTrafficDataRequest creates a request to invoke DescribeScdnDomainRealTimeTrafficData API
func CreateDescribeScdnDomainRealTimeTrafficDataRequest() (request *DescribeScdnDomainRealTimeTrafficDataRequest) {
	request = &DescribeScdnDomainRealTimeTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainRealTimeTrafficData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnDomainRealTimeTrafficDataResponse creates a response to parse from DescribeScdnDomainRealTimeTrafficData response
func CreateDescribeScdnDomainRealTimeTrafficDataResponse() (response *DescribeScdnDomainRealTimeTrafficDataResponse) {
	response = &DescribeScdnDomainRealTimeTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
