package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshScdnObjectCaches invokes the scdn.RefreshScdnObjectCaches API synchronously
func (client *Client) RefreshScdnObjectCaches(request *RefreshScdnObjectCachesRequest) (response *RefreshScdnObjectCachesResponse, err error) {
	response = CreateRefreshScdnObjectCachesResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshScdnObjectCachesWithChan invokes the scdn.RefreshScdnObjectCaches API asynchronously
func (client *Client) RefreshScdnObjectCachesWithChan(request *RefreshScdnObjectCachesRequest) (<-chan *RefreshScdnObjectCachesResponse, <-chan error) {
	responseChan := make(chan *RefreshScdnObjectCachesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshScdnObjectCaches(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshScdnObjectCachesWithCallback invokes the scdn.RefreshScdnObjectCaches API asynchronously
func (client *Client) RefreshScdnObjectCachesWithCallback(request *RefreshScdnObjectCachesRequest, callback func(response *RefreshScdnObjectCachesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshScdnObjectCachesResponse
		var err error
		defer close(result)
		response, err = client.RefreshScdnObjectCaches(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshScdnObjectCachesRequest is the request struct for api RefreshScdnObjectCaches
type RefreshScdnObjectCachesRequest struct {
	*requests.RpcRequest
	ObjectPath    string           `position:"Query" name:"ObjectPath"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ObjectType    string           `position:"Query" name:"ObjectType"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// RefreshScdnObjectCachesResponse is the response struct for api RefreshScdnObjectCaches
type RefreshScdnObjectCachesResponse struct {
	*responses.BaseResponse
	RefreshTaskId string `json:"RefreshTaskId" xml:"RefreshTaskId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateRefreshScdnObjectCachesRequest creates a request to invoke RefreshScdnObjectCaches API
func CreateRefreshScdnObjectCachesRequest() (request *RefreshScdnObjectCachesRequest) {
	request = &RefreshScdnObjectCachesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "RefreshScdnObjectCaches", "", "")
	request.Method = requests.POST
	return
}

// CreateRefreshScdnObjectCachesResponse creates a response to parse from RefreshScdnObjectCaches response
func CreateRefreshScdnObjectCachesResponse() (response *RefreshScdnObjectCachesResponse) {
	response = &RefreshScdnObjectCachesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
