package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLables invokes the schedulerx3.ListLables API synchronously
func (client *Client) ListLables(request *ListLablesRequest) (response *ListLablesResponse, err error) {
	response = CreateListLablesResponse()
	err = client.DoAction(request, response)
	return
}

// ListLablesWithChan invokes the schedulerx3.ListLables API asynchronously
func (client *Client) ListLablesWithChan(request *ListLablesRequest) (<-chan *ListLablesResponse, <-chan error) {
	responseChan := make(chan *ListLablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLablesWithCallback invokes the schedulerx3.ListLables API asynchronously
func (client *Client) ListLablesWithCallback(request *ListLablesRequest, callback func(response *ListLablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLablesResponse
		var err error
		defer close(result)
		response, err = client.ListLables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLablesRequest is the request struct for api ListLables
type ListLablesRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	JobId        requests.Integer `position:"Query" name:"JobId"`
	AppName      string           `position:"Query" name:"AppName"`
}

// ListLablesResponse is the response struct for api ListLables
type ListLablesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListLablesRequest creates a request to invoke ListLables API
func CreateListLablesRequest() (request *ListLablesRequest) {
	request = &ListLablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListLables", "", "")
	request.Method = requests.GET
	return
}

// CreateListLablesResponse creates a response to parse from ListLables response
func CreateListLablesResponse() (response *ListLablesResponse) {
	response = &ListLablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
