package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGrantedRoleIds invokes the scsp.GetGrantedRoleIds API synchronously
func (client *Client) GetGrantedRoleIds(request *GetGrantedRoleIdsRequest) (response *GetGrantedRoleIdsResponse, err error) {
	response = CreateGetGrantedRoleIdsResponse()
	err = client.DoAction(request, response)
	return
}

// GetGrantedRoleIdsWithChan invokes the scsp.GetGrantedRoleIds API asynchronously
func (client *Client) GetGrantedRoleIdsWithChan(request *GetGrantedRoleIdsRequest) (<-chan *GetGrantedRoleIdsResponse, <-chan error) {
	responseChan := make(chan *GetGrantedRoleIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGrantedRoleIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGrantedRoleIdsWithCallback invokes the scsp.GetGrantedRoleIds API asynchronously
func (client *Client) GetGrantedRoleIdsWithCallback(request *GetGrantedRoleIdsRequest, callback func(response *GetGrantedRoleIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGrantedRoleIdsResponse
		var err error
		defer close(result)
		response, err = client.GetGrantedRoleIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGrantedRoleIdsRequest is the request struct for api GetGrantedRoleIds
type GetGrantedRoleIdsRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query"`
	InstanceId  string `position:"Query"`
	AccountName string `position:"Query"`
}

// GetGrantedRoleIdsResponse is the response struct for api GetGrantedRoleIds
type GetGrantedRoleIdsResponse struct {
	*responses.BaseResponse
	Message        string  `json:"Message" xml:"Message"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Code           string  `json:"Code" xml:"Code"`
	Success        bool    `json:"Success" xml:"Success"`
	HttpStatusCode int64   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           []int64 `json:"Data" xml:"Data"`
}

// CreateGetGrantedRoleIdsRequest creates a request to invoke GetGrantedRoleIds API
func CreateGetGrantedRoleIdsRequest() (request *GetGrantedRoleIdsRequest) {
	request = &GetGrantedRoleIdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetGrantedRoleIds", "", "")
	request.Method = requests.GET
	return
}

// CreateGetGrantedRoleIdsResponse creates a response to parse from GetGrantedRoleIds response
func CreateGetGrantedRoleIdsResponse() (response *GetGrantedRoleIdsResponse) {
	response = &GetGrantedRoleIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
