package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartChatWork invokes the scsp.StartChatWork API synchronously
func (client *Client) StartChatWork(request *StartChatWorkRequest) (response *StartChatWorkResponse, err error) {
	response = CreateStartChatWorkResponse()
	err = client.DoAction(request, response)
	return
}

// StartChatWorkWithChan invokes the scsp.StartChatWork API asynchronously
func (client *Client) StartChatWorkWithChan(request *StartChatWorkRequest) (<-chan *StartChatWorkResponse, <-chan error) {
	responseChan := make(chan *StartChatWorkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartChatWork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartChatWorkWithCallback invokes the scsp.StartChatWork API asynchronously
func (client *Client) StartChatWorkWithCallback(request *StartChatWorkRequest, callback func(response *StartChatWorkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartChatWorkResponse
		var err error
		defer close(result)
		response, err = client.StartChatWork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartChatWorkRequest is the request struct for api StartChatWork
type StartChatWorkRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Body"`
	AccountName string           `position:"Body"`
	StationType string           `position:"Body"`
	WorkType    requests.Integer `position:"Body"`
	UserAgent   string           `position:"Body"`
}

// StartChatWorkResponse is the response struct for api StartChatWork
type StartChatWorkResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateStartChatWorkRequest creates a request to invoke StartChatWork API
func CreateStartChatWorkRequest() (request *StartChatWorkRequest) {
	request = &StartChatWorkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "StartChatWork", "", "")
	request.Method = requests.POST
	return
}

// CreateStartChatWorkResponse creates a response to parse from StartChatWork response
func CreateStartChatWorkResponse() (response *StartChatWorkResponse) {
	response = &StartChatWorkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
