package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeParentInstance invokes the sddp.DescribeParentInstance API synchronously
func (client *Client) DescribeParentInstance(request *DescribeParentInstanceRequest) (response *DescribeParentInstanceResponse, err error) {
	response = CreateDescribeParentInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeParentInstanceWithChan invokes the sddp.DescribeParentInstance API asynchronously
func (client *Client) DescribeParentInstanceWithChan(request *DescribeParentInstanceRequest) (<-chan *DescribeParentInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeParentInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeParentInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeParentInstanceWithCallback invokes the sddp.DescribeParentInstance API asynchronously
func (client *Client) DescribeParentInstanceWithCallback(request *DescribeParentInstanceRequest, callback func(response *DescribeParentInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeParentInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeParentInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeParentInstanceRequest is the request struct for api DescribeParentInstance
type DescribeParentInstanceRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CheckStatus     requests.Integer `position:"Query" name:"CheckStatus"`
	Lang            string           `position:"Query" name:"Lang"`
	ServiceRegionId string           `position:"Query" name:"ServiceRegionId"`
	EngineType      string           `position:"Query" name:"EngineType"`
	ClusterStatus   string           `position:"Query" name:"ClusterStatus"`
	AuthStatus      requests.Integer `position:"Query" name:"AuthStatus"`
	FeatureType     requests.Integer `position:"Query" name:"FeatureType"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	ResourceType    requests.Integer `position:"Query" name:"ResourceType"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	DbName          string           `position:"Query" name:"DbName"`
}

// DescribeParentInstanceResponse is the response struct for api DescribeParentInstance
type DescribeParentInstanceResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	Items       []Data `json:"Items" xml:"Items"`
}

// CreateDescribeParentInstanceRequest creates a request to invoke DescribeParentInstance API
func CreateDescribeParentInstanceRequest() (request *DescribeParentInstanceRequest) {
	request = &DescribeParentInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeParentInstance", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeParentInstanceResponse creates a response to parse from DescribeParentInstance response
func CreateDescribeParentInstanceResponse() (response *DescribeParentInstanceResponse) {
	response = &DescribeParentInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
