package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecurityIPList invokes the selectdb.DescribeSecurityIPList API synchronously
func (client *Client) DescribeSecurityIPList(request *DescribeSecurityIPListRequest) (response *DescribeSecurityIPListResponse, err error) {
	response = CreateDescribeSecurityIPListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecurityIPListWithChan invokes the selectdb.DescribeSecurityIPList API asynchronously
func (client *Client) DescribeSecurityIPListWithChan(request *DescribeSecurityIPListRequest) (<-chan *DescribeSecurityIPListResponse, <-chan error) {
	responseChan := make(chan *DescribeSecurityIPListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecurityIPList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecurityIPListWithCallback invokes the selectdb.DescribeSecurityIPList API asynchronously
func (client *Client) DescribeSecurityIPListWithCallback(request *DescribeSecurityIPListRequest, callback func(response *DescribeSecurityIPListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecurityIPListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecurityIPList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecurityIPListRequest is the request struct for api DescribeSecurityIPList
type DescribeSecurityIPListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceId    string           `position:"Query" name:"DBInstanceId"`
}

// DescribeSecurityIPListResponse is the response struct for api DescribeSecurityIPList
type DescribeSecurityIPListResponse struct {
	*responses.BaseResponse
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	DBInstanceName string           `json:"DBInstanceName" xml:"DBInstanceName"`
	GroupItems     []GroupItemsItem `json:"GroupItems" xml:"GroupItems"`
}

// CreateDescribeSecurityIPListRequest creates a request to invoke DescribeSecurityIPList API
func CreateDescribeSecurityIPListRequest() (request *DescribeSecurityIPListRequest) {
	request = &DescribeSecurityIPListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "DescribeSecurityIPList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSecurityIPListResponse creates a response to parse from DescribeSecurityIPList response
func CreateDescribeSecurityIPListResponse() (response *DescribeSecurityIPListResponse) {
	response = &DescribeSecurityIPListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
