package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProcessTaskCount invokes the sophonsoar.DescribeProcessTaskCount API synchronously
func (client *Client) DescribeProcessTaskCount(request *DescribeProcessTaskCountRequest) (response *DescribeProcessTaskCountResponse, err error) {
	response = CreateDescribeProcessTaskCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProcessTaskCountWithChan invokes the sophonsoar.DescribeProcessTaskCount API asynchronously
func (client *Client) DescribeProcessTaskCountWithChan(request *DescribeProcessTaskCountRequest) (<-chan *DescribeProcessTaskCountResponse, <-chan error) {
	responseChan := make(chan *DescribeProcessTaskCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProcessTaskCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProcessTaskCountWithCallback invokes the sophonsoar.DescribeProcessTaskCount API asynchronously
func (client *Client) DescribeProcessTaskCountWithCallback(request *DescribeProcessTaskCountRequest, callback func(response *DescribeProcessTaskCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProcessTaskCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeProcessTaskCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProcessTaskCountRequest is the request struct for api DescribeProcessTaskCount
type DescribeProcessTaskCountRequest struct {
	*requests.RpcRequest
	EntityUuidList *[]string        `position:"Query" name:"EntityUuidList"  type:"Repeated"`
	RoleFor        requests.Integer `position:"Query" name:"RoleFor"`
	RoleType       string           `position:"Query" name:"RoleType"`
	Lang           string           `position:"Query" name:"Lang"`
}

// DescribeProcessTaskCountResponse is the response struct for api DescribeProcessTaskCount
type DescribeProcessTaskCountResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeProcessTaskCountRequest creates a request to invoke DescribeProcessTaskCount API
func CreateDescribeProcessTaskCountRequest() (request *DescribeProcessTaskCountRequest) {
	request = &DescribeProcessTaskCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeProcessTaskCount", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeProcessTaskCountResponse creates a response to parse from DescribeProcessTaskCount response
func CreateDescribeProcessTaskCountResponse() (response *DescribeProcessTaskCountResponse) {
	response = &DescribeProcessTaskCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
