package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSophonCommands invokes the sophonsoar.DescribeSophonCommands API synchronously
func (client *Client) DescribeSophonCommands(request *DescribeSophonCommandsRequest) (response *DescribeSophonCommandsResponse, err error) {
	response = CreateDescribeSophonCommandsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSophonCommandsWithChan invokes the sophonsoar.DescribeSophonCommands API asynchronously
func (client *Client) DescribeSophonCommandsWithChan(request *DescribeSophonCommandsRequest) (<-chan *DescribeSophonCommandsResponse, <-chan error) {
	responseChan := make(chan *DescribeSophonCommandsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSophonCommands(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSophonCommandsWithCallback invokes the sophonsoar.DescribeSophonCommands API asynchronously
func (client *Client) DescribeSophonCommandsWithCallback(request *DescribeSophonCommandsRequest, callback func(response *DescribeSophonCommandsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSophonCommandsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSophonCommands(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSophonCommandsRequest is the request struct for api DescribeSophonCommands
type DescribeSophonCommandsRequest struct {
	*requests.RpcRequest
	ActionType string `position:"Query" name:"ActionType"`
	RoleFor    string `position:"Query" name:"RoleFor"`
	Name       string `position:"Query" name:"Name"`
	RoleType   string `position:"Query" name:"RoleType"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeSophonCommandsResponse is the response struct for api DescribeSophonCommands
type DescribeSophonCommandsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeSophonCommandsRequest creates a request to invoke DescribeSophonCommands API
func CreateDescribeSophonCommandsRequest() (request *DescribeSophonCommandsRequest) {
	request = &DescribeSophonCommandsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeSophonCommands", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSophonCommandsResponse creates a response to parse from DescribeSophonCommands response
func CreateDescribeSophonCommandsResponse() (response *DescribeSophonCommandsResponse) {
	response = &DescribeSophonCommandsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
