package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyComponentAsset invokes the sophonsoar.ModifyComponentAsset API synchronously
func (client *Client) ModifyComponentAsset(request *ModifyComponentAssetRequest) (response *ModifyComponentAssetResponse, err error) {
	response = CreateModifyComponentAssetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyComponentAssetWithChan invokes the sophonsoar.ModifyComponentAsset API asynchronously
func (client *Client) ModifyComponentAssetWithChan(request *ModifyComponentAssetRequest) (<-chan *ModifyComponentAssetResponse, <-chan error) {
	responseChan := make(chan *ModifyComponentAssetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyComponentAsset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyComponentAssetWithCallback invokes the sophonsoar.ModifyComponentAsset API asynchronously
func (client *Client) ModifyComponentAssetWithCallback(request *ModifyComponentAssetRequest, callback func(response *ModifyComponentAssetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyComponentAssetResponse
		var err error
		defer close(result)
		response, err = client.ModifyComponentAsset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyComponentAssetRequest is the request struct for api ModifyComponentAsset
type ModifyComponentAssetRequest struct {
	*requests.RpcRequest
	RoleFor     string `position:"Query" name:"RoleFor"`
	RoleType    string `position:"Query" name:"RoleType"`
	Lang        string `position:"Query" name:"Lang"`
	AssetConfig string `position:"Query" name:"AssetConfig"`
}

// ModifyComponentAssetResponse is the response struct for api ModifyComponentAsset
type ModifyComponentAssetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyComponentAssetRequest creates a request to invoke ModifyComponentAsset API
func CreateModifyComponentAssetRequest() (request *ModifyComponentAssetRequest) {
	request = &ModifyComponentAssetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "ModifyComponentAsset", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyComponentAssetResponse creates a response to parse from ModifyComponentAsset response
func CreateModifyComponentAssetResponse() (response *ModifyComponentAssetResponse) {
	response = &ModifyComponentAssetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
