package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPersonList invokes the vcs.GetPersonList API synchronously
func (client *Client) GetPersonList(request *GetPersonListRequest) (response *GetPersonListResponse, err error) {
	response = CreateGetPersonListResponse()
	err = client.DoAction(request, response)
	return
}

// GetPersonListWithChan invokes the vcs.GetPersonList API asynchronously
func (client *Client) GetPersonListWithChan(request *GetPersonListRequest) (<-chan *GetPersonListResponse, <-chan error) {
	responseChan := make(chan *GetPersonListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPersonList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPersonListWithCallback invokes the vcs.GetPersonList API asynchronously
func (client *Client) GetPersonListWithCallback(request *GetPersonListRequest, callback func(response *GetPersonListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPersonListResponse
		var err error
		defer close(result)
		response, err = client.GetPersonList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPersonListRequest is the request struct for api GetPersonList
type GetPersonListRequest struct {
	*requests.RpcRequest
	CorpId                    string                 `position:"Body" name:"CorpId"`
	FaceMatchingRateThreshold string                 `position:"Body" name:"FaceMatchingRateThreshold"`
	PageNumber                requests.Integer       `position:"Body" name:"PageNumber"`
	CorpIdList                map[string]interface{} `position:"Body" name:"CorpIdList"`
	FaceUrl                   string                 `position:"Body" name:"FaceUrl"`
	PageSize                  requests.Integer       `position:"Body" name:"PageSize"`
	PersonIdList              map[string]interface{} `position:"Body" name:"PersonIdList"`
}

// GetPersonListResponse is the response struct for api GetPersonList
type GetPersonListResponse struct {
	*responses.BaseResponse
	Code      string              `json:"Code" xml:"Code"`
	Message   string              `json:"Message" xml:"Message"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Data      DataInGetPersonList `json:"Data" xml:"Data"`
}

// CreateGetPersonListRequest creates a request to invoke GetPersonList API
func CreateGetPersonListRequest() (request *GetPersonListRequest) {
	request = &GetPersonListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "GetPersonList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPersonListResponse creates a response to parse from GetPersonList response
func CreateGetPersonListResponse() (response *GetPersonListResponse) {
	response = &GetPersonListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
