package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCatalogs invokes the ververica.ListCatalogs API synchronously
func (client *Client) ListCatalogs(request *ListCatalogsRequest) (response *ListCatalogsResponse, err error) {
	response = CreateListCatalogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCatalogsWithChan invokes the ververica.ListCatalogs API asynchronously
func (client *Client) ListCatalogsWithChan(request *ListCatalogsRequest) (<-chan *ListCatalogsResponse, <-chan error) {
	responseChan := make(chan *ListCatalogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCatalogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCatalogsWithCallback invokes the ververica.ListCatalogs API asynchronously
func (client *Client) ListCatalogsWithCallback(request *ListCatalogsRequest, callback func(response *ListCatalogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCatalogsResponse
		var err error
		defer close(result)
		response, err = client.ListCatalogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCatalogsRequest is the request struct for api ListCatalogs
type ListCatalogsRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
}

// ListCatalogsResponse is the response struct for api ListCatalogs
type ListCatalogsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListCatalogsRequest creates a request to invoke ListCatalogs API
func CreateListCatalogsRequest() (request *ListCatalogsRequest) {
	request = &ListCatalogsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListCatalogs", "/pop/workspaces/[workspace]/catalog/v1beta2/namespaces/[namespace]/catalogs", "", "")
	request.Method = requests.GET
	return
}

// CreateListCatalogsResponse creates a response to parse from ListCatalogs response
func CreateListCatalogsResponse() (response *ListCatalogsResponse) {
	response = &ListCatalogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
