package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadFileNameList invokes the viapi_regen.DownloadFileNameList API synchronously
func (client *Client) DownloadFileNameList(request *DownloadFileNameListRequest) (response *DownloadFileNameListResponse, err error) {
	response = CreateDownloadFileNameListResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadFileNameListWithChan invokes the viapi_regen.DownloadFileNameList API asynchronously
func (client *Client) DownloadFileNameListWithChan(request *DownloadFileNameListRequest) (<-chan *DownloadFileNameListResponse, <-chan error) {
	responseChan := make(chan *DownloadFileNameListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadFileNameList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadFileNameListWithCallback invokes the viapi_regen.DownloadFileNameList API asynchronously
func (client *Client) DownloadFileNameListWithCallback(request *DownloadFileNameListRequest, callback func(response *DownloadFileNameListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadFileNameListResponse
		var err error
		defer close(result)
		response, err = client.DownloadFileNameList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadFileNameListRequest is the request struct for api DownloadFileNameList
type DownloadFileNameListRequest struct {
	*requests.RpcRequest
	Identity  string           `position:"Body" name:"Identity"`
	DatasetId requests.Integer `position:"Body" name:"DatasetId"`
}

// DownloadFileNameListResponse is the response struct for api DownloadFileNameList
type DownloadFileNameListResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDownloadFileNameListRequest creates a request to invoke DownloadFileNameList API
func CreateDownloadFileNameListRequest() (request *DownloadFileNameListRequest) {
	request = &DownloadFileNameListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "DownloadFileNameList", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDownloadFileNameListResponse creates a response to parse from DownloadFileNameList response
func CreateDownloadFileNameListResponse() (response *DownloadFileNameListResponse) {
	response = &DownloadFileNameListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
