package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceQps invokes the viapi_regen.GetServiceQps API synchronously
func (client *Client) GetServiceQps(request *GetServiceQpsRequest) (response *GetServiceQpsResponse, err error) {
	response = CreateGetServiceQpsResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceQpsWithChan invokes the viapi_regen.GetServiceQps API asynchronously
func (client *Client) GetServiceQpsWithChan(request *GetServiceQpsRequest) (<-chan *GetServiceQpsResponse, <-chan error) {
	responseChan := make(chan *GetServiceQpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceQps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceQpsWithCallback invokes the viapi_regen.GetServiceQps API asynchronously
func (client *Client) GetServiceQpsWithCallback(request *GetServiceQpsRequest, callback func(response *GetServiceQpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceQpsResponse
		var err error
		defer close(result)
		response, err = client.GetServiceQps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceQpsRequest is the request struct for api GetServiceQps
type GetServiceQpsRequest struct {
	*requests.RpcRequest
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Id                 requests.Integer `position:"Body" name:"Id"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	CallerParentIdList *[]string        `position:"Body" name:"CallerParentIdList"  type:"Json"`
}

// GetServiceQpsResponse is the response struct for api GetServiceQps
type GetServiceQpsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetServiceQpsRequest creates a request to invoke GetServiceQps API
func CreateGetServiceQpsRequest() (request *GetServiceQpsRequest) {
	request = &GetServiceQpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "GetServiceQps", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceQpsResponse creates a response to parse from GetServiceQps response
func CreateGetServiceQpsResponse() (response *GetServiceQpsResponse) {
	response = &GetServiceQpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
