package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTrainTask invokes the viapi_regen.StopTrainTask API synchronously
func (client *Client) StopTrainTask(request *StopTrainTaskRequest) (response *StopTrainTaskResponse, err error) {
	response = CreateStopTrainTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopTrainTaskWithChan invokes the viapi_regen.StopTrainTask API asynchronously
func (client *Client) StopTrainTaskWithChan(request *StopTrainTaskRequest) (<-chan *StopTrainTaskResponse, <-chan error) {
	responseChan := make(chan *StopTrainTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTrainTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTrainTaskWithCallback invokes the viapi_regen.StopTrainTask API asynchronously
func (client *Client) StopTrainTaskWithCallback(request *StopTrainTaskRequest, callback func(response *StopTrainTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTrainTaskResponse
		var err error
		defer close(result)
		response, err = client.StopTrainTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTrainTaskRequest is the request struct for api StopTrainTask
type StopTrainTaskRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// StopTrainTaskResponse is the response struct for api StopTrainTask
type StopTrainTaskResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateStopTrainTaskRequest creates a request to invoke StopTrainTask API
func CreateStopTrainTaskRequest() (request *StopTrainTaskRequest) {
	request = &StopTrainTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "StopTrainTask", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopTrainTaskResponse creates a response to parse from StopTrainTask response
func CreateStopTrainTaskResponse() (response *StopTrainTaskResponse) {
	response = &StopTrainTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
