package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainBpsDataByLayer invokes the vod.DescribeVodDomainBpsDataByLayer API synchronously
func (client *Client) DescribeVodDomainBpsDataByLayer(request *DescribeVodDomainBpsDataByLayerRequest) (response *DescribeVodDomainBpsDataByLayerResponse, err error) {
	response = CreateDescribeVodDomainBpsDataByLayerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainBpsDataByLayerWithChan invokes the vod.DescribeVodDomainBpsDataByLayer API asynchronously
func (client *Client) DescribeVodDomainBpsDataByLayerWithChan(request *DescribeVodDomainBpsDataByLayerRequest) (<-chan *DescribeVodDomainBpsDataByLayerResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainBpsDataByLayerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainBpsDataByLayer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainBpsDataByLayerWithCallback invokes the vod.DescribeVodDomainBpsDataByLayer API asynchronously
func (client *Client) DescribeVodDomainBpsDataByLayerWithCallback(request *DescribeVodDomainBpsDataByLayerRequest, callback func(response *DescribeVodDomainBpsDataByLayerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainBpsDataByLayerResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainBpsDataByLayer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainBpsDataByLayerRequest is the request struct for api DescribeVodDomainBpsDataByLayer
type DescribeVodDomainBpsDataByLayerRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	Layer          string           `position:"Query" name:"Layer"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeVodDomainBpsDataByLayerResponse is the response struct for api DescribeVodDomainBpsDataByLayer
type DescribeVodDomainBpsDataByLayerResponse struct {
	*responses.BaseResponse
	DataInterval    int             `json:"DataInterval" xml:"DataInterval"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	BpsDataInterval BpsDataInterval `json:"BpsDataInterval" xml:"BpsDataInterval"`
}

// CreateDescribeVodDomainBpsDataByLayerRequest creates a request to invoke DescribeVodDomainBpsDataByLayer API
func CreateDescribeVodDomainBpsDataByLayerRequest() (request *DescribeVodDomainBpsDataByLayerRequest) {
	request = &DescribeVodDomainBpsDataByLayerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainBpsDataByLayer", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainBpsDataByLayerResponse creates a response to parse from DescribeVodDomainBpsDataByLayer response
func CreateDescribeVodDomainBpsDataByLayerResponse() (response *DescribeVodDomainBpsDataByLayerResponse) {
	response = &DescribeVodDomainBpsDataByLayerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
