package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckVpnBgpEnabled invokes the vpc.CheckVpnBgpEnabled API synchronously
func (client *Client) CheckVpnBgpEnabled(request *CheckVpnBgpEnabledRequest) (response *CheckVpnBgpEnabledResponse, err error) {
	response = CreateCheckVpnBgpEnabledResponse()
	err = client.DoAction(request, response)
	return
}

// CheckVpnBgpEnabledWithChan invokes the vpc.CheckVpnBgpEnabled API asynchronously
func (client *Client) CheckVpnBgpEnabledWithChan(request *CheckVpnBgpEnabledRequest) (<-chan *CheckVpnBgpEnabledResponse, <-chan error) {
	responseChan := make(chan *CheckVpnBgpEnabledResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckVpnBgpEnabled(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckVpnBgpEnabledWithCallback invokes the vpc.CheckVpnBgpEnabled API asynchronously
func (client *Client) CheckVpnBgpEnabledWithCallback(request *CheckVpnBgpEnabledRequest, callback func(response *CheckVpnBgpEnabledResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckVpnBgpEnabledResponse
		var err error
		defer close(result)
		response, err = client.CheckVpnBgpEnabled(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckVpnBgpEnabledRequest is the request struct for api CheckVpnBgpEnabled
type CheckVpnBgpEnabledRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
}

// CheckVpnBgpEnabledResponse is the response struct for api CheckVpnBgpEnabled
type CheckVpnBgpEnabledResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	BgpEnabled bool   `json:"BgpEnabled" xml:"BgpEnabled"`
}

// CreateCheckVpnBgpEnabledRequest creates a request to invoke CheckVpnBgpEnabled API
func CreateCheckVpnBgpEnabledRequest() (request *CheckVpnBgpEnabledRequest) {
	request = &CheckVpnBgpEnabledRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CheckVpnBgpEnabled", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckVpnBgpEnabledResponse creates a response to parse from CheckVpnBgpEnabled response
func CreateCheckVpnBgpEnabledResponse() (response *CheckVpnBgpEnabledResponse) {
	response = &CheckVpnBgpEnabledResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
