package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHighReliablePhysicalConnection invokes the vpc.CreateHighReliablePhysicalConnection API synchronously
func (client *Client) CreateHighReliablePhysicalConnection(request *CreateHighReliablePhysicalConnectionRequest) (response *CreateHighReliablePhysicalConnectionResponse, err error) {
	response = CreateCreateHighReliablePhysicalConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHighReliablePhysicalConnectionWithChan invokes the vpc.CreateHighReliablePhysicalConnection API asynchronously
func (client *Client) CreateHighReliablePhysicalConnectionWithChan(request *CreateHighReliablePhysicalConnectionRequest) (<-chan *CreateHighReliablePhysicalConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateHighReliablePhysicalConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHighReliablePhysicalConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHighReliablePhysicalConnectionWithCallback invokes the vpc.CreateHighReliablePhysicalConnection API asynchronously
func (client *Client) CreateHighReliablePhysicalConnectionWithCallback(request *CreateHighReliablePhysicalConnectionRequest, callback func(response *CreateHighReliablePhysicalConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHighReliablePhysicalConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateHighReliablePhysicalConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHighReliablePhysicalConnectionRequest is the request struct for api CreateHighReliablePhysicalConnection
type CreateHighReliablePhysicalConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                              `position:"Query" name:"ResourceOwnerId"`
	PortType               string                                        `position:"Query" name:"PortType"`
	ClientToken            string                                        `position:"Query" name:"ClientToken"`
	HighReliableType       string                                        `position:"Query" name:"HighReliableType"`
	ResourceGroupId        string                                        `position:"Query" name:"ResourceGroupId"`
	Tag                    *[]CreateHighReliablePhysicalConnectionTag    `position:"Query" name:"Tag"  type:"Repeated"`
	DryRun                 string                                        `position:"Query" name:"DryRun"`
	ResourceOwnerAccount   string                                        `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string                                        `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer                              `position:"Query" name:"OwnerId"`
	ApList                 *[]CreateHighReliablePhysicalConnectionApList `position:"Query" name:"ApList"  type:"Repeated"`
	AcceptLanguage         string                                        `position:"Query" name:"AcceptLanguage"`
	DeviceAdvancedCapacity *[]string                                     `position:"Query" name:"DeviceAdvancedCapacity"  type:"Repeated"`
}

// CreateHighReliablePhysicalConnectionTag is a repeated param struct in CreateHighReliablePhysicalConnectionRequest
type CreateHighReliablePhysicalConnectionTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateHighReliablePhysicalConnectionApList is a repeated param struct in CreateHighReliablePhysicalConnectionRequest
type CreateHighReliablePhysicalConnectionApList struct {
	Name          string `name:"Name"`
	Description   string `name:"Description"`
	RegionId      string `name:"RegionId"`
	LineOperator  string `name:"LineOperator"`
	AccessPointId string `name:"AccessPointId"`
	PortNum       string `name:"PortNum"`
	Type          string `name:"Type"`
	Bandwidth     string `name:"Bandwidth"`
	PeerLocation  string `name:"PeerLocation"`
	CircuitCode   string `name:"CircuitCode"`
}

// CreateHighReliablePhysicalConnectionResponse is the response struct for api CreateHighReliablePhysicalConnection
type CreateHighReliablePhysicalConnectionResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	PhysicalConnectionList PhysicalConnectionList `json:"PhysicalConnectionList" xml:"PhysicalConnectionList"`
	ErrorInfoList          ErrorInfoList          `json:"ErrorInfoList" xml:"ErrorInfoList"`
}

// CreateCreateHighReliablePhysicalConnectionRequest creates a request to invoke CreateHighReliablePhysicalConnection API
func CreateCreateHighReliablePhysicalConnectionRequest() (request *CreateHighReliablePhysicalConnectionRequest) {
	request = &CreateHighReliablePhysicalConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateHighReliablePhysicalConnection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHighReliablePhysicalConnectionResponse creates a response to parse from CreateHighReliablePhysicalConnection response
func CreateCreateHighReliablePhysicalConnectionResponse() (response *CreateHighReliablePhysicalConnectionResponse) {
	response = &CreateHighReliablePhysicalConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
