package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStreamVodList invokes the vs.DescribeStreamVodList API synchronously
func (client *Client) DescribeStreamVodList(request *DescribeStreamVodListRequest) (response *DescribeStreamVodListResponse, err error) {
	response = CreateDescribeStreamVodListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStreamVodListWithChan invokes the vs.DescribeStreamVodList API asynchronously
func (client *Client) DescribeStreamVodListWithChan(request *DescribeStreamVodListRequest) (<-chan *DescribeStreamVodListResponse, <-chan error) {
	responseChan := make(chan *DescribeStreamVodListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStreamVodList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStreamVodListWithCallback invokes the vs.DescribeStreamVodList API asynchronously
func (client *Client) DescribeStreamVodListWithCallback(request *DescribeStreamVodListRequest, callback func(response *DescribeStreamVodListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStreamVodListResponse
		var err error
		defer close(result)
		response, err = client.DescribeStreamVodList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStreamVodListRequest is the request struct for api DescribeStreamVodList
type DescribeStreamVodListRequest struct {
	*requests.RpcRequest
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	Id        string           `position:"Query" name:"Id"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeStreamVodListResponse is the response struct for api DescribeStreamVodList
type DescribeStreamVodListResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Records   []RecordInDescribeStreamVodList `json:"Records" xml:"Records"`
}

// CreateDescribeStreamVodListRequest creates a request to invoke DescribeStreamVodList API
func CreateDescribeStreamVodListRequest() (request *DescribeStreamVodListRequest) {
	request = &DescribeStreamVodListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeStreamVodList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeStreamVodListResponse creates a response to parse from DescribeStreamVodList response
func CreateDescribeStreamVodListResponse() (response *DescribeStreamVodListResponse) {
	response = &DescribeStreamVodListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
