// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/data_retention_deletion_event.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of the DRD event.
type DataRetentionDeletionEvent_EventType int32

const (
	// Unspecified event type.
	DataRetentionDeletionEvent_EVENT_TYPE_UNSPECIFIED DataRetentionDeletionEvent_EventType = 0
	// The maximum retention time has been exceeded.
	DataRetentionDeletionEvent_EVENT_TYPE_MAX_TTL_EXCEEDED DataRetentionDeletionEvent_EventType = 1
)

// Enum value maps for DataRetentionDeletionEvent_EventType.
var (
	DataRetentionDeletionEvent_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "EVENT_TYPE_MAX_TTL_EXCEEDED",
	}
	DataRetentionDeletionEvent_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":      0,
		"EVENT_TYPE_MAX_TTL_EXCEEDED": 1,
	}
)

func (x DataRetentionDeletionEvent_EventType) Enum() *DataRetentionDeletionEvent_EventType {
	p := new(DataRetentionDeletionEvent_EventType)
	*p = x
	return p
}

func (x DataRetentionDeletionEvent_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataRetentionDeletionEvent_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_enumTypes[0].Descriptor()
}

func (DataRetentionDeletionEvent_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_enumTypes[0]
}

func (x DataRetentionDeletionEvent_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataRetentionDeletionEvent_EventType.Descriptor instead.
func (DataRetentionDeletionEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescGZIP(), []int{0, 0}
}

// Details about data retention deletion violations, in which the data is
// non-compliant based on their retention or deletion time, as defined in the
// applicable data security policy. The Data Retention Deletion (DRD) control is
// a control of the DSPM (Data Security Posture Management) suite that enables
// organizations to manage data retention and deletion policies in compliance
// with regulations, such as GDPR and CRPA. DRD supports two primary policy
// types: maximum storage length (max TTL) and minimum storage length (min TTL).
// Both are aimed at helping organizations meet regulatory and data management
// commitments.
type DataRetentionDeletionEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp indicating when the event was detected.
	EventDetectionTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_detection_time,json=eventDetectionTime,proto3" json:"event_detection_time,omitempty"`
	// Number of objects that violated the policy for this resource. If the number
	// is less than 1,000, then the value of this field is the exact number. If
	// the number of objects that violated the policy is greater than or equal to
	// 1,000, then the value of this field is 1000.
	DataObjectCount int64 `protobuf:"varint,3,opt,name=data_object_count,json=dataObjectCount,proto3" json:"data_object_count,omitempty"`
	// Maximum duration of retention allowed from the DRD control. This comes
	// from the DRD control where users set a max TTL for their data. For example,
	// suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
	// However, an object in that bucket is 100 days old. In this case, a
	// DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
	// and the max_retention_allowed is 90 days.
	MaxRetentionAllowed *durationpb.Duration `protobuf:"bytes,4,opt,name=max_retention_allowed,json=maxRetentionAllowed,proto3" json:"max_retention_allowed,omitempty"`
	// Type of the DRD event.
	EventType DataRetentionDeletionEvent_EventType `protobuf:"varint,5,opt,name=event_type,json=eventType,proto3,enum=google.cloud.securitycenter.v2.DataRetentionDeletionEvent_EventType" json:"event_type,omitempty"`
}

func (x *DataRetentionDeletionEvent) Reset() {
	*x = DataRetentionDeletionEvent{}
	mi := &file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataRetentionDeletionEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRetentionDeletionEvent) ProtoMessage() {}

func (x *DataRetentionDeletionEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRetentionDeletionEvent.ProtoReflect.Descriptor instead.
func (*DataRetentionDeletionEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescGZIP(), []int{0}
}

func (x *DataRetentionDeletionEvent) GetEventDetectionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventDetectionTime
	}
	return nil
}

func (x *DataRetentionDeletionEvent) GetDataObjectCount() int64 {
	if x != nil {
		return x.DataObjectCount
	}
	return 0
}

func (x *DataRetentionDeletionEvent) GetMaxRetentionAllowed() *durationpb.Duration {
	if x != nil {
		return x.MaxRetentionAllowed
	}
	return nil
}

func (x *DataRetentionDeletionEvent) GetEventType() DataRetentionDeletionEvent_EventType {
	if x != nil {
		return x.EventType
	}
	return DataRetentionDeletionEvent_EVENT_TYPE_UNSPECIFIED
}

var File_google_cloud_securitycenter_v2_data_retention_deletion_event_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x94, 0x03, 0x0a, 0x1a, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x14, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4d,
	0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x63, 0x0a,
	0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x48, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x54,
	0x4c, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x42, 0xf9, 0x01, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x42, 0x1f, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescData = file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_goTypes = []any{
	(DataRetentionDeletionEvent_EventType)(0), // 0: google.cloud.securitycenter.v2.DataRetentionDeletionEvent.EventType
	(*DataRetentionDeletionEvent)(nil),        // 1: google.cloud.securitycenter.v2.DataRetentionDeletionEvent
	(*timestamppb.Timestamp)(nil),             // 2: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),               // 3: google.protobuf.Duration
}
var file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_depIdxs = []int32{
	2, // 0: google.cloud.securitycenter.v2.DataRetentionDeletionEvent.event_detection_time:type_name -> google.protobuf.Timestamp
	3, // 1: google.cloud.securitycenter.v2.DataRetentionDeletionEvent.max_retention_allowed:type_name -> google.protobuf.Duration
	0, // 2: google.cloud.securitycenter.v2.DataRetentionDeletionEvent.event_type:type_name -> google.cloud.securitycenter.v2.DataRetentionDeletionEvent.EventType
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_init() }
func file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_init() {
	if File_google_cloud_securitycenter_v2_data_retention_deletion_event_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_data_retention_deletion_event_proto = out.File
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_data_retention_deletion_event_proto_depIdxs = nil
}
