// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/endpoint_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EndpointService_CreateEndpoint_FullMethodName            = "/google.cloud.aiplatform.v1beta1.EndpointService/CreateEndpoint"
	EndpointService_GetEndpoint_FullMethodName               = "/google.cloud.aiplatform.v1beta1.EndpointService/GetEndpoint"
	EndpointService_ListEndpoints_FullMethodName             = "/google.cloud.aiplatform.v1beta1.EndpointService/ListEndpoints"
	EndpointService_UpdateEndpoint_FullMethodName            = "/google.cloud.aiplatform.v1beta1.EndpointService/UpdateEndpoint"
	EndpointService_UpdateEndpointLongRunning_FullMethodName = "/google.cloud.aiplatform.v1beta1.EndpointService/UpdateEndpointLongRunning"
	EndpointService_DeleteEndpoint_FullMethodName            = "/google.cloud.aiplatform.v1beta1.EndpointService/DeleteEndpoint"
	EndpointService_DeployModel_FullMethodName               = "/google.cloud.aiplatform.v1beta1.EndpointService/DeployModel"
	EndpointService_UndeployModel_FullMethodName             = "/google.cloud.aiplatform.v1beta1.EndpointService/UndeployModel"
	EndpointService_MutateDeployedModel_FullMethodName       = "/google.cloud.aiplatform.v1beta1.EndpointService/MutateDeployedModel"
	EndpointService_SetPublisherModelConfig_FullMethodName   = "/google.cloud.aiplatform.v1beta1.EndpointService/SetPublisherModelConfig"
	EndpointService_FetchPublisherModelConfig_FullMethodName = "/google.cloud.aiplatform.v1beta1.EndpointService/FetchPublisherModelConfig"
)

// EndpointServiceClient is the client API for EndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EndpointServiceClient interface {
	// Creates an Endpoint.
	CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an Endpoint.
	GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Lists Endpoints in a Location.
	ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error)
	// Updates an Endpoint.
	UpdateEndpoint(ctx context.Context, in *UpdateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Updates an Endpoint with a long running operation.
	UpdateEndpointLongRunning(ctx context.Context, in *UpdateEndpointLongRunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an Endpoint.
	DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys a Model into this Endpoint, creating a DeployedModel within it.
	DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys a Model from an Endpoint, removing a DeployedModel from it, and
	// freeing all resources it's using.
	UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing deployed model. Updatable fields include
	// `min_replica_count`, `max_replica_count`, `autoscaling_metric_specs`,
	// `disable_container_logging` (v1 only), and `enable_container_logging`
	// (v1beta1 only).
	MutateDeployedModel(ctx context.Context, in *MutateDeployedModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Sets (creates or updates) configs of publisher models. For example, sets
	// the request/response logging config.
	SetPublisherModelConfig(ctx context.Context, in *SetPublisherModelConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches the configs of publisher models.
	FetchPublisherModelConfig(ctx context.Context, in *FetchPublisherModelConfigRequest, opts ...grpc.CallOption) (*PublisherModelConfig, error)
}

type endpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEndpointServiceClient(cc grpc.ClientConnInterface) EndpointServiceClient {
	return &endpointServiceClient{cc}
}

func (c *endpointServiceClient) CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_CreateEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, EndpointService_GetEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error) {
	out := new(ListEndpointsResponse)
	err := c.cc.Invoke(ctx, EndpointService_ListEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) UpdateEndpoint(ctx context.Context, in *UpdateEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, EndpointService_UpdateEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) UpdateEndpointLongRunning(ctx context.Context, in *UpdateEndpointLongRunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_UpdateEndpointLongRunning_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_DeleteEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_DeployModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_UndeployModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) MutateDeployedModel(ctx context.Context, in *MutateDeployedModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_MutateDeployedModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) SetPublisherModelConfig(ctx context.Context, in *SetPublisherModelConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EndpointService_SetPublisherModelConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *endpointServiceClient) FetchPublisherModelConfig(ctx context.Context, in *FetchPublisherModelConfigRequest, opts ...grpc.CallOption) (*PublisherModelConfig, error) {
	out := new(PublisherModelConfig)
	err := c.cc.Invoke(ctx, EndpointService_FetchPublisherModelConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EndpointServiceServer is the server API for EndpointService service.
// All implementations should embed UnimplementedEndpointServiceServer
// for forward compatibility
type EndpointServiceServer interface {
	// Creates an Endpoint.
	CreateEndpoint(context.Context, *CreateEndpointRequest) (*longrunningpb.Operation, error)
	// Gets an Endpoint.
	GetEndpoint(context.Context, *GetEndpointRequest) (*Endpoint, error)
	// Lists Endpoints in a Location.
	ListEndpoints(context.Context, *ListEndpointsRequest) (*ListEndpointsResponse, error)
	// Updates an Endpoint.
	UpdateEndpoint(context.Context, *UpdateEndpointRequest) (*Endpoint, error)
	// Updates an Endpoint with a long running operation.
	UpdateEndpointLongRunning(context.Context, *UpdateEndpointLongRunningRequest) (*longrunningpb.Operation, error)
	// Deletes an Endpoint.
	DeleteEndpoint(context.Context, *DeleteEndpointRequest) (*longrunningpb.Operation, error)
	// Deploys a Model into this Endpoint, creating a DeployedModel within it.
	DeployModel(context.Context, *DeployModelRequest) (*longrunningpb.Operation, error)
	// Undeploys a Model from an Endpoint, removing a DeployedModel from it, and
	// freeing all resources it's using.
	UndeployModel(context.Context, *UndeployModelRequest) (*longrunningpb.Operation, error)
	// Updates an existing deployed model. Updatable fields include
	// `min_replica_count`, `max_replica_count`, `autoscaling_metric_specs`,
	// `disable_container_logging` (v1 only), and `enable_container_logging`
	// (v1beta1 only).
	MutateDeployedModel(context.Context, *MutateDeployedModelRequest) (*longrunningpb.Operation, error)
	// Sets (creates or updates) configs of publisher models. For example, sets
	// the request/response logging config.
	SetPublisherModelConfig(context.Context, *SetPublisherModelConfigRequest) (*longrunningpb.Operation, error)
	// Fetches the configs of publisher models.
	FetchPublisherModelConfig(context.Context, *FetchPublisherModelConfigRequest) (*PublisherModelConfig, error)
}

// UnimplementedEndpointServiceServer should be embedded to have forward compatible implementations.
type UnimplementedEndpointServiceServer struct {
}

func (UnimplementedEndpointServiceServer) CreateEndpoint(context.Context, *CreateEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEndpoint not implemented")
}
func (UnimplementedEndpointServiceServer) GetEndpoint(context.Context, *GetEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEndpoint not implemented")
}
func (UnimplementedEndpointServiceServer) ListEndpoints(context.Context, *ListEndpointsRequest) (*ListEndpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEndpoints not implemented")
}
func (UnimplementedEndpointServiceServer) UpdateEndpoint(context.Context, *UpdateEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEndpoint not implemented")
}
func (UnimplementedEndpointServiceServer) UpdateEndpointLongRunning(context.Context, *UpdateEndpointLongRunningRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEndpointLongRunning not implemented")
}
func (UnimplementedEndpointServiceServer) DeleteEndpoint(context.Context, *DeleteEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEndpoint not implemented")
}
func (UnimplementedEndpointServiceServer) DeployModel(context.Context, *DeployModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployModel not implemented")
}
func (UnimplementedEndpointServiceServer) UndeployModel(context.Context, *UndeployModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployModel not implemented")
}
func (UnimplementedEndpointServiceServer) MutateDeployedModel(context.Context, *MutateDeployedModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateDeployedModel not implemented")
}
func (UnimplementedEndpointServiceServer) SetPublisherModelConfig(context.Context, *SetPublisherModelConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetPublisherModelConfig not implemented")
}
func (UnimplementedEndpointServiceServer) FetchPublisherModelConfig(context.Context, *FetchPublisherModelConfigRequest) (*PublisherModelConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchPublisherModelConfig not implemented")
}

// UnsafeEndpointServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EndpointServiceServer will
// result in compilation errors.
type UnsafeEndpointServiceServer interface {
	mustEmbedUnimplementedEndpointServiceServer()
}

func RegisterEndpointServiceServer(s grpc.ServiceRegistrar, srv EndpointServiceServer) {
	s.RegisterService(&EndpointService_ServiceDesc, srv)
}

func _EndpointService_CreateEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).CreateEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_CreateEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).CreateEndpoint(ctx, req.(*CreateEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_GetEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).GetEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_GetEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).GetEndpoint(ctx, req.(*GetEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_ListEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).ListEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_ListEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).ListEndpoints(ctx, req.(*ListEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_UpdateEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).UpdateEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_UpdateEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).UpdateEndpoint(ctx, req.(*UpdateEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_UpdateEndpointLongRunning_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEndpointLongRunningRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).UpdateEndpointLongRunning(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_UpdateEndpointLongRunning_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).UpdateEndpointLongRunning(ctx, req.(*UpdateEndpointLongRunningRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_DeleteEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).DeleteEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_DeleteEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).DeleteEndpoint(ctx, req.(*DeleteEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_DeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).DeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_DeployModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).DeployModel(ctx, req.(*DeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_UndeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).UndeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_UndeployModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).UndeployModel(ctx, req.(*UndeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_MutateDeployedModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateDeployedModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).MutateDeployedModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_MutateDeployedModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).MutateDeployedModel(ctx, req.(*MutateDeployedModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_SetPublisherModelConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPublisherModelConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).SetPublisherModelConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_SetPublisherModelConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).SetPublisherModelConfig(ctx, req.(*SetPublisherModelConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EndpointService_FetchPublisherModelConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchPublisherModelConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EndpointServiceServer).FetchPublisherModelConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EndpointService_FetchPublisherModelConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EndpointServiceServer).FetchPublisherModelConfig(ctx, req.(*FetchPublisherModelConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EndpointService_ServiceDesc is the grpc.ServiceDesc for EndpointService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EndpointService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.EndpointService",
	HandlerType: (*EndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEndpoint",
			Handler:    _EndpointService_CreateEndpoint_Handler,
		},
		{
			MethodName: "GetEndpoint",
			Handler:    _EndpointService_GetEndpoint_Handler,
		},
		{
			MethodName: "ListEndpoints",
			Handler:    _EndpointService_ListEndpoints_Handler,
		},
		{
			MethodName: "UpdateEndpoint",
			Handler:    _EndpointService_UpdateEndpoint_Handler,
		},
		{
			MethodName: "UpdateEndpointLongRunning",
			Handler:    _EndpointService_UpdateEndpointLongRunning_Handler,
		},
		{
			MethodName: "DeleteEndpoint",
			Handler:    _EndpointService_DeleteEndpoint_Handler,
		},
		{
			MethodName: "DeployModel",
			Handler:    _EndpointService_DeployModel_Handler,
		},
		{
			MethodName: "UndeployModel",
			Handler:    _EndpointService_UndeployModel_Handler,
		},
		{
			MethodName: "MutateDeployedModel",
			Handler:    _EndpointService_MutateDeployedModel_Handler,
		},
		{
			MethodName: "SetPublisherModelConfig",
			Handler:    _EndpointService_SetPublisherModelConfig_Handler,
		},
		{
			MethodName: "FetchPublisherModelConfig",
			Handler:    _EndpointService_FetchPublisherModelConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/endpoint_service.proto",
}
