// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/gen_ai_cache_service.proto

package aiplatformpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GenAiCacheService_CreateCachedContent_FullMethodName = "/google.cloud.aiplatform.v1beta1.GenAiCacheService/CreateCachedContent"
	GenAiCacheService_GetCachedContent_FullMethodName    = "/google.cloud.aiplatform.v1beta1.GenAiCacheService/GetCachedContent"
	GenAiCacheService_UpdateCachedContent_FullMethodName = "/google.cloud.aiplatform.v1beta1.GenAiCacheService/UpdateCachedContent"
	GenAiCacheService_DeleteCachedContent_FullMethodName = "/google.cloud.aiplatform.v1beta1.GenAiCacheService/DeleteCachedContent"
	GenAiCacheService_ListCachedContents_FullMethodName  = "/google.cloud.aiplatform.v1beta1.GenAiCacheService/ListCachedContents"
)

// GenAiCacheServiceClient is the client API for GenAiCacheService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GenAiCacheServiceClient interface {
	// Creates cached content, this call will initialize the cached content in the
	// data storage, and users need to pay for the cache data storage.
	CreateCachedContent(ctx context.Context, in *CreateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Gets cached content configurations
	GetCachedContent(ctx context.Context, in *GetCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Updates cached content configurations
	UpdateCachedContent(ctx context.Context, in *UpdateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Deletes cached content
	DeleteCachedContent(ctx context.Context, in *DeleteCachedContentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists cached contents in a project
	ListCachedContents(ctx context.Context, in *ListCachedContentsRequest, opts ...grpc.CallOption) (*ListCachedContentsResponse, error)
}

type genAiCacheServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGenAiCacheServiceClient(cc grpc.ClientConnInterface) GenAiCacheServiceClient {
	return &genAiCacheServiceClient{cc}
}

func (c *genAiCacheServiceClient) CreateCachedContent(ctx context.Context, in *CreateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, GenAiCacheService_CreateCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *genAiCacheServiceClient) GetCachedContent(ctx context.Context, in *GetCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, GenAiCacheService_GetCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *genAiCacheServiceClient) UpdateCachedContent(ctx context.Context, in *UpdateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, GenAiCacheService_UpdateCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *genAiCacheServiceClient) DeleteCachedContent(ctx context.Context, in *DeleteCachedContentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GenAiCacheService_DeleteCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *genAiCacheServiceClient) ListCachedContents(ctx context.Context, in *ListCachedContentsRequest, opts ...grpc.CallOption) (*ListCachedContentsResponse, error) {
	out := new(ListCachedContentsResponse)
	err := c.cc.Invoke(ctx, GenAiCacheService_ListCachedContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GenAiCacheServiceServer is the server API for GenAiCacheService service.
// All implementations should embed UnimplementedGenAiCacheServiceServer
// for forward compatibility
type GenAiCacheServiceServer interface {
	// Creates cached content, this call will initialize the cached content in the
	// data storage, and users need to pay for the cache data storage.
	CreateCachedContent(context.Context, *CreateCachedContentRequest) (*CachedContent, error)
	// Gets cached content configurations
	GetCachedContent(context.Context, *GetCachedContentRequest) (*CachedContent, error)
	// Updates cached content configurations
	UpdateCachedContent(context.Context, *UpdateCachedContentRequest) (*CachedContent, error)
	// Deletes cached content
	DeleteCachedContent(context.Context, *DeleteCachedContentRequest) (*emptypb.Empty, error)
	// Lists cached contents in a project
	ListCachedContents(context.Context, *ListCachedContentsRequest) (*ListCachedContentsResponse, error)
}

// UnimplementedGenAiCacheServiceServer should be embedded to have forward compatible implementations.
type UnimplementedGenAiCacheServiceServer struct {
}

func (UnimplementedGenAiCacheServiceServer) CreateCachedContent(context.Context, *CreateCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCachedContent not implemented")
}
func (UnimplementedGenAiCacheServiceServer) GetCachedContent(context.Context, *GetCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCachedContent not implemented")
}
func (UnimplementedGenAiCacheServiceServer) UpdateCachedContent(context.Context, *UpdateCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCachedContent not implemented")
}
func (UnimplementedGenAiCacheServiceServer) DeleteCachedContent(context.Context, *DeleteCachedContentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCachedContent not implemented")
}
func (UnimplementedGenAiCacheServiceServer) ListCachedContents(context.Context, *ListCachedContentsRequest) (*ListCachedContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCachedContents not implemented")
}

// UnsafeGenAiCacheServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GenAiCacheServiceServer will
// result in compilation errors.
type UnsafeGenAiCacheServiceServer interface {
	mustEmbedUnimplementedGenAiCacheServiceServer()
}

func RegisterGenAiCacheServiceServer(s grpc.ServiceRegistrar, srv GenAiCacheServiceServer) {
	s.RegisterService(&GenAiCacheService_ServiceDesc, srv)
}

func _GenAiCacheService_CreateCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenAiCacheServiceServer).CreateCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenAiCacheService_CreateCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenAiCacheServiceServer).CreateCachedContent(ctx, req.(*CreateCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenAiCacheService_GetCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenAiCacheServiceServer).GetCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenAiCacheService_GetCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenAiCacheServiceServer).GetCachedContent(ctx, req.(*GetCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenAiCacheService_UpdateCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenAiCacheServiceServer).UpdateCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenAiCacheService_UpdateCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenAiCacheServiceServer).UpdateCachedContent(ctx, req.(*UpdateCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenAiCacheService_DeleteCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenAiCacheServiceServer).DeleteCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenAiCacheService_DeleteCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenAiCacheServiceServer).DeleteCachedContent(ctx, req.(*DeleteCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenAiCacheService_ListCachedContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCachedContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenAiCacheServiceServer).ListCachedContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenAiCacheService_ListCachedContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenAiCacheServiceServer).ListCachedContents(ctx, req.(*ListCachedContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GenAiCacheService_ServiceDesc is the grpc.ServiceDesc for GenAiCacheService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GenAiCacheService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.GenAiCacheService",
	HandlerType: (*GenAiCacheServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCachedContent",
			Handler:    _GenAiCacheService_CreateCachedContent_Handler,
		},
		{
			MethodName: "GetCachedContent",
			Handler:    _GenAiCacheService_GetCachedContent_Handler,
		},
		{
			MethodName: "UpdateCachedContent",
			Handler:    _GenAiCacheService_UpdateCachedContent_Handler,
		},
		{
			MethodName: "DeleteCachedContent",
			Handler:    _GenAiCacheService_DeleteCachedContent_Handler,
		},
		{
			MethodName: "ListCachedContents",
			Handler:    _GenAiCacheService_ListCachedContents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/gen_ai_cache_service.proto",
}
