// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/v2beta1/encryption_spec.proto

package dialogflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request to get location-level encryption specification.
type GetEncryptionSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the encryption spec resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEncryptionSpecRequest) Reset() {
	*x = GetEncryptionSpecRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEncryptionSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEncryptionSpecRequest) ProtoMessage() {}

func (x *GetEncryptionSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEncryptionSpecRequest.ProtoReflect.Descriptor instead.
func (*GetEncryptionSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP(), []int{0}
}

func (x *GetEncryptionSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A customer-managed encryption key specification that can be applied to all
// created resources (e.g. Conversation).
type EncryptionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the encryption key specification resource.
	// Format:
	// projects/{project}/locations/{location}/encryptionSpec
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of customer-managed encryption key that is used to
	// secure a resource and its sub-resources. If empty, the resource is secured
	// by the default Google encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `protobuf:"bytes,2,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *EncryptionSpec) Reset() {
	*x = EncryptionSpec{}
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionSpec) ProtoMessage() {}

func (x *EncryptionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionSpec.ProtoReflect.Descriptor instead.
func (*EncryptionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP(), []int{1}
}

func (x *EncryptionSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EncryptionSpec) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// The request to initialize a location-level encryption specification.
type InitializeEncryptionSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The encryption spec used for CMEK encryption. It is required that
	// the kms key is in the same region as the endpoint. The same key will be
	// used for all provisioned resources, if encryption is available. If the
	// kms_key_name is left empty, no encryption will be enforced.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,1,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *InitializeEncryptionSpecRequest) Reset() {
	*x = InitializeEncryptionSpecRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecRequest) ProtoMessage() {}

func (x *InitializeEncryptionSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecRequest.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP(), []int{2}
}

func (x *InitializeEncryptionSpecRequest) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// The response to initialize a location-level encryption specification.
type InitializeEncryptionSpecResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitializeEncryptionSpecResponse) Reset() {
	*x = InitializeEncryptionSpecResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecResponse) ProtoMessage() {}

func (x *InitializeEncryptionSpecResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecResponse.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP(), []int{3}
}

// Metadata for initializing a location-level encryption specification.
type InitializeEncryptionSpecMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The original request for initialization.
	Request *InitializeEncryptionSpecRequest `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *InitializeEncryptionSpecMetadata) Reset() {
	*x = InitializeEncryptionSpecMetadata{}
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecMetadata) ProtoMessage() {}

func (x *InitializeEncryptionSpecMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecMetadata.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP(), []int{4}
}

func (x *InitializeEncryptionSpecMetadata) GetRequest() *InitializeEncryptionSpecRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

var File_google_cloud_dialogflow_v2beta1_encryption_spec_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x60, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c,
	0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x3a, 0x87, 0x01, 0xea,
	0x41, 0x83, 0x01, 0x0a, 0x28, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x36, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x2a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x32, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x80, 0x01, 0x0a, 0x1f, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x22, 0x0a, 0x20, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01,
	0x0a, 0x20, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5f, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x32, 0x8e, 0x05, 0x0a, 0x15, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc5, 0x01,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22,
	0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x7d, 0x12, 0xb2, 0x02, 0x0a, 0x18, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x20, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x7d, 0x3a,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x42, 0xa8, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_goTypes = []any{
	(*GetEncryptionSpecRequest)(nil),         // 0: google.cloud.dialogflow.v2beta1.GetEncryptionSpecRequest
	(*EncryptionSpec)(nil),                   // 1: google.cloud.dialogflow.v2beta1.EncryptionSpec
	(*InitializeEncryptionSpecRequest)(nil),  // 2: google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest
	(*InitializeEncryptionSpecResponse)(nil), // 3: google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecResponse
	(*InitializeEncryptionSpecMetadata)(nil), // 4: google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecMetadata
	(*longrunningpb.Operation)(nil),          // 5: google.longrunning.Operation
}
var file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_depIdxs = []int32{
	1, // 0: google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest.encryption_spec:type_name -> google.cloud.dialogflow.v2beta1.EncryptionSpec
	2, // 1: google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecMetadata.request:type_name -> google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest
	0, // 2: google.cloud.dialogflow.v2beta1.EncryptionSpecService.GetEncryptionSpec:input_type -> google.cloud.dialogflow.v2beta1.GetEncryptionSpecRequest
	2, // 3: google.cloud.dialogflow.v2beta1.EncryptionSpecService.InitializeEncryptionSpec:input_type -> google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest
	1, // 4: google.cloud.dialogflow.v2beta1.EncryptionSpecService.GetEncryptionSpec:output_type -> google.cloud.dialogflow.v2beta1.EncryptionSpec
	5, // 5: google.cloud.dialogflow.v2beta1.EncryptionSpecService.InitializeEncryptionSpec:output_type -> google.longrunning.Operation
	4, // [4:6] is the sub-list for method output_type
	2, // [2:4] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_init() }
func file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_encryption_spec_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_encryption_spec_proto = out.File
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_encryption_spec_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EncryptionSpecServiceClient is the client API for EncryptionSpecService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EncryptionSpecServiceClient interface {
	// Gets location-level encryption key specification.
	GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification.  An error will
	// be thrown if the location has resources already created before the
	// initialization. Once the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type encryptionSpecServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEncryptionSpecServiceClient(cc grpc.ClientConnInterface) EncryptionSpecServiceClient {
	return &encryptionSpecServiceClient{cc}
}

func (c *encryptionSpecServiceClient) GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error) {
	out := new(EncryptionSpec)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EncryptionSpecService/GetEncryptionSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *encryptionSpecServiceClient) InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EncryptionSpecService/InitializeEncryptionSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EncryptionSpecServiceServer is the server API for EncryptionSpecService service.
type EncryptionSpecServiceServer interface {
	// Gets location-level encryption key specification.
	GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification.  An error will
	// be thrown if the location has resources already created before the
	// initialization. Once the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEncryptionSpecServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEncryptionSpecServiceServer struct {
}

func (*UnimplementedEncryptionSpecServiceServer) GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEncryptionSpec not implemented")
}
func (*UnimplementedEncryptionSpecServiceServer) InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InitializeEncryptionSpec not implemented")
}

func RegisterEncryptionSpecServiceServer(s *grpc.Server, srv EncryptionSpecServiceServer) {
	s.RegisterService(&_EncryptionSpecService_serviceDesc, srv)
}

func _EncryptionSpecService_GetEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EncryptionSpecServiceServer).GetEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EncryptionSpecService/GetEncryptionSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EncryptionSpecServiceServer).GetEncryptionSpec(ctx, req.(*GetEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EncryptionSpecService_InitializeEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitializeEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EncryptionSpecServiceServer).InitializeEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EncryptionSpecService/InitializeEncryptionSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EncryptionSpecServiceServer).InitializeEncryptionSpec(ctx, req.(*InitializeEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EncryptionSpecService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.EncryptionSpecService",
	HandlerType: (*EncryptionSpecServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEncryptionSpec",
			Handler:    _EncryptionSpecService_GetEncryptionSpec_Handler,
		},
		{
			MethodName: "InitializeEncryptionSpec",
			Handler:    _EncryptionSpecService_InitializeEncryptionSpec_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/encryption_spec.proto",
}
