// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/playbook.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request message for
// [Playbooks.CreatePlaybook][google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybook].
type CreatePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a playbook for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The playbook to create.
	Playbook *Playbook `protobuf:"bytes,2,opt,name=playbook,proto3" json:"playbook,omitempty"`
}

func (x *CreatePlaybookRequest) Reset() {
	*x = CreatePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePlaybookRequest) ProtoMessage() {}

func (x *CreatePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePlaybookRequest.ProtoReflect.Descriptor instead.
func (*CreatePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePlaybookRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePlaybookRequest) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

// The request message for
// [Playbooks.DeletePlaybook][google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybook].
type DeletePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePlaybookRequest) Reset() {
	*x = DeletePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePlaybookRequest) ProtoMessage() {}

func (x *DeletePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePlaybookRequest.ProtoReflect.Descriptor instead.
func (*DeletePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{1}
}

func (x *DeletePlaybookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.ListPlaybooks][google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybooks].
type ListPlaybooksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list playbooks from.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPlaybooksRequest) Reset() {
	*x = ListPlaybooksRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybooksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybooksRequest) ProtoMessage() {}

func (x *ListPlaybooksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybooksRequest.ProtoReflect.Descriptor instead.
func (*ListPlaybooksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{2}
}

func (x *ListPlaybooksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPlaybooksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPlaybooksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Playbooks.ListPlaybooks][google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybooks].
type ListPlaybooksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of playbooks. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Playbooks []*Playbook `protobuf:"bytes,1,rep,name=playbooks,proto3" json:"playbooks,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPlaybooksResponse) Reset() {
	*x = ListPlaybooksResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybooksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybooksResponse) ProtoMessage() {}

func (x *ListPlaybooksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybooksResponse.ProtoReflect.Descriptor instead.
func (*ListPlaybooksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{3}
}

func (x *ListPlaybooksResponse) GetPlaybooks() []*Playbook {
	if x != nil {
		return x.Playbooks
	}
	return nil
}

func (x *ListPlaybooksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Playbooks.GetPlaybook][google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybook].
type GetPlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPlaybookRequest) Reset() {
	*x = GetPlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaybookRequest) ProtoMessage() {}

func (x *GetPlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaybookRequest.ProtoReflect.Descriptor instead.
func (*GetPlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{4}
}

func (x *GetPlaybookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.UpdatePlaybook][google.cloud.dialogflow.cx.v3beta1.Playbooks.UpdatePlaybook].
type UpdatePlaybookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to update.
	Playbook *Playbook `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePlaybookRequest) Reset() {
	*x = UpdatePlaybookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePlaybookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePlaybookRequest) ProtoMessage() {}

func (x *UpdatePlaybookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePlaybookRequest.ProtoReflect.Descriptor instead.
func (*UpdatePlaybookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{5}
}

func (x *UpdatePlaybookRequest) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

func (x *UpdatePlaybookRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Playbook is the basic building block to instruct the LLM how to execute a
// certain task.
//
// A playbook consists of a goal to accomplish, an optional list of step by step
// instructions (the step instruction may refers to name of the custom or
// default plugin tools to use) to perform the task,
// a list of contextual input data to be passed in at the beginning of the
// invoked, and a list of output parameters to store the playbook result.
type Playbook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the playbook, unique within an agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. High level description of the goal the playbook intend to
	// accomplish. A goal should be concise since it's visible to other playbooks
	// that may reference this playbook.
	Goal string `protobuf:"bytes,3,opt,name=goal,proto3" json:"goal,omitempty"`
	// Optional. Defined structured input parameters for this playbook.
	InputParameterDefinitions []*ParameterDefinition `protobuf:"bytes,5,rep,name=input_parameter_definitions,json=inputParameterDefinitions,proto3" json:"input_parameter_definitions,omitempty"`
	// Optional. Defined structured output parameters for this playbook.
	OutputParameterDefinitions []*ParameterDefinition `protobuf:"bytes,6,rep,name=output_parameter_definitions,json=outputParameterDefinitions,proto3" json:"output_parameter_definitions,omitempty"`
	// Instruction to accomplish target goal.
	Instruction *Playbook_Instruction `protobuf:"bytes,17,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Output only. Estimated number of tokes current playbook takes when sent to
	// the LLM.
	TokenCount int64 `protobuf:"varint,8,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Output only. The timestamp of initial playbook creation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last time the playbook version was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The resource name of other playbooks referenced by the current
	// playbook in the instructions.
	ReferencedPlaybooks []string `protobuf:"bytes,11,rep,name=referenced_playbooks,json=referencedPlaybooks,proto3" json:"referenced_playbooks,omitempty"`
	// Output only. The resource name of flows referenced by the current playbook
	// in the instructions.
	ReferencedFlows []string `protobuf:"bytes,12,rep,name=referenced_flows,json=referencedFlows,proto3" json:"referenced_flows,omitempty"`
	// Optional. The resource name of tools referenced by the current playbook in
	// the instructions. If not provided explicitly, they are will
	// be implied using the tool being referenced in goal and steps.
	ReferencedTools []string `protobuf:"bytes,13,rep,name=referenced_tools,json=referencedTools,proto3" json:"referenced_tools,omitempty"`
	// Optional. Llm model settings for the playbook.
	LlmModelSettings *LlmModelSettings `protobuf:"bytes,14,opt,name=llm_model_settings,json=llmModelSettings,proto3" json:"llm_model_settings,omitempty"`
	// Optional. Playbook level Settings for speech to text detection.
	SpeechSettings *AdvancedSettings_SpeechSettings `protobuf:"bytes,20,opt,name=speech_settings,json=speechSettings,proto3" json:"speech_settings,omitempty"`
	// Optional. A list of registered handlers to execute based on the specified
	// triggers.
	Handlers []*Handler `protobuf:"bytes,16,rep,name=handlers,proto3" json:"handlers,omitempty"`
}

func (x *Playbook) Reset() {
	*x = Playbook{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook) ProtoMessage() {}

func (x *Playbook) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook.ProtoReflect.Descriptor instead.
func (*Playbook) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{6}
}

func (x *Playbook) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Playbook) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Playbook) GetGoal() string {
	if x != nil {
		return x.Goal
	}
	return ""
}

func (x *Playbook) GetInputParameterDefinitions() []*ParameterDefinition {
	if x != nil {
		return x.InputParameterDefinitions
	}
	return nil
}

func (x *Playbook) GetOutputParameterDefinitions() []*ParameterDefinition {
	if x != nil {
		return x.OutputParameterDefinitions
	}
	return nil
}

func (x *Playbook) GetInstruction() *Playbook_Instruction {
	if x != nil {
		return x.Instruction
	}
	return nil
}

func (x *Playbook) GetTokenCount() int64 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *Playbook) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Playbook) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Playbook) GetReferencedPlaybooks() []string {
	if x != nil {
		return x.ReferencedPlaybooks
	}
	return nil
}

func (x *Playbook) GetReferencedFlows() []string {
	if x != nil {
		return x.ReferencedFlows
	}
	return nil
}

func (x *Playbook) GetReferencedTools() []string {
	if x != nil {
		return x.ReferencedTools
	}
	return nil
}

func (x *Playbook) GetLlmModelSettings() *LlmModelSettings {
	if x != nil {
		return x.LlmModelSettings
	}
	return nil
}

func (x *Playbook) GetSpeechSettings() *AdvancedSettings_SpeechSettings {
	if x != nil {
		return x.SpeechSettings
	}
	return nil
}

func (x *Playbook) GetHandlers() []*Handler {
	if x != nil {
		return x.Handlers
	}
	return nil
}

// The request message for
// [Playbooks.CreatePlaybookVersion][google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybookVersion].
type CreatePlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to create a version for.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The playbook version to create.
	PlaybookVersion *PlaybookVersion `protobuf:"bytes,2,opt,name=playbook_version,json=playbookVersion,proto3" json:"playbook_version,omitempty"`
}

func (x *CreatePlaybookVersionRequest) Reset() {
	*x = CreatePlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePlaybookVersionRequest) ProtoMessage() {}

func (x *CreatePlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*CreatePlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{7}
}

func (x *CreatePlaybookVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePlaybookVersionRequest) GetPlaybookVersion() *PlaybookVersion {
	if x != nil {
		return x.PlaybookVersion
	}
	return nil
}

// Playbook version is a snapshot of the playbook at certain timestamp.
type PlaybookVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the playbook version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the playbook version.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Snapshot of the playbook when the playbook version is created.
	Playbook *Playbook `protobuf:"bytes,3,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. Snapshot of the examples belonging to the playbook when the
	// playbook version is created.
	Examples []*Example `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty"`
	// Output only. Last time the playbook version was created or modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PlaybookVersion) Reset() {
	*x = PlaybookVersion{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookVersion) ProtoMessage() {}

func (x *PlaybookVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookVersion.ProtoReflect.Descriptor instead.
func (*PlaybookVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{8}
}

func (x *PlaybookVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlaybookVersion) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PlaybookVersion) GetPlaybook() *Playbook {
	if x != nil {
		return x.Playbook
	}
	return nil
}

func (x *PlaybookVersion) GetExamples() []*Example {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *PlaybookVersion) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The request message for
// [Playbooks.GetPlaybookVersion][google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybookVersion].
type GetPlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPlaybookVersionRequest) Reset() {
	*x = GetPlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaybookVersionRequest) ProtoMessage() {}

func (x *GetPlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*GetPlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{9}
}

func (x *GetPlaybookVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Playbooks.ListPlaybookVersions][google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybookVersions].
type ListPlaybookVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The playbook to list versions for.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPlaybookVersionsRequest) Reset() {
	*x = ListPlaybookVersionsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybookVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybookVersionsRequest) ProtoMessage() {}

func (x *ListPlaybookVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybookVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListPlaybookVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{10}
}

func (x *ListPlaybookVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPlaybookVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPlaybookVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Playbooks.ListPlaybookVersions][google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybookVersions].
type ListPlaybookVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of playbook version. There will be a maximum number of items
	// returned based on the page_size field in the request.
	PlaybookVersions []*PlaybookVersion `protobuf:"bytes,1,rep,name=playbook_versions,json=playbookVersions,proto3" json:"playbook_versions,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPlaybookVersionsResponse) Reset() {
	*x = ListPlaybookVersionsResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPlaybookVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPlaybookVersionsResponse) ProtoMessage() {}

func (x *ListPlaybookVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPlaybookVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListPlaybookVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{11}
}

func (x *ListPlaybookVersionsResponse) GetPlaybookVersions() []*PlaybookVersion {
	if x != nil {
		return x.PlaybookVersions
	}
	return nil
}

func (x *ListPlaybookVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Playbooks.DeletePlaybookVersion][google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybookVersion].
type DeletePlaybookVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the playbook version to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePlaybookVersionRequest) Reset() {
	*x = DeletePlaybookVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePlaybookVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePlaybookVersionRequest) ProtoMessage() {}

func (x *DeletePlaybookVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePlaybookVersionRequest.ProtoReflect.Descriptor instead.
func (*DeletePlaybookVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{12}
}

func (x *DeletePlaybookVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Handler can be used to define custom logic to be executed based on the
// user-specified triggers.
type Handler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the type of handler to invoke.
	//
	// Types that are assignable to Handler:
	//
	//	*Handler_EventHandler_
	//	*Handler_LifecycleHandler_
	Handler isHandler_Handler `protobuf_oneof:"handler"`
}

func (x *Handler) Reset() {
	*x = Handler{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler) ProtoMessage() {}

func (x *Handler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler.ProtoReflect.Descriptor instead.
func (*Handler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{13}
}

func (m *Handler) GetHandler() isHandler_Handler {
	if m != nil {
		return m.Handler
	}
	return nil
}

func (x *Handler) GetEventHandler() *Handler_EventHandler {
	if x, ok := x.GetHandler().(*Handler_EventHandler_); ok {
		return x.EventHandler
	}
	return nil
}

func (x *Handler) GetLifecycleHandler() *Handler_LifecycleHandler {
	if x, ok := x.GetHandler().(*Handler_LifecycleHandler_); ok {
		return x.LifecycleHandler
	}
	return nil
}

type isHandler_Handler interface {
	isHandler_Handler()
}

type Handler_EventHandler_ struct {
	// A handler triggered by event.
	EventHandler *Handler_EventHandler `protobuf:"bytes,1,opt,name=event_handler,json=eventHandler,proto3,oneof"`
}

type Handler_LifecycleHandler_ struct {
	// A handler triggered during specific lifecycle of the playbook execution.
	LifecycleHandler *Handler_LifecycleHandler `protobuf:"bytes,3,opt,name=lifecycle_handler,json=lifecycleHandler,proto3,oneof"`
}

func (*Handler_EventHandler_) isHandler_Handler() {}

func (*Handler_LifecycleHandler_) isHandler_Handler() {}

// Message of single step execution.
type Playbook_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instruction on how to execute current step.
	//
	// Types that are assignable to Instruction:
	//
	//	*Playbook_Step_Text
	Instruction isPlaybook_Step_Instruction `protobuf_oneof:"instruction"`
	// Sub-processing needed to execute the current step.
	Steps []*Playbook_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Playbook_Step) Reset() {
	*x = Playbook_Step{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook_Step) ProtoMessage() {}

func (x *Playbook_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook_Step.ProtoReflect.Descriptor instead.
func (*Playbook_Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{6, 0}
}

func (m *Playbook_Step) GetInstruction() isPlaybook_Step_Instruction {
	if m != nil {
		return m.Instruction
	}
	return nil
}

func (x *Playbook_Step) GetText() string {
	if x, ok := x.GetInstruction().(*Playbook_Step_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Playbook_Step) GetSteps() []*Playbook_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isPlaybook_Step_Instruction interface {
	isPlaybook_Step_Instruction()
}

type Playbook_Step_Text struct {
	// Step instruction in text format.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

func (*Playbook_Step_Text) isPlaybook_Step_Instruction() {}

// Message of the Instruction of the playbook.
type Playbook_Instruction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// General guidelines for the playbook. These are unstructured instructions
	// that are not directly part of the goal, e.g. "Always be polite". It's
	// valid for this text to be long and used instead of steps altogether.
	Guidelines string `protobuf:"bytes,1,opt,name=guidelines,proto3" json:"guidelines,omitempty"`
	// Ordered list of step by step execution instructions to accomplish
	// target goal.
	Steps []*Playbook_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Playbook_Instruction) Reset() {
	*x = Playbook_Instruction{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Playbook_Instruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Playbook_Instruction) ProtoMessage() {}

func (x *Playbook_Instruction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Playbook_Instruction.ProtoReflect.Descriptor instead.
func (*Playbook_Instruction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Playbook_Instruction) GetGuidelines() string {
	if x != nil {
		return x.Guidelines
	}
	return ""
}

func (x *Playbook_Instruction) GetSteps() []*Playbook_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// A handler that is triggered by the specified
// [event][google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.event].
type Handler_EventHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the event that triggers this handler.
	Event string `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// Optional. The condition that must be satisfied to trigger this handler.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Required. The fulfillment to call when the event occurs.
	Fulfillment *Fulfillment `protobuf:"bytes,2,opt,name=fulfillment,proto3" json:"fulfillment,omitempty"`
}

func (x *Handler_EventHandler) Reset() {
	*x = Handler_EventHandler{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler_EventHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler_EventHandler) ProtoMessage() {}

func (x *Handler_EventHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler_EventHandler.ProtoReflect.Descriptor instead.
func (*Handler_EventHandler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{13, 0}
}

func (x *Handler_EventHandler) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *Handler_EventHandler) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Handler_EventHandler) GetFulfillment() *Fulfillment {
	if x != nil {
		return x.Fulfillment
	}
	return nil
}

// A handler that is triggered on the specific
// [lifecycle_stage][google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.lifecycle_stage]
// of the playbook execution.
type Handler_LifecycleHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the lifecycle stage that triggers this handler.
	// Supported values:
	// * `playbook-start`
	// * `pre-action-selection`
	// * `pre-action-execution`
	LifecycleStage string `protobuf:"bytes,1,opt,name=lifecycle_stage,json=lifecycleStage,proto3" json:"lifecycle_stage,omitempty"`
	// Optional. The condition that must be satisfied to trigger this handler.
	Condition string `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
	// Required. The fulfillment to call when this handler is triggered.
	Fulfillment *Fulfillment `protobuf:"bytes,3,opt,name=fulfillment,proto3" json:"fulfillment,omitempty"`
}

func (x *Handler_LifecycleHandler) Reset() {
	*x = Handler_LifecycleHandler{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Handler_LifecycleHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Handler_LifecycleHandler) ProtoMessage() {}

func (x *Handler_LifecycleHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Handler_LifecycleHandler.ProtoReflect.Descriptor instead.
func (*Handler_LifecycleHandler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP(), []int{13, 1}
}

func (x *Handler_LifecycleHandler) GetLifecycleStage() string {
	if x != nil {
		return x.LifecycleStage
	}
	return ""
}

func (x *Handler_LifecycleHandler) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Handler_LifecycleHandler) GetFulfillment() *Fulfillment {
	if x != nil {
		return x.Fulfillment
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3beta1_playbook_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x01, 0x0a, 0x15,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x57, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x96, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8b, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3,
	0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0xf6, 0x0b, 0x0a, 0x08, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x67, 0x6f, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x12, 0x7c, 0x0a, 0x1b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7e, 0x0a, 0x1c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x14, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x13, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x51, 0x0a, 0x10, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x0f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x51, 0x0a, 0x10,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x0f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12,
	0x67, 0x0a, 0x12, 0x6c, 0x6c, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x71, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x1a, 0x74, 0x0a, 0x04, 0x53, 0x74, 0x65,
	0x70, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x42, 0x0d, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x76, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e,
	0x0a, 0x0a, 0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x47,
	0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e, 0x53, 0x74, 0x65, 0x70,
	0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x22, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x7d, 0x22, 0xce, 0x01,
	0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x10, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe0,
	0x03, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a,
	0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x4c, 0x0a, 0x08,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xb2, 0x01, 0xea,
	0x41, 0xae, 0x01, 0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x10,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x32, 0x0f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x62, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x65, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7, 0x04, 0x0a, 0x07, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x4c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x10, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x1a, 0xa4, 0x01, 0x0a, 0x0c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x21,
	0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x56, 0x0a, 0x0b, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x66, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xbb, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x2c,
	0x0a, 0x0f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x56, 0x0a, 0x0b, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x66, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x32, 0xc5, 0x10, 0x0a, 0x09, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x12, 0xda, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x5f, 0xda, 0x41,
	0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x22, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xaf, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x22, 0x6d, 0xda, 0x41, 0x14, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x50, 0x3a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x32, 0x44, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x8a, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x7a, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x10, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xdf,
	0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xf2, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc8, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x2a, 0x46, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x9b, 0x01, 0x0a, 0x26, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2, 0x02,
	0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78,
	0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_goTypes = []any{
	(*CreatePlaybookRequest)(nil),           // 0: google.cloud.dialogflow.cx.v3beta1.CreatePlaybookRequest
	(*DeletePlaybookRequest)(nil),           // 1: google.cloud.dialogflow.cx.v3beta1.DeletePlaybookRequest
	(*ListPlaybooksRequest)(nil),            // 2: google.cloud.dialogflow.cx.v3beta1.ListPlaybooksRequest
	(*ListPlaybooksResponse)(nil),           // 3: google.cloud.dialogflow.cx.v3beta1.ListPlaybooksResponse
	(*GetPlaybookRequest)(nil),              // 4: google.cloud.dialogflow.cx.v3beta1.GetPlaybookRequest
	(*UpdatePlaybookRequest)(nil),           // 5: google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest
	(*Playbook)(nil),                        // 6: google.cloud.dialogflow.cx.v3beta1.Playbook
	(*CreatePlaybookVersionRequest)(nil),    // 7: google.cloud.dialogflow.cx.v3beta1.CreatePlaybookVersionRequest
	(*PlaybookVersion)(nil),                 // 8: google.cloud.dialogflow.cx.v3beta1.PlaybookVersion
	(*GetPlaybookVersionRequest)(nil),       // 9: google.cloud.dialogflow.cx.v3beta1.GetPlaybookVersionRequest
	(*ListPlaybookVersionsRequest)(nil),     // 10: google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsRequest
	(*ListPlaybookVersionsResponse)(nil),    // 11: google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsResponse
	(*DeletePlaybookVersionRequest)(nil),    // 12: google.cloud.dialogflow.cx.v3beta1.DeletePlaybookVersionRequest
	(*Handler)(nil),                         // 13: google.cloud.dialogflow.cx.v3beta1.Handler
	(*Playbook_Step)(nil),                   // 14: google.cloud.dialogflow.cx.v3beta1.Playbook.Step
	(*Playbook_Instruction)(nil),            // 15: google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction
	(*Handler_EventHandler)(nil),            // 16: google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler
	(*Handler_LifecycleHandler)(nil),        // 17: google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
	(*fieldmaskpb.FieldMask)(nil),           // 18: google.protobuf.FieldMask
	(*ParameterDefinition)(nil),             // 19: google.cloud.dialogflow.cx.v3beta1.ParameterDefinition
	(*timestamppb.Timestamp)(nil),           // 20: google.protobuf.Timestamp
	(*LlmModelSettings)(nil),                // 21: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	(*AdvancedSettings_SpeechSettings)(nil), // 22: google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
	(*Example)(nil),                         // 23: google.cloud.dialogflow.cx.v3beta1.Example
	(*Fulfillment)(nil),                     // 24: google.cloud.dialogflow.cx.v3beta1.Fulfillment
	(*emptypb.Empty)(nil),                   // 25: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_depIdxs = []int32{
	6,  // 0: google.cloud.dialogflow.cx.v3beta1.CreatePlaybookRequest.playbook:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook
	6,  // 1: google.cloud.dialogflow.cx.v3beta1.ListPlaybooksResponse.playbooks:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook
	6,  // 2: google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest.playbook:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook
	18, // 3: google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 4: google.cloud.dialogflow.cx.v3beta1.Playbook.input_parameter_definitions:type_name -> google.cloud.dialogflow.cx.v3beta1.ParameterDefinition
	19, // 5: google.cloud.dialogflow.cx.v3beta1.Playbook.output_parameter_definitions:type_name -> google.cloud.dialogflow.cx.v3beta1.ParameterDefinition
	15, // 6: google.cloud.dialogflow.cx.v3beta1.Playbook.instruction:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction
	20, // 7: google.cloud.dialogflow.cx.v3beta1.Playbook.create_time:type_name -> google.protobuf.Timestamp
	20, // 8: google.cloud.dialogflow.cx.v3beta1.Playbook.update_time:type_name -> google.protobuf.Timestamp
	21, // 9: google.cloud.dialogflow.cx.v3beta1.Playbook.llm_model_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	22, // 10: google.cloud.dialogflow.cx.v3beta1.Playbook.speech_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
	13, // 11: google.cloud.dialogflow.cx.v3beta1.Playbook.handlers:type_name -> google.cloud.dialogflow.cx.v3beta1.Handler
	8,  // 12: google.cloud.dialogflow.cx.v3beta1.CreatePlaybookVersionRequest.playbook_version:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookVersion
	6,  // 13: google.cloud.dialogflow.cx.v3beta1.PlaybookVersion.playbook:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook
	23, // 14: google.cloud.dialogflow.cx.v3beta1.PlaybookVersion.examples:type_name -> google.cloud.dialogflow.cx.v3beta1.Example
	20, // 15: google.cloud.dialogflow.cx.v3beta1.PlaybookVersion.update_time:type_name -> google.protobuf.Timestamp
	8,  // 16: google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsResponse.playbook_versions:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookVersion
	16, // 17: google.cloud.dialogflow.cx.v3beta1.Handler.event_handler:type_name -> google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler
	17, // 18: google.cloud.dialogflow.cx.v3beta1.Handler.lifecycle_handler:type_name -> google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
	14, // 19: google.cloud.dialogflow.cx.v3beta1.Playbook.Step.steps:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook.Step
	14, // 20: google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.steps:type_name -> google.cloud.dialogflow.cx.v3beta1.Playbook.Step
	24, // 21: google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	24, // 22: google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	0,  // 23: google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybook:input_type -> google.cloud.dialogflow.cx.v3beta1.CreatePlaybookRequest
	1,  // 24: google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybook:input_type -> google.cloud.dialogflow.cx.v3beta1.DeletePlaybookRequest
	2,  // 25: google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybooks:input_type -> google.cloud.dialogflow.cx.v3beta1.ListPlaybooksRequest
	4,  // 26: google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybook:input_type -> google.cloud.dialogflow.cx.v3beta1.GetPlaybookRequest
	5,  // 27: google.cloud.dialogflow.cx.v3beta1.Playbooks.UpdatePlaybook:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest
	7,  // 28: google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3beta1.CreatePlaybookVersionRequest
	9,  // 29: google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3beta1.GetPlaybookVersionRequest
	10, // 30: google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybookVersions:input_type -> google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsRequest
	12, // 31: google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybookVersion:input_type -> google.cloud.dialogflow.cx.v3beta1.DeletePlaybookVersionRequest
	6,  // 32: google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybook:output_type -> google.cloud.dialogflow.cx.v3beta1.Playbook
	25, // 33: google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybook:output_type -> google.protobuf.Empty
	3,  // 34: google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybooks:output_type -> google.cloud.dialogflow.cx.v3beta1.ListPlaybooksResponse
	6,  // 35: google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybook:output_type -> google.cloud.dialogflow.cx.v3beta1.Playbook
	6,  // 36: google.cloud.dialogflow.cx.v3beta1.Playbooks.UpdatePlaybook:output_type -> google.cloud.dialogflow.cx.v3beta1.Playbook
	8,  // 37: google.cloud.dialogflow.cx.v3beta1.Playbooks.CreatePlaybookVersion:output_type -> google.cloud.dialogflow.cx.v3beta1.PlaybookVersion
	8,  // 38: google.cloud.dialogflow.cx.v3beta1.Playbooks.GetPlaybookVersion:output_type -> google.cloud.dialogflow.cx.v3beta1.PlaybookVersion
	11, // 39: google.cloud.dialogflow.cx.v3beta1.Playbooks.ListPlaybookVersions:output_type -> google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsResponse
	25, // 40: google.cloud.dialogflow.cx.v3beta1.Playbooks.DeletePlaybookVersion:output_type -> google.protobuf.Empty
	32, // [32:41] is the sub-list for method output_type
	23, // [23:32] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_playbook_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_advanced_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_example_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_fulfillment_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_parameter_definition_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[13].OneofWrappers = []any{
		(*Handler_EventHandler_)(nil),
		(*Handler_LifecycleHandler_)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes[14].OneofWrappers = []any{
		(*Playbook_Step_Text)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_playbook_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_playbook_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PlaybooksClient is the client API for Playbooks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlaybooksClient interface {
	// Creates a playbook in a specified agent.
	CreatePlaybook(ctx context.Context, in *CreatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Deletes a specified playbook.
	DeletePlaybook(ctx context.Context, in *DeletePlaybookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of playbooks in the specified agent.
	ListPlaybooks(ctx context.Context, in *ListPlaybooksRequest, opts ...grpc.CallOption) (*ListPlaybooksResponse, error)
	// Retrieves the specified Playbook.
	GetPlaybook(ctx context.Context, in *GetPlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Updates the specified Playbook.
	UpdatePlaybook(ctx context.Context, in *UpdatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error)
	// Creates a version for the specified Playbook.
	CreatePlaybookVersion(ctx context.Context, in *CreatePlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook.
	GetPlaybookVersion(ctx context.Context, in *GetPlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error)
	// Lists versions for the specified Playbook.
	ListPlaybookVersions(ctx context.Context, in *ListPlaybookVersionsRequest, opts ...grpc.CallOption) (*ListPlaybookVersionsResponse, error)
	// Deletes the specified version of the Playbook.
	DeletePlaybookVersion(ctx context.Context, in *DeletePlaybookVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type playbooksClient struct {
	cc grpc.ClientConnInterface
}

func NewPlaybooksClient(cc grpc.ClientConnInterface) PlaybooksClient {
	return &playbooksClient{cc}
}

func (c *playbooksClient) CreatePlaybook(ctx context.Context, in *CreatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/CreatePlaybook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) DeletePlaybook(ctx context.Context, in *DeletePlaybookRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/DeletePlaybook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ListPlaybooks(ctx context.Context, in *ListPlaybooksRequest, opts ...grpc.CallOption) (*ListPlaybooksResponse, error) {
	out := new(ListPlaybooksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/ListPlaybooks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) GetPlaybook(ctx context.Context, in *GetPlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/GetPlaybook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) UpdatePlaybook(ctx context.Context, in *UpdatePlaybookRequest, opts ...grpc.CallOption) (*Playbook, error) {
	out := new(Playbook)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/UpdatePlaybook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) CreatePlaybookVersion(ctx context.Context, in *CreatePlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error) {
	out := new(PlaybookVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/CreatePlaybookVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) GetPlaybookVersion(ctx context.Context, in *GetPlaybookVersionRequest, opts ...grpc.CallOption) (*PlaybookVersion, error) {
	out := new(PlaybookVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/GetPlaybookVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) ListPlaybookVersions(ctx context.Context, in *ListPlaybookVersionsRequest, opts ...grpc.CallOption) (*ListPlaybookVersionsResponse, error) {
	out := new(ListPlaybookVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/ListPlaybookVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playbooksClient) DeletePlaybookVersion(ctx context.Context, in *DeletePlaybookVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Playbooks/DeletePlaybookVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlaybooksServer is the server API for Playbooks service.
type PlaybooksServer interface {
	// Creates a playbook in a specified agent.
	CreatePlaybook(context.Context, *CreatePlaybookRequest) (*Playbook, error)
	// Deletes a specified playbook.
	DeletePlaybook(context.Context, *DeletePlaybookRequest) (*emptypb.Empty, error)
	// Returns a list of playbooks in the specified agent.
	ListPlaybooks(context.Context, *ListPlaybooksRequest) (*ListPlaybooksResponse, error)
	// Retrieves the specified Playbook.
	GetPlaybook(context.Context, *GetPlaybookRequest) (*Playbook, error)
	// Updates the specified Playbook.
	UpdatePlaybook(context.Context, *UpdatePlaybookRequest) (*Playbook, error)
	// Creates a version for the specified Playbook.
	CreatePlaybookVersion(context.Context, *CreatePlaybookVersionRequest) (*PlaybookVersion, error)
	// Retrieves the specified version of the Playbook.
	GetPlaybookVersion(context.Context, *GetPlaybookVersionRequest) (*PlaybookVersion, error)
	// Lists versions for the specified Playbook.
	ListPlaybookVersions(context.Context, *ListPlaybookVersionsRequest) (*ListPlaybookVersionsResponse, error)
	// Deletes the specified version of the Playbook.
	DeletePlaybookVersion(context.Context, *DeletePlaybookVersionRequest) (*emptypb.Empty, error)
}

// UnimplementedPlaybooksServer can be embedded to have forward compatible implementations.
type UnimplementedPlaybooksServer struct {
}

func (*UnimplementedPlaybooksServer) CreatePlaybook(context.Context, *CreatePlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePlaybook not implemented")
}
func (*UnimplementedPlaybooksServer) DeletePlaybook(context.Context, *DeletePlaybookRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePlaybook not implemented")
}
func (*UnimplementedPlaybooksServer) ListPlaybooks(context.Context, *ListPlaybooksRequest) (*ListPlaybooksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlaybooks not implemented")
}
func (*UnimplementedPlaybooksServer) GetPlaybook(context.Context, *GetPlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlaybook not implemented")
}
func (*UnimplementedPlaybooksServer) UpdatePlaybook(context.Context, *UpdatePlaybookRequest) (*Playbook, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePlaybook not implemented")
}
func (*UnimplementedPlaybooksServer) CreatePlaybookVersion(context.Context, *CreatePlaybookVersionRequest) (*PlaybookVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePlaybookVersion not implemented")
}
func (*UnimplementedPlaybooksServer) GetPlaybookVersion(context.Context, *GetPlaybookVersionRequest) (*PlaybookVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlaybookVersion not implemented")
}
func (*UnimplementedPlaybooksServer) ListPlaybookVersions(context.Context, *ListPlaybookVersionsRequest) (*ListPlaybookVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlaybookVersions not implemented")
}
func (*UnimplementedPlaybooksServer) DeletePlaybookVersion(context.Context, *DeletePlaybookVersionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePlaybookVersion not implemented")
}

func RegisterPlaybooksServer(s *grpc.Server, srv PlaybooksServer) {
	s.RegisterService(&_Playbooks_serviceDesc, srv)
}

func _Playbooks_CreatePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).CreatePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/CreatePlaybook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).CreatePlaybook(ctx, req.(*CreatePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_DeletePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).DeletePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/DeletePlaybook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).DeletePlaybook(ctx, req.(*DeletePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ListPlaybooks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlaybooksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ListPlaybooks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/ListPlaybooks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ListPlaybooks(ctx, req.(*ListPlaybooksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_GetPlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).GetPlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/GetPlaybook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).GetPlaybook(ctx, req.(*GetPlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_UpdatePlaybook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePlaybookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).UpdatePlaybook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/UpdatePlaybook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).UpdatePlaybook(ctx, req.(*UpdatePlaybookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_CreatePlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).CreatePlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/CreatePlaybookVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).CreatePlaybookVersion(ctx, req.(*CreatePlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_GetPlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).GetPlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/GetPlaybookVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).GetPlaybookVersion(ctx, req.(*GetPlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_ListPlaybookVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlaybookVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).ListPlaybookVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/ListPlaybookVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).ListPlaybookVersions(ctx, req.(*ListPlaybookVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Playbooks_DeletePlaybookVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePlaybookVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaybooksServer).DeletePlaybookVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Playbooks/DeletePlaybookVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaybooksServer).DeletePlaybookVersion(ctx, req.(*DeletePlaybookVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Playbooks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Playbooks",
	HandlerType: (*PlaybooksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePlaybook",
			Handler:    _Playbooks_CreatePlaybook_Handler,
		},
		{
			MethodName: "DeletePlaybook",
			Handler:    _Playbooks_DeletePlaybook_Handler,
		},
		{
			MethodName: "ListPlaybooks",
			Handler:    _Playbooks_ListPlaybooks_Handler,
		},
		{
			MethodName: "GetPlaybook",
			Handler:    _Playbooks_GetPlaybook_Handler,
		},
		{
			MethodName: "UpdatePlaybook",
			Handler:    _Playbooks_UpdatePlaybook_Handler,
		},
		{
			MethodName: "CreatePlaybookVersion",
			Handler:    _Playbooks_CreatePlaybookVersion_Handler,
		},
		{
			MethodName: "GetPlaybookVersion",
			Handler:    _Playbooks_GetPlaybookVersion_Handler,
		},
		{
			MethodName: "ListPlaybookVersions",
			Handler:    _Playbooks_ListPlaybookVersions_Handler,
		},
		{
			MethodName: "DeletePlaybookVersion",
			Handler:    _Playbooks_DeletePlaybookVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/playbook.proto",
}
