// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datastream/v1alpha1/datastream.proto

package datastreampb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Datastream_ListConnectionProfiles_FullMethodName    = "/google.cloud.datastream.v1alpha1.Datastream/ListConnectionProfiles"
	Datastream_GetConnectionProfile_FullMethodName      = "/google.cloud.datastream.v1alpha1.Datastream/GetConnectionProfile"
	Datastream_CreateConnectionProfile_FullMethodName   = "/google.cloud.datastream.v1alpha1.Datastream/CreateConnectionProfile"
	Datastream_UpdateConnectionProfile_FullMethodName   = "/google.cloud.datastream.v1alpha1.Datastream/UpdateConnectionProfile"
	Datastream_DeleteConnectionProfile_FullMethodName   = "/google.cloud.datastream.v1alpha1.Datastream/DeleteConnectionProfile"
	Datastream_DiscoverConnectionProfile_FullMethodName = "/google.cloud.datastream.v1alpha1.Datastream/DiscoverConnectionProfile"
	Datastream_ListStreams_FullMethodName               = "/google.cloud.datastream.v1alpha1.Datastream/ListStreams"
	Datastream_GetStream_FullMethodName                 = "/google.cloud.datastream.v1alpha1.Datastream/GetStream"
	Datastream_CreateStream_FullMethodName              = "/google.cloud.datastream.v1alpha1.Datastream/CreateStream"
	Datastream_UpdateStream_FullMethodName              = "/google.cloud.datastream.v1alpha1.Datastream/UpdateStream"
	Datastream_DeleteStream_FullMethodName              = "/google.cloud.datastream.v1alpha1.Datastream/DeleteStream"
	Datastream_FetchErrors_FullMethodName               = "/google.cloud.datastream.v1alpha1.Datastream/FetchErrors"
	Datastream_FetchStaticIps_FullMethodName            = "/google.cloud.datastream.v1alpha1.Datastream/FetchStaticIps"
	Datastream_CreatePrivateConnection_FullMethodName   = "/google.cloud.datastream.v1alpha1.Datastream/CreatePrivateConnection"
	Datastream_GetPrivateConnection_FullMethodName      = "/google.cloud.datastream.v1alpha1.Datastream/GetPrivateConnection"
	Datastream_ListPrivateConnections_FullMethodName    = "/google.cloud.datastream.v1alpha1.Datastream/ListPrivateConnections"
	Datastream_DeletePrivateConnection_FullMethodName   = "/google.cloud.datastream.v1alpha1.Datastream/DeletePrivateConnection"
	Datastream_CreateRoute_FullMethodName               = "/google.cloud.datastream.v1alpha1.Datastream/CreateRoute"
	Datastream_GetRoute_FullMethodName                  = "/google.cloud.datastream.v1alpha1.Datastream/GetRoute"
	Datastream_ListRoutes_FullMethodName                = "/google.cloud.datastream.v1alpha1.Datastream/ListRoutes"
	Datastream_DeleteRoute_FullMethodName               = "/google.cloud.datastream.v1alpha1.Datastream/DeleteRoute"
)

// DatastreamClient is the client API for Datastream service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DatastreamClient interface {
	// Use this method to list connection profiles created in a project and
	// location.
	ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error)
	// Use this method to get details about a connection profile.
	GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error)
	// Use this method to create a connection profile in a project and location.
	CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to update the parameters of a connection profile.
	UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to delete a connection profile..
	DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to discover a connection profile.
	// The discover API call exposes the data objects and metadata belonging to
	// the profile. Typically, a request returns children data objects under a
	// parent data object that's optionally supplied in the request.
	DiscoverConnectionProfile(ctx context.Context, in *DiscoverConnectionProfileRequest, opts ...grpc.CallOption) (*DiscoverConnectionProfileResponse, error)
	// Use this method to list streams in a project and location.
	ListStreams(ctx context.Context, in *ListStreamsRequest, opts ...grpc.CallOption) (*ListStreamsResponse, error)
	// Use this method to get details about a stream.
	GetStream(ctx context.Context, in *GetStreamRequest, opts ...grpc.CallOption) (*Stream, error)
	// Use this method to create a stream.
	CreateStream(ctx context.Context, in *CreateStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to update the configuration of a stream.
	UpdateStream(ctx context.Context, in *UpdateStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to delete a stream.
	DeleteStream(ctx context.Context, in *DeleteStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to fetch any errors associated with a stream.
	FetchErrors(ctx context.Context, in *FetchErrorsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// The FetchStaticIps API call exposes the static ips used by Datastream.
	// Typically, a request returns children data objects under
	// a parent data object that's optionally supplied in the request.
	FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error)
	// Use this method to create a private connectivity configuration.
	CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to get details about a private connectivity configuration.
	GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error)
	// Use this method to list private connectivity configurations in a project
	// and location.
	ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error)
	// Use this method to delete a private connectivity configuration.
	DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to create a route for a private connectivity in a project
	// and location.
	CreateRoute(ctx context.Context, in *CreateRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Use this method to get details about a route.
	GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error)
	// Use this method to list routes created for a private connectivity in a
	// project and location.
	ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error)
	// Use this method to delete a route.
	DeleteRoute(ctx context.Context, in *DeleteRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type datastreamClient struct {
	cc grpc.ClientConnInterface
}

func NewDatastreamClient(cc grpc.ClientConnInterface) DatastreamClient {
	return &datastreamClient{cc}
}

func (c *datastreamClient) ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error) {
	out := new(ListConnectionProfilesResponse)
	err := c.cc.Invoke(ctx, Datastream_ListConnectionProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error) {
	out := new(ConnectionProfile)
	err := c.cc.Invoke(ctx, Datastream_GetConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_CreateConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_UpdateConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_DeleteConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) DiscoverConnectionProfile(ctx context.Context, in *DiscoverConnectionProfileRequest, opts ...grpc.CallOption) (*DiscoverConnectionProfileResponse, error) {
	out := new(DiscoverConnectionProfileResponse)
	err := c.cc.Invoke(ctx, Datastream_DiscoverConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) ListStreams(ctx context.Context, in *ListStreamsRequest, opts ...grpc.CallOption) (*ListStreamsResponse, error) {
	out := new(ListStreamsResponse)
	err := c.cc.Invoke(ctx, Datastream_ListStreams_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) GetStream(ctx context.Context, in *GetStreamRequest, opts ...grpc.CallOption) (*Stream, error) {
	out := new(Stream)
	err := c.cc.Invoke(ctx, Datastream_GetStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) CreateStream(ctx context.Context, in *CreateStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_CreateStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) UpdateStream(ctx context.Context, in *UpdateStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_UpdateStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) DeleteStream(ctx context.Context, in *DeleteStreamRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_DeleteStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) FetchErrors(ctx context.Context, in *FetchErrorsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_FetchErrors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error) {
	out := new(FetchStaticIpsResponse)
	err := c.cc.Invoke(ctx, Datastream_FetchStaticIps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_CreatePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error) {
	out := new(PrivateConnection)
	err := c.cc.Invoke(ctx, Datastream_GetPrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error) {
	out := new(ListPrivateConnectionsResponse)
	err := c.cc.Invoke(ctx, Datastream_ListPrivateConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_DeletePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) CreateRoute(ctx context.Context, in *CreateRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_CreateRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error) {
	out := new(Route)
	err := c.cc.Invoke(ctx, Datastream_GetRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error) {
	out := new(ListRoutesResponse)
	err := c.cc.Invoke(ctx, Datastream_ListRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastreamClient) DeleteRoute(ctx context.Context, in *DeleteRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Datastream_DeleteRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastreamServer is the server API for Datastream service.
// All implementations should embed UnimplementedDatastreamServer
// for forward compatibility
type DatastreamServer interface {
	// Use this method to list connection profiles created in a project and
	// location.
	ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error)
	// Use this method to get details about a connection profile.
	GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error)
	// Use this method to create a connection profile in a project and location.
	CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Use this method to update the parameters of a connection profile.
	UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Use this method to delete a connection profile..
	DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Use this method to discover a connection profile.
	// The discover API call exposes the data objects and metadata belonging to
	// the profile. Typically, a request returns children data objects under a
	// parent data object that's optionally supplied in the request.
	DiscoverConnectionProfile(context.Context, *DiscoverConnectionProfileRequest) (*DiscoverConnectionProfileResponse, error)
	// Use this method to list streams in a project and location.
	ListStreams(context.Context, *ListStreamsRequest) (*ListStreamsResponse, error)
	// Use this method to get details about a stream.
	GetStream(context.Context, *GetStreamRequest) (*Stream, error)
	// Use this method to create a stream.
	CreateStream(context.Context, *CreateStreamRequest) (*longrunningpb.Operation, error)
	// Use this method to update the configuration of a stream.
	UpdateStream(context.Context, *UpdateStreamRequest) (*longrunningpb.Operation, error)
	// Use this method to delete a stream.
	DeleteStream(context.Context, *DeleteStreamRequest) (*longrunningpb.Operation, error)
	// Use this method to fetch any errors associated with a stream.
	FetchErrors(context.Context, *FetchErrorsRequest) (*longrunningpb.Operation, error)
	// The FetchStaticIps API call exposes the static ips used by Datastream.
	// Typically, a request returns children data objects under
	// a parent data object that's optionally supplied in the request.
	FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error)
	// Use this method to create a private connectivity configuration.
	CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Use this method to get details about a private connectivity configuration.
	GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error)
	// Use this method to list private connectivity configurations in a project
	// and location.
	ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error)
	// Use this method to delete a private connectivity configuration.
	DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Use this method to create a route for a private connectivity in a project
	// and location.
	CreateRoute(context.Context, *CreateRouteRequest) (*longrunningpb.Operation, error)
	// Use this method to get details about a route.
	GetRoute(context.Context, *GetRouteRequest) (*Route, error)
	// Use this method to list routes created for a private connectivity in a
	// project and location.
	ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error)
	// Use this method to delete a route.
	DeleteRoute(context.Context, *DeleteRouteRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDatastreamServer should be embedded to have forward compatible implementations.
type UnimplementedDatastreamServer struct {
}

func (UnimplementedDatastreamServer) ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectionProfiles not implemented")
}
func (UnimplementedDatastreamServer) GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectionProfile not implemented")
}
func (UnimplementedDatastreamServer) CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectionProfile not implemented")
}
func (UnimplementedDatastreamServer) UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectionProfile not implemented")
}
func (UnimplementedDatastreamServer) DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectionProfile not implemented")
}
func (UnimplementedDatastreamServer) DiscoverConnectionProfile(context.Context, *DiscoverConnectionProfileRequest) (*DiscoverConnectionProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscoverConnectionProfile not implemented")
}
func (UnimplementedDatastreamServer) ListStreams(context.Context, *ListStreamsRequest) (*ListStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStreams not implemented")
}
func (UnimplementedDatastreamServer) GetStream(context.Context, *GetStreamRequest) (*Stream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStream not implemented")
}
func (UnimplementedDatastreamServer) CreateStream(context.Context, *CreateStreamRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateStream not implemented")
}
func (UnimplementedDatastreamServer) UpdateStream(context.Context, *UpdateStreamRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateStream not implemented")
}
func (UnimplementedDatastreamServer) DeleteStream(context.Context, *DeleteStreamRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteStream not implemented")
}
func (UnimplementedDatastreamServer) FetchErrors(context.Context, *FetchErrorsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchErrors not implemented")
}
func (UnimplementedDatastreamServer) FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchStaticIps not implemented")
}
func (UnimplementedDatastreamServer) CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateConnection not implemented")
}
func (UnimplementedDatastreamServer) GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConnection not implemented")
}
func (UnimplementedDatastreamServer) ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnections not implemented")
}
func (UnimplementedDatastreamServer) DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateConnection not implemented")
}
func (UnimplementedDatastreamServer) CreateRoute(context.Context, *CreateRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRoute not implemented")
}
func (UnimplementedDatastreamServer) GetRoute(context.Context, *GetRouteRequest) (*Route, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoute not implemented")
}
func (UnimplementedDatastreamServer) ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoutes not implemented")
}
func (UnimplementedDatastreamServer) DeleteRoute(context.Context, *DeleteRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRoute not implemented")
}

// UnsafeDatastreamServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DatastreamServer will
// result in compilation errors.
type UnsafeDatastreamServer interface {
	mustEmbedUnimplementedDatastreamServer()
}

func RegisterDatastreamServer(s grpc.ServiceRegistrar, srv DatastreamServer) {
	s.RegisterService(&Datastream_ServiceDesc, srv)
}

func _Datastream_ListConnectionProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).ListConnectionProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_ListConnectionProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).ListConnectionProfiles(ctx, req.(*ListConnectionProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_GetConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).GetConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_GetConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).GetConnectionProfile(ctx, req.(*GetConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_CreateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).CreateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_CreateConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).CreateConnectionProfile(ctx, req.(*CreateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_UpdateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).UpdateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_UpdateConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).UpdateConnectionProfile(ctx, req.(*UpdateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_DeleteConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).DeleteConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_DeleteConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).DeleteConnectionProfile(ctx, req.(*DeleteConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_DiscoverConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoverConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).DiscoverConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_DiscoverConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).DiscoverConnectionProfile(ctx, req.(*DiscoverConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_ListStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).ListStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_ListStreams_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).ListStreams(ctx, req.(*ListStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_GetStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).GetStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_GetStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).GetStream(ctx, req.(*GetStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_CreateStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).CreateStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_CreateStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).CreateStream(ctx, req.(*CreateStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_UpdateStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).UpdateStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_UpdateStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).UpdateStream(ctx, req.(*UpdateStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_DeleteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).DeleteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_DeleteStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).DeleteStream(ctx, req.(*DeleteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_FetchErrors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchErrorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).FetchErrors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_FetchErrors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).FetchErrors(ctx, req.(*FetchErrorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_FetchStaticIps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchStaticIpsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).FetchStaticIps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_FetchStaticIps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).FetchStaticIps(ctx, req.(*FetchStaticIpsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_CreatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).CreatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_CreatePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).CreatePrivateConnection(ctx, req.(*CreatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_GetPrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).GetPrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_GetPrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).GetPrivateConnection(ctx, req.(*GetPrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_ListPrivateConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).ListPrivateConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_ListPrivateConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).ListPrivateConnections(ctx, req.(*ListPrivateConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_DeletePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).DeletePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_DeletePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).DeletePrivateConnection(ctx, req.(*DeletePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_CreateRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).CreateRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_CreateRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).CreateRoute(ctx, req.(*CreateRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_GetRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).GetRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_GetRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).GetRoute(ctx, req.(*GetRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_ListRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).ListRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_ListRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).ListRoutes(ctx, req.(*ListRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastream_DeleteRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastreamServer).DeleteRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Datastream_DeleteRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastreamServer).DeleteRoute(ctx, req.(*DeleteRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Datastream_ServiceDesc is the grpc.ServiceDesc for Datastream service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Datastream_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datastream.v1alpha1.Datastream",
	HandlerType: (*DatastreamServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConnectionProfiles",
			Handler:    _Datastream_ListConnectionProfiles_Handler,
		},
		{
			MethodName: "GetConnectionProfile",
			Handler:    _Datastream_GetConnectionProfile_Handler,
		},
		{
			MethodName: "CreateConnectionProfile",
			Handler:    _Datastream_CreateConnectionProfile_Handler,
		},
		{
			MethodName: "UpdateConnectionProfile",
			Handler:    _Datastream_UpdateConnectionProfile_Handler,
		},
		{
			MethodName: "DeleteConnectionProfile",
			Handler:    _Datastream_DeleteConnectionProfile_Handler,
		},
		{
			MethodName: "DiscoverConnectionProfile",
			Handler:    _Datastream_DiscoverConnectionProfile_Handler,
		},
		{
			MethodName: "ListStreams",
			Handler:    _Datastream_ListStreams_Handler,
		},
		{
			MethodName: "GetStream",
			Handler:    _Datastream_GetStream_Handler,
		},
		{
			MethodName: "CreateStream",
			Handler:    _Datastream_CreateStream_Handler,
		},
		{
			MethodName: "UpdateStream",
			Handler:    _Datastream_UpdateStream_Handler,
		},
		{
			MethodName: "DeleteStream",
			Handler:    _Datastream_DeleteStream_Handler,
		},
		{
			MethodName: "FetchErrors",
			Handler:    _Datastream_FetchErrors_Handler,
		},
		{
			MethodName: "FetchStaticIps",
			Handler:    _Datastream_FetchStaticIps_Handler,
		},
		{
			MethodName: "CreatePrivateConnection",
			Handler:    _Datastream_CreatePrivateConnection_Handler,
		},
		{
			MethodName: "GetPrivateConnection",
			Handler:    _Datastream_GetPrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnections",
			Handler:    _Datastream_ListPrivateConnections_Handler,
		},
		{
			MethodName: "DeletePrivateConnection",
			Handler:    _Datastream_DeletePrivateConnection_Handler,
		},
		{
			MethodName: "CreateRoute",
			Handler:    _Datastream_CreateRoute_Handler,
		},
		{
			MethodName: "GetRoute",
			Handler:    _Datastream_GetRoute_Handler,
		},
		{
			MethodName: "ListRoutes",
			Handler:    _Datastream_ListRoutes_Handler,
		},
		{
			MethodName: "DeleteRoute",
			Handler:    _Datastream_DeleteRoute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datastream/v1alpha1/datastream.proto",
}
