// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/dataflow/v1beta3/jobs.proto

package dataflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of transform or stage operation.
type KindType int32

const (
	// Unrecognized transform type.
	KindType_UNKNOWN_KIND KindType = 0
	// ParDo transform.
	KindType_PAR_DO_KIND KindType = 1
	// Group By Key transform.
	KindType_GROUP_BY_KEY_KIND KindType = 2
	// Flatten transform.
	KindType_FLATTEN_KIND KindType = 3
	// Read transform.
	KindType_READ_KIND KindType = 4
	// Write transform.
	KindType_WRITE_KIND KindType = 5
	// Constructs from a constant value, such as with Create.of.
	KindType_CONSTANT_KIND KindType = 6
	// Creates a Singleton view of a collection.
	KindType_SINGLETON_KIND KindType = 7
	// Opening or closing a shuffle session, often as part of a GroupByKey.
	KindType_SHUFFLE_KIND KindType = 8
)

// Enum value maps for KindType.
var (
	KindType_name = map[int32]string{
		0: "UNKNOWN_KIND",
		1: "PAR_DO_KIND",
		2: "GROUP_BY_KEY_KIND",
		3: "FLATTEN_KIND",
		4: "READ_KIND",
		5: "WRITE_KIND",
		6: "CONSTANT_KIND",
		7: "SINGLETON_KIND",
		8: "SHUFFLE_KIND",
	}
	KindType_value = map[string]int32{
		"UNKNOWN_KIND":      0,
		"PAR_DO_KIND":       1,
		"GROUP_BY_KEY_KIND": 2,
		"FLATTEN_KIND":      3,
		"READ_KIND":         4,
		"WRITE_KIND":        5,
		"CONSTANT_KIND":     6,
		"SINGLETON_KIND":    7,
		"SHUFFLE_KIND":      8,
	}
)

func (x KindType) Enum() *KindType {
	p := new(KindType)
	*p = x
	return p
}

func (x KindType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KindType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_jobs_proto_enumTypes[0].Descriptor()
}

func (KindType) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_jobs_proto_enumTypes[0]
}

func (x KindType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KindType.Descriptor instead.
func (KindType) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{0}
}

// Describes the overall state of a [google.dataflow.v1beta3.Job][google.dataflow.v1beta3.Job].
type JobState int32

const (
	// The job's run state isn't specified.
	JobState_JOB_STATE_UNKNOWN JobState = 0
	// `JOB_STATE_STOPPED` indicates that the job has not
	// yet started to run.
	JobState_JOB_STATE_STOPPED JobState = 1
	// `JOB_STATE_RUNNING` indicates that the job is currently running.
	JobState_JOB_STATE_RUNNING JobState = 2
	// `JOB_STATE_DONE` indicates that the job has successfully completed.
	// This is a terminal job state.  This state may be set by the Cloud Dataflow
	// service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a
	// Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal
	// state.
	JobState_JOB_STATE_DONE JobState = 3
	// `JOB_STATE_FAILED` indicates that the job has failed.  This is a
	// terminal job state.  This state may only be set by the Cloud Dataflow
	// service, and only as a transition from `JOB_STATE_RUNNING`.
	JobState_JOB_STATE_FAILED JobState = 4
	// `JOB_STATE_CANCELLED` indicates that the job has been explicitly
	// cancelled. This is a terminal job state. This state may only be
	// set via a Cloud Dataflow `UpdateJob` call, and only if the job has not
	// yet reached another terminal state.
	JobState_JOB_STATE_CANCELLED JobState = 5
	// `JOB_STATE_UPDATED` indicates that the job was successfully updated,
	// meaning that this job was stopped and another job was started, inheriting
	// state from this one. This is a terminal job state. This state may only be
	// set by the Cloud Dataflow service, and only as a transition from
	// `JOB_STATE_RUNNING`.
	JobState_JOB_STATE_UPDATED JobState = 6
	// `JOB_STATE_DRAINING` indicates that the job is in the process of draining.
	// A draining job has stopped pulling from its input sources and is processing
	// any data that remains in-flight. This state may be set via a Cloud Dataflow
	// `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs
	// that are draining may only transition to `JOB_STATE_DRAINED`,
	// `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
	JobState_JOB_STATE_DRAINING JobState = 7
	// `JOB_STATE_DRAINED` indicates that the job has been drained.
	// A drained job terminated by stopping pulling from its input sources and
	// processing any data that remained in-flight when draining was requested.
	// This state is a terminal state, may only be set by the Cloud Dataflow
	// service, and only as a transition from `JOB_STATE_DRAINING`.
	JobState_JOB_STATE_DRAINED JobState = 8
	// `JOB_STATE_PENDING` indicates that the job has been created but is not yet
	// running.  Jobs that are pending may only transition to `JOB_STATE_RUNNING`,
	// or `JOB_STATE_FAILED`.
	JobState_JOB_STATE_PENDING JobState = 9
	// `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled
	// and is in the process of stopping.  Jobs that are cancelling may only
	// transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
	JobState_JOB_STATE_CANCELLING JobState = 10
	// `JOB_STATE_QUEUED` indicates that the job has been created but is being
	// delayed until launch. Jobs that are queued may only transition to
	// `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
	JobState_JOB_STATE_QUEUED JobState = 11
	// `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated
	// resources are currently being cleaned up after a successful run.
	// Currently, this is an opt-in feature, please reach out to Cloud support
	// team if you are interested.
	JobState_JOB_STATE_RESOURCE_CLEANING_UP JobState = 12
)

// Enum value maps for JobState.
var (
	JobState_name = map[int32]string{
		0:  "JOB_STATE_UNKNOWN",
		1:  "JOB_STATE_STOPPED",
		2:  "JOB_STATE_RUNNING",
		3:  "JOB_STATE_DONE",
		4:  "JOB_STATE_FAILED",
		5:  "JOB_STATE_CANCELLED",
		6:  "JOB_STATE_UPDATED",
		7:  "JOB_STATE_DRAINING",
		8:  "JOB_STATE_DRAINED",
		9:  "JOB_STATE_PENDING",
		10: "JOB_STATE_CANCELLING",
		11: "JOB_STATE_QUEUED",
		12: "JOB_STATE_RESOURCE_CLEANING_UP",
	}
	JobState_value = map[string]int32{
		"JOB_STATE_UNKNOWN":              0,
		"JOB_STATE_STOPPED":              1,
		"JOB_STATE_RUNNING":              2,
		"JOB_STATE_DONE":                 3,
		"JOB_STATE_FAILED":               4,
		"JOB_STATE_CANCELLED":            5,
		"JOB_STATE_UPDATED":              6,
		"JOB_STATE_DRAINING":             7,
		"JOB_STATE_DRAINED":              8,
		"JOB_STATE_PENDING":              9,
		"JOB_STATE_CANCELLING":           10,
		"JOB_STATE_QUEUED":               11,
		"JOB_STATE_RESOURCE_CLEANING_UP": 12,
	}
)

func (x JobState) Enum() *JobState {
	p := new(JobState)
	*p = x
	return p
}

func (x JobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_jobs_proto_enumTypes[1].Descriptor()
}

func (JobState) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_jobs_proto_enumTypes[1]
}

func (x JobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobState.Descriptor instead.
func (JobState) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{1}
}

// Selector for how much information is returned in Job responses.
type JobView int32

const (
	// The job view to return isn't specified, or is unknown.
	// Responses will contain at least the `JOB_VIEW_SUMMARY` information,
	// and may contain additional information.
	JobView_JOB_VIEW_UNKNOWN JobView = 0
	// Request summary information only:
	// Project ID, Job ID, job name, job type, job status, start/end time,
	// and Cloud SDK version details.
	JobView_JOB_VIEW_SUMMARY JobView = 1
	// Request all information available for this job.
	JobView_JOB_VIEW_ALL JobView = 2
	// Request summary info and limited job description data for steps, labels and
	// environment.
	JobView_JOB_VIEW_DESCRIPTION JobView = 3
)

// Enum value maps for JobView.
var (
	JobView_name = map[int32]string{
		0: "JOB_VIEW_UNKNOWN",
		1: "JOB_VIEW_SUMMARY",
		2: "JOB_VIEW_ALL",
		3: "JOB_VIEW_DESCRIPTION",
	}
	JobView_value = map[string]int32{
		"JOB_VIEW_UNKNOWN":     0,
		"JOB_VIEW_SUMMARY":     1,
		"JOB_VIEW_ALL":         2,
		"JOB_VIEW_DESCRIPTION": 3,
	}
)

func (x JobView) Enum() *JobView {
	p := new(JobView)
	*p = x
	return p
}

func (x JobView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_jobs_proto_enumTypes[2].Descriptor()
}

func (JobView) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_jobs_proto_enumTypes[2]
}

func (x JobView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobView.Descriptor instead.
func (JobView) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{2}
}

// The support status of the SDK used to run the job.
type SdkVersion_SdkSupportStatus int32

const (
	// Cloud Dataflow is unaware of this version.
	SdkVersion_UNKNOWN SdkVersion_SdkSupportStatus = 0
	// This is a known version of an SDK, and is supported.
	SdkVersion_SUPPORTED SdkVersion_SdkSupportStatus = 1
	// A newer version of the SDK family exists, and an update is recommended.
	SdkVersion_STALE SdkVersion_SdkSupportStatus = 2
	// This version of the SDK is deprecated and will eventually be
	// unsupported.
	SdkVersion_DEPRECATED SdkVersion_SdkSupportStatus = 3
	// Support for this SDK version has ended and it should no longer be used.
	SdkVersion_UNSUPPORTED SdkVersion_SdkSupportStatus = 4
)

// Enum value maps for SdkVersion_SdkSupportStatus.
var (
	SdkVersion_SdkSupportStatus_name = map[int32]string{
		0: "UNKNOWN",
		1: "SUPPORTED",
		2: "STALE",
		3: "DEPRECATED",
		4: "UNSUPPORTED",
	}
	SdkVersion_SdkSupportStatus_value = map[string]int32{
		"UNKNOWN":     0,
		"SUPPORTED":   1,
		"STALE":       2,
		"DEPRECATED":  3,
		"UNSUPPORTED": 4,
	}
)

func (x SdkVersion_SdkSupportStatus) Enum() *SdkVersion_SdkSupportStatus {
	p := new(SdkVersion_SdkSupportStatus)
	*p = x
	return p
}

func (x SdkVersion_SdkSupportStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SdkVersion_SdkSupportStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_jobs_proto_enumTypes[3].Descriptor()
}

func (SdkVersion_SdkSupportStatus) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_jobs_proto_enumTypes[3]
}

func (x SdkVersion_SdkSupportStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SdkVersion_SdkSupportStatus.Descriptor instead.
func (SdkVersion_SdkSupportStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{7, 0}
}

// This field filters out and returns jobs in the specified job state. The
// order of data returned is determined by the filter used, and is subject to
// change.
type ListJobsRequest_Filter int32

const (
	// The filter isn't specified, or is unknown. This returns all jobs ordered
	// on descending `JobUuid`.
	ListJobsRequest_UNKNOWN ListJobsRequest_Filter = 0
	// Returns all running jobs first ordered on creation timestamp, then
	// returns all terminated jobs ordered on the termination timestamp.
	ListJobsRequest_ALL ListJobsRequest_Filter = 1
	// Filters the jobs that have a terminated state, ordered on the
	// termination timestamp. Example terminated states: `JOB_STATE_STOPPED`,
	// `JOB_STATE_UPDATED`, `JOB_STATE_DRAINED`, etc.
	ListJobsRequest_TERMINATED ListJobsRequest_Filter = 2
	// Filters the jobs that are running ordered on the creation timestamp.
	ListJobsRequest_ACTIVE ListJobsRequest_Filter = 3
)

// Enum value maps for ListJobsRequest_Filter.
var (
	ListJobsRequest_Filter_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALL",
		2: "TERMINATED",
		3: "ACTIVE",
	}
	ListJobsRequest_Filter_value = map[string]int32{
		"UNKNOWN":    0,
		"ALL":        1,
		"TERMINATED": 2,
		"ACTIVE":     3,
	}
)

func (x ListJobsRequest_Filter) Enum() *ListJobsRequest_Filter {
	p := new(ListJobsRequest_Filter)
	*p = x
	return p
}

func (x ListJobsRequest_Filter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListJobsRequest_Filter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_jobs_proto_enumTypes[4].Descriptor()
}

func (ListJobsRequest_Filter) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_jobs_proto_enumTypes[4]
}

func (x ListJobsRequest_Filter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListJobsRequest_Filter.Descriptor instead.
func (ListJobsRequest_Filter) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{20, 0}
}

// Defines a job to be run by the Cloud Dataflow service.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of this job.
	//
	// This field is set by the Cloud Dataflow service when the Job is
	// created, and is immutable for the life of the job.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The user-specified Cloud Dataflow job name.
	//
	// Only one Job with a given name may exist in a project at any
	// given time. If a caller attempts to create a Job with the same
	// name as an already-existing Job, the attempt returns the
	// existing Job.
	//
	// The name must match the regular expression
	// `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The type of Cloud Dataflow job.
	Type JobType `protobuf:"varint,4,opt,name=type,proto3,enum=google.dataflow.v1beta3.JobType" json:"type,omitempty"`
	// The environment for the job.
	Environment *Environment `protobuf:"bytes,5,opt,name=environment,proto3" json:"environment,omitempty"`
	// Exactly one of step or steps_location should be specified.
	//
	// The top-level steps that constitute the entire job. Only retrieved with
	// JOB_VIEW_ALL.
	Steps []*Step `protobuf:"bytes,6,rep,name=steps,proto3" json:"steps,omitempty"`
	// The Cloud Storage location where the steps are stored.
	StepsLocation string `protobuf:"bytes,24,opt,name=steps_location,json=stepsLocation,proto3" json:"steps_location,omitempty"`
	// The current state of the job.
	//
	// Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
	// specified.
	//
	// A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
	// terminal state. After a job has reached a terminal state, no
	// further state updates may be made.
	//
	// This field may be mutated by the Cloud Dataflow service;
	// callers cannot mutate it.
	CurrentState JobState `protobuf:"varint,7,opt,name=current_state,json=currentState,proto3,enum=google.dataflow.v1beta3.JobState" json:"current_state,omitempty"`
	// The timestamp associated with the current state.
	CurrentStateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=current_state_time,json=currentStateTime,proto3" json:"current_state_time,omitempty"`
	// The job's requested state.
	//
	// `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and
	// `JOB_STATE_RUNNING` states, by setting requested_state.  `UpdateJob` may
	// also be used to directly set a job's requested state to
	// `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the
	// job if it has not already reached a terminal state.
	RequestedState JobState `protobuf:"varint,9,opt,name=requested_state,json=requestedState,proto3,enum=google.dataflow.v1beta3.JobState" json:"requested_state,omitempty"`
	// Deprecated.
	ExecutionInfo *JobExecutionInfo `protobuf:"bytes,10,opt,name=execution_info,json=executionInfo,proto3" json:"execution_info,omitempty"`
	// The timestamp when the job was initially created. Immutable and set by the
	// Cloud Dataflow service.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// If this job is an update of an existing job, this field is the job ID
	// of the job it replaced.
	//
	// When sending a `CreateJobRequest`, you can update a job by specifying it
	// here. The job named here is stopped, and its intermediate state is
	// transferred to this job.
	ReplaceJobId string `protobuf:"bytes,12,opt,name=replace_job_id,json=replaceJobId,proto3" json:"replace_job_id,omitempty"`
	// The map of transform name prefixes of the job to be replaced to the
	// corresponding name prefixes of the new job.
	TransformNameMapping map[string]string `protobuf:"bytes,13,rep,name=transform_name_mapping,json=transformNameMapping,proto3" json:"transform_name_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The client's unique identifier of the job, re-used across retried attempts.
	// If this field is set, the service will ensure its uniqueness.
	// The request to create a job will fail if the service has knowledge of a
	// previously submitted job with the same client's ID and job name.
	// The caller may use this field to ensure idempotence of job
	// creation across retried attempts to create a job.
	// By default, the field is empty and, in that case, the service ignores it.
	ClientRequestId string `protobuf:"bytes,14,opt,name=client_request_id,json=clientRequestId,proto3" json:"client_request_id,omitempty"`
	// If another job is an update of this job (and thus, this job is in
	// `JOB_STATE_UPDATED`), this field contains the ID of that job.
	ReplacedByJobId string `protobuf:"bytes,15,opt,name=replaced_by_job_id,json=replacedByJobId,proto3" json:"replaced_by_job_id,omitempty"`
	// A set of files the system should be aware of that are used
	// for temporary storage. These temporary files will be
	// removed on job completion.
	// No duplicates are allowed.
	// No file patterns are supported.
	//
	// The supported files are:
	//
	// Google Cloud Storage:
	//
	//	storage.googleapis.com/{bucket}/{object}
	//	bucket.storage.googleapis.com/{object}
	TempFiles []string `protobuf:"bytes,16,rep,name=temp_files,json=tempFiles,proto3" json:"temp_files,omitempty"`
	// User-defined labels for this job.
	//
	// The labels map can contain no more than 64 entries.  Entries of the labels
	// map are UTF8 strings that comply with the following restrictions:
	//
	// * Keys must conform to regexp:  [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	// * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	// * Both keys and values are additionally constrained to be <= 128 bytes in
	// size.
	Labels map[string]string `protobuf:"bytes,17,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains this job.
	Location string `protobuf:"bytes,18,opt,name=location,proto3" json:"location,omitempty"`
	// Preliminary field: The format of this data may change at any time.
	// A description of the user pipeline and stages through which it is executed.
	// Created by Cloud Dataflow service.  Only retrieved with
	// JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
	PipelineDescription *PipelineDescription `protobuf:"bytes,19,opt,name=pipeline_description,json=pipelineDescription,proto3" json:"pipeline_description,omitempty"`
	// This field may be mutated by the Cloud Dataflow service;
	// callers cannot mutate it.
	StageStates []*ExecutionStageState `protobuf:"bytes,20,rep,name=stage_states,json=stageStates,proto3" json:"stage_states,omitempty"`
	// This field is populated by the Dataflow service to support filtering jobs
	// by the metadata values provided here. Populated for ListJobs and all GetJob
	// views SUMMARY and higher.
	JobMetadata *JobMetadata `protobuf:"bytes,21,opt,name=job_metadata,json=jobMetadata,proto3" json:"job_metadata,omitempty"`
	// The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
	// Flexible resource scheduling jobs are started with some delay after job
	// creation, so start_time is unset before start and is updated when the
	// job is started by the Cloud Dataflow service. For other jobs, start_time
	// always equals to create_time and is immutable and set by the Cloud Dataflow
	// service.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// If this is specified, the job's initial state is populated from the given
	// snapshot.
	CreatedFromSnapshotId string `protobuf:"bytes,23,opt,name=created_from_snapshot_id,json=createdFromSnapshotId,proto3" json:"created_from_snapshot_id,omitempty"`
	// Reserved for future use. This field is set only in responses from the
	// server; it is ignored if it is set in any requests.
	SatisfiesPzs bool `protobuf:"varint,25,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Job) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetType() JobType {
	if x != nil {
		return x.Type
	}
	return JobType_JOB_TYPE_UNKNOWN
}

func (x *Job) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Job) GetSteps() []*Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Job) GetStepsLocation() string {
	if x != nil {
		return x.StepsLocation
	}
	return ""
}

func (x *Job) GetCurrentState() JobState {
	if x != nil {
		return x.CurrentState
	}
	return JobState_JOB_STATE_UNKNOWN
}

func (x *Job) GetCurrentStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentStateTime
	}
	return nil
}

func (x *Job) GetRequestedState() JobState {
	if x != nil {
		return x.RequestedState
	}
	return JobState_JOB_STATE_UNKNOWN
}

func (x *Job) GetExecutionInfo() *JobExecutionInfo {
	if x != nil {
		return x.ExecutionInfo
	}
	return nil
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetReplaceJobId() string {
	if x != nil {
		return x.ReplaceJobId
	}
	return ""
}

func (x *Job) GetTransformNameMapping() map[string]string {
	if x != nil {
		return x.TransformNameMapping
	}
	return nil
}

func (x *Job) GetClientRequestId() string {
	if x != nil {
		return x.ClientRequestId
	}
	return ""
}

func (x *Job) GetReplacedByJobId() string {
	if x != nil {
		return x.ReplacedByJobId
	}
	return ""
}

func (x *Job) GetTempFiles() []string {
	if x != nil {
		return x.TempFiles
	}
	return nil
}

func (x *Job) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Job) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Job) GetPipelineDescription() *PipelineDescription {
	if x != nil {
		return x.PipelineDescription
	}
	return nil
}

func (x *Job) GetStageStates() []*ExecutionStageState {
	if x != nil {
		return x.StageStates
	}
	return nil
}

func (x *Job) GetJobMetadata() *JobMetadata {
	if x != nil {
		return x.JobMetadata
	}
	return nil
}

func (x *Job) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Job) GetCreatedFromSnapshotId() string {
	if x != nil {
		return x.CreatedFromSnapshotId
	}
	return ""
}

func (x *Job) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

// Metadata for a Datastore connector used by the job.
type DatastoreIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Namespace used in the connection.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// ProjectId accessed in the connection.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DatastoreIODetails) Reset() {
	*x = DatastoreIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatastoreIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatastoreIODetails) ProtoMessage() {}

func (x *DatastoreIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatastoreIODetails.ProtoReflect.Descriptor instead.
func (*DatastoreIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{1}
}

func (x *DatastoreIODetails) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *DatastoreIODetails) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Metadata for a Pub/Sub connector used by the job.
type PubSubIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Topic accessed in the connection.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Subscription used in the connection.
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *PubSubIODetails) Reset() {
	*x = PubSubIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubIODetails) ProtoMessage() {}

func (x *PubSubIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubIODetails.ProtoReflect.Descriptor instead.
func (*PubSubIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{2}
}

func (x *PubSubIODetails) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *PubSubIODetails) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

// Metadata for a File connector used by the job.
type FileIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File Pattern used to access files by the connector.
	FilePattern string `protobuf:"bytes,1,opt,name=file_pattern,json=filePattern,proto3" json:"file_pattern,omitempty"`
}

func (x *FileIODetails) Reset() {
	*x = FileIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileIODetails) ProtoMessage() {}

func (x *FileIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileIODetails.ProtoReflect.Descriptor instead.
func (*FileIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{3}
}

func (x *FileIODetails) GetFilePattern() string {
	if x != nil {
		return x.FilePattern
	}
	return ""
}

// Metadata for a Cloud Bigtable connector used by the job.
type BigTableIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ProjectId accessed in the connection.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// InstanceId accessed in the connection.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// TableId accessed in the connection.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *BigTableIODetails) Reset() {
	*x = BigTableIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigTableIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigTableIODetails) ProtoMessage() {}

func (x *BigTableIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigTableIODetails.ProtoReflect.Descriptor instead.
func (*BigTableIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{4}
}

func (x *BigTableIODetails) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigTableIODetails) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *BigTableIODetails) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// Metadata for a BigQuery connector used by the job.
type BigQueryIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table accessed in the connection.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Dataset accessed in the connection.
	Dataset string `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Project accessed in the connection.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Query used to access data in the connection.
	Query string `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *BigQueryIODetails) Reset() {
	*x = BigQueryIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryIODetails) ProtoMessage() {}

func (x *BigQueryIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryIODetails.ProtoReflect.Descriptor instead.
func (*BigQueryIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{5}
}

func (x *BigQueryIODetails) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryIODetails) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BigQueryIODetails) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQueryIODetails) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// Metadata for a Spanner connector used by the job.
type SpannerIODetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ProjectId accessed in the connection.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// InstanceId accessed in the connection.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// DatabaseId accessed in the connection.
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
}

func (x *SpannerIODetails) Reset() {
	*x = SpannerIODetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpannerIODetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerIODetails) ProtoMessage() {}

func (x *SpannerIODetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerIODetails.ProtoReflect.Descriptor instead.
func (*SpannerIODetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{6}
}

func (x *SpannerIODetails) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SpannerIODetails) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *SpannerIODetails) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

// The version of the SDK used to run the job.
type SdkVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the SDK used to run the job.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// A readable string describing the version of the SDK.
	VersionDisplayName string `protobuf:"bytes,2,opt,name=version_display_name,json=versionDisplayName,proto3" json:"version_display_name,omitempty"`
	// The support status for this SDK version.
	SdkSupportStatus SdkVersion_SdkSupportStatus `protobuf:"varint,3,opt,name=sdk_support_status,json=sdkSupportStatus,proto3,enum=google.dataflow.v1beta3.SdkVersion_SdkSupportStatus" json:"sdk_support_status,omitempty"`
}

func (x *SdkVersion) Reset() {
	*x = SdkVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SdkVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdkVersion) ProtoMessage() {}

func (x *SdkVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdkVersion.ProtoReflect.Descriptor instead.
func (*SdkVersion) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{7}
}

func (x *SdkVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SdkVersion) GetVersionDisplayName() string {
	if x != nil {
		return x.VersionDisplayName
	}
	return ""
}

func (x *SdkVersion) GetSdkSupportStatus() SdkVersion_SdkSupportStatus {
	if x != nil {
		return x.SdkSupportStatus
	}
	return SdkVersion_UNKNOWN
}

// Metadata available primarily for filtering jobs. Will be included in the
// ListJob response and Job SUMMARY view.
type JobMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SDK version used to run the job.
	SdkVersion *SdkVersion `protobuf:"bytes,1,opt,name=sdk_version,json=sdkVersion,proto3" json:"sdk_version,omitempty"`
	// Identification of a Spanner source used in the Dataflow job.
	SpannerDetails []*SpannerIODetails `protobuf:"bytes,2,rep,name=spanner_details,json=spannerDetails,proto3" json:"spanner_details,omitempty"`
	// Identification of a BigQuery source used in the Dataflow job.
	BigqueryDetails []*BigQueryIODetails `protobuf:"bytes,3,rep,name=bigquery_details,json=bigqueryDetails,proto3" json:"bigquery_details,omitempty"`
	// Identification of a Cloud Bigtable source used in the Dataflow job.
	BigTableDetails []*BigTableIODetails `protobuf:"bytes,4,rep,name=big_table_details,json=bigTableDetails,proto3" json:"big_table_details,omitempty"`
	// Identification of a Pub/Sub source used in the Dataflow job.
	PubsubDetails []*PubSubIODetails `protobuf:"bytes,5,rep,name=pubsub_details,json=pubsubDetails,proto3" json:"pubsub_details,omitempty"`
	// Identification of a File source used in the Dataflow job.
	FileDetails []*FileIODetails `protobuf:"bytes,6,rep,name=file_details,json=fileDetails,proto3" json:"file_details,omitempty"`
	// Identification of a Datastore source used in the Dataflow job.
	DatastoreDetails []*DatastoreIODetails `protobuf:"bytes,7,rep,name=datastore_details,json=datastoreDetails,proto3" json:"datastore_details,omitempty"`
}

func (x *JobMetadata) Reset() {
	*x = JobMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMetadata) ProtoMessage() {}

func (x *JobMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMetadata.ProtoReflect.Descriptor instead.
func (*JobMetadata) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{8}
}

func (x *JobMetadata) GetSdkVersion() *SdkVersion {
	if x != nil {
		return x.SdkVersion
	}
	return nil
}

func (x *JobMetadata) GetSpannerDetails() []*SpannerIODetails {
	if x != nil {
		return x.SpannerDetails
	}
	return nil
}

func (x *JobMetadata) GetBigqueryDetails() []*BigQueryIODetails {
	if x != nil {
		return x.BigqueryDetails
	}
	return nil
}

func (x *JobMetadata) GetBigTableDetails() []*BigTableIODetails {
	if x != nil {
		return x.BigTableDetails
	}
	return nil
}

func (x *JobMetadata) GetPubsubDetails() []*PubSubIODetails {
	if x != nil {
		return x.PubsubDetails
	}
	return nil
}

func (x *JobMetadata) GetFileDetails() []*FileIODetails {
	if x != nil {
		return x.FileDetails
	}
	return nil
}

func (x *JobMetadata) GetDatastoreDetails() []*DatastoreIODetails {
	if x != nil {
		return x.DatastoreDetails
	}
	return nil
}

// A message describing the state of a particular execution stage.
type ExecutionStageState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the execution stage.
	ExecutionStageName string `protobuf:"bytes,1,opt,name=execution_stage_name,json=executionStageName,proto3" json:"execution_stage_name,omitempty"`
	// Executions stage states allow the same set of values as JobState.
	ExecutionStageState JobState `protobuf:"varint,2,opt,name=execution_stage_state,json=executionStageState,proto3,enum=google.dataflow.v1beta3.JobState" json:"execution_stage_state,omitempty"`
	// The time at which the stage transitioned to this state.
	CurrentStateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=current_state_time,json=currentStateTime,proto3" json:"current_state_time,omitempty"`
}

func (x *ExecutionStageState) Reset() {
	*x = ExecutionStageState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStageState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStageState) ProtoMessage() {}

func (x *ExecutionStageState) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStageState.ProtoReflect.Descriptor instead.
func (*ExecutionStageState) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{9}
}

func (x *ExecutionStageState) GetExecutionStageName() string {
	if x != nil {
		return x.ExecutionStageName
	}
	return ""
}

func (x *ExecutionStageState) GetExecutionStageState() JobState {
	if x != nil {
		return x.ExecutionStageState
	}
	return JobState_JOB_STATE_UNKNOWN
}

func (x *ExecutionStageState) GetCurrentStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentStateTime
	}
	return nil
}

// A descriptive representation of submitted pipeline as well as the executed
// form.  This data is provided by the Dataflow service for ease of visualizing
// the pipeline and interpreting Dataflow provided metrics.
type PipelineDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of each transform in the pipeline and collections between them.
	OriginalPipelineTransform []*TransformSummary `protobuf:"bytes,1,rep,name=original_pipeline_transform,json=originalPipelineTransform,proto3" json:"original_pipeline_transform,omitempty"`
	// Description of each stage of execution of the pipeline.
	ExecutionPipelineStage []*ExecutionStageSummary `protobuf:"bytes,2,rep,name=execution_pipeline_stage,json=executionPipelineStage,proto3" json:"execution_pipeline_stage,omitempty"`
	// Pipeline level display data.
	DisplayData []*DisplayData `protobuf:"bytes,3,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
}

func (x *PipelineDescription) Reset() {
	*x = PipelineDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineDescription) ProtoMessage() {}

func (x *PipelineDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineDescription.ProtoReflect.Descriptor instead.
func (*PipelineDescription) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{10}
}

func (x *PipelineDescription) GetOriginalPipelineTransform() []*TransformSummary {
	if x != nil {
		return x.OriginalPipelineTransform
	}
	return nil
}

func (x *PipelineDescription) GetExecutionPipelineStage() []*ExecutionStageSummary {
	if x != nil {
		return x.ExecutionPipelineStage
	}
	return nil
}

func (x *PipelineDescription) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

// Description of the type, names/ids, and input/outputs for a transform.
type TransformSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of transform.
	Kind KindType `protobuf:"varint,1,opt,name=kind,proto3,enum=google.dataflow.v1beta3.KindType" json:"kind,omitempty"`
	// SDK generated id of this transform instance.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// User provided name for this transform instance.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Transform-specific display data.
	DisplayData []*DisplayData `protobuf:"bytes,4,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// User  names for all collection outputs to this transform.
	OutputCollectionName []string `protobuf:"bytes,5,rep,name=output_collection_name,json=outputCollectionName,proto3" json:"output_collection_name,omitempty"`
	// User names for all collection inputs to this transform.
	InputCollectionName []string `protobuf:"bytes,6,rep,name=input_collection_name,json=inputCollectionName,proto3" json:"input_collection_name,omitempty"`
}

func (x *TransformSummary) Reset() {
	*x = TransformSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformSummary) ProtoMessage() {}

func (x *TransformSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformSummary.ProtoReflect.Descriptor instead.
func (*TransformSummary) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{11}
}

func (x *TransformSummary) GetKind() KindType {
	if x != nil {
		return x.Kind
	}
	return KindType_UNKNOWN_KIND
}

func (x *TransformSummary) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TransformSummary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransformSummary) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

func (x *TransformSummary) GetOutputCollectionName() []string {
	if x != nil {
		return x.OutputCollectionName
	}
	return nil
}

func (x *TransformSummary) GetInputCollectionName() []string {
	if x != nil {
		return x.InputCollectionName
	}
	return nil
}

// Description of the composing transforms, names/ids, and input/outputs of a
// stage of execution.  Some composing transforms and sources may have been
// generated by the Dataflow service during execution planning.
type ExecutionStageSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataflow service generated name for this stage.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Dataflow service generated id for this stage.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Type of transform this stage is executing.
	Kind KindType `protobuf:"varint,3,opt,name=kind,proto3,enum=google.dataflow.v1beta3.KindType" json:"kind,omitempty"`
	// Input sources for this stage.
	InputSource []*ExecutionStageSummary_StageSource `protobuf:"bytes,4,rep,name=input_source,json=inputSource,proto3" json:"input_source,omitempty"`
	// Output sources for this stage.
	OutputSource []*ExecutionStageSummary_StageSource `protobuf:"bytes,5,rep,name=output_source,json=outputSource,proto3" json:"output_source,omitempty"`
	// Other stages that must complete before this stage can run.
	PrerequisiteStage []string `protobuf:"bytes,8,rep,name=prerequisite_stage,json=prerequisiteStage,proto3" json:"prerequisite_stage,omitempty"`
	// Transforms that comprise this execution stage.
	ComponentTransform []*ExecutionStageSummary_ComponentTransform `protobuf:"bytes,6,rep,name=component_transform,json=componentTransform,proto3" json:"component_transform,omitempty"`
	// Collections produced and consumed by component transforms of this stage.
	ComponentSource []*ExecutionStageSummary_ComponentSource `protobuf:"bytes,7,rep,name=component_source,json=componentSource,proto3" json:"component_source,omitempty"`
}

func (x *ExecutionStageSummary) Reset() {
	*x = ExecutionStageSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStageSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStageSummary) ProtoMessage() {}

func (x *ExecutionStageSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStageSummary.ProtoReflect.Descriptor instead.
func (*ExecutionStageSummary) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{12}
}

func (x *ExecutionStageSummary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionStageSummary) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ExecutionStageSummary) GetKind() KindType {
	if x != nil {
		return x.Kind
	}
	return KindType_UNKNOWN_KIND
}

func (x *ExecutionStageSummary) GetInputSource() []*ExecutionStageSummary_StageSource {
	if x != nil {
		return x.InputSource
	}
	return nil
}

func (x *ExecutionStageSummary) GetOutputSource() []*ExecutionStageSummary_StageSource {
	if x != nil {
		return x.OutputSource
	}
	return nil
}

func (x *ExecutionStageSummary) GetPrerequisiteStage() []string {
	if x != nil {
		return x.PrerequisiteStage
	}
	return nil
}

func (x *ExecutionStageSummary) GetComponentTransform() []*ExecutionStageSummary_ComponentTransform {
	if x != nil {
		return x.ComponentTransform
	}
	return nil
}

func (x *ExecutionStageSummary) GetComponentSource() []*ExecutionStageSummary_ComponentSource {
	if x != nil {
		return x.ComponentSource
	}
	return nil
}

// Data provided with a pipeline or transform to provide descriptive info.
type DisplayData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key identifying the display data.
	// This is intended to be used as a label for the display data
	// when viewed in a dax monitoring system.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The namespace for the key. This is usually a class name or programming
	// language namespace (i.e. python module) which defines the display data.
	// This allows a dax monitoring system to specially handle the data
	// and perform custom rendering.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Various value types which can be used for display data.  Only one will be
	// set.
	//
	// Types that are assignable to Value:
	//
	//	*DisplayData_StrValue
	//	*DisplayData_Int64Value
	//	*DisplayData_FloatValue
	//	*DisplayData_JavaClassValue
	//	*DisplayData_TimestampValue
	//	*DisplayData_DurationValue
	//	*DisplayData_BoolValue
	Value isDisplayData_Value `protobuf_oneof:"Value"`
	// A possible additional shorter value to display.
	// For example a java_class_name_value of com.mypackage.MyDoFn
	// will be stored with MyDoFn as the short_str_value and
	// com.mypackage.MyDoFn as the java_class_name value.
	// short_str_value can be displayed and java_class_name_value
	// will be displayed as a tooltip.
	ShortStrValue string `protobuf:"bytes,11,opt,name=short_str_value,json=shortStrValue,proto3" json:"short_str_value,omitempty"`
	// An optional full URL.
	Url string `protobuf:"bytes,12,opt,name=url,proto3" json:"url,omitempty"`
	// An optional label to display in a dax UI for the element.
	Label string `protobuf:"bytes,13,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *DisplayData) Reset() {
	*x = DisplayData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisplayData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayData) ProtoMessage() {}

func (x *DisplayData) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayData.ProtoReflect.Descriptor instead.
func (*DisplayData) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{13}
}

func (x *DisplayData) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DisplayData) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (m *DisplayData) GetValue() isDisplayData_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *DisplayData) GetStrValue() string {
	if x, ok := x.GetValue().(*DisplayData_StrValue); ok {
		return x.StrValue
	}
	return ""
}

func (x *DisplayData) GetInt64Value() int64 {
	if x, ok := x.GetValue().(*DisplayData_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *DisplayData) GetFloatValue() float32 {
	if x, ok := x.GetValue().(*DisplayData_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *DisplayData) GetJavaClassValue() string {
	if x, ok := x.GetValue().(*DisplayData_JavaClassValue); ok {
		return x.JavaClassValue
	}
	return ""
}

func (x *DisplayData) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetValue().(*DisplayData_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *DisplayData) GetDurationValue() *durationpb.Duration {
	if x, ok := x.GetValue().(*DisplayData_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

func (x *DisplayData) GetBoolValue() bool {
	if x, ok := x.GetValue().(*DisplayData_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *DisplayData) GetShortStrValue() string {
	if x != nil {
		return x.ShortStrValue
	}
	return ""
}

func (x *DisplayData) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *DisplayData) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type isDisplayData_Value interface {
	isDisplayData_Value()
}

type DisplayData_StrValue struct {
	// Contains value if the data is of string type.
	StrValue string `protobuf:"bytes,4,opt,name=str_value,json=strValue,proto3,oneof"`
}

type DisplayData_Int64Value struct {
	// Contains value if the data is of int64 type.
	Int64Value int64 `protobuf:"varint,5,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type DisplayData_FloatValue struct {
	// Contains value if the data is of float type.
	FloatValue float32 `protobuf:"fixed32,6,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type DisplayData_JavaClassValue struct {
	// Contains value if the data is of java class type.
	JavaClassValue string `protobuf:"bytes,7,opt,name=java_class_value,json=javaClassValue,proto3,oneof"`
}

type DisplayData_TimestampValue struct {
	// Contains value if the data is of timestamp type.
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type DisplayData_DurationValue struct {
	// Contains value if the data is of duration type.
	DurationValue *durationpb.Duration `protobuf:"bytes,9,opt,name=duration_value,json=durationValue,proto3,oneof"`
}

type DisplayData_BoolValue struct {
	// Contains value if the data is of a boolean type.
	BoolValue bool `protobuf:"varint,10,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

func (*DisplayData_StrValue) isDisplayData_Value() {}

func (*DisplayData_Int64Value) isDisplayData_Value() {}

func (*DisplayData_FloatValue) isDisplayData_Value() {}

func (*DisplayData_JavaClassValue) isDisplayData_Value() {}

func (*DisplayData_TimestampValue) isDisplayData_Value() {}

func (*DisplayData_DurationValue) isDisplayData_Value() {}

func (*DisplayData_BoolValue) isDisplayData_Value() {}

// Defines a particular step within a Cloud Dataflow job.
//
// A job consists of multiple steps, each of which performs some
// specific operation as part of the overall job.  Data is typically
// passed from one step to another as part of the job.
//
// Here's an example of a sequence of steps which together implement a
// Map-Reduce job:
//
//   - Read a collection of data from some source, parsing the
//     collection's elements.
//
//   - Validate the elements.
//
//   - Apply a user-defined function to map each element to some value
//     and extract an element-specific key value.
//
//   - Group elements with the same key into a single element with
//     that key, transforming a multiply-keyed collection into a
//     uniquely-keyed collection.
//
//   - Write the elements out to some data sink.
//
// Note that the Cloud Dataflow service may be used to run many different
// types of jobs, not just Map-Reduce.
type Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of step in the Cloud Dataflow job.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The name that identifies the step. This must be unique for each
	// step with respect to all other steps in the Cloud Dataflow job.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Named properties associated with the step. Each kind of
	// predefined step has its own required set of properties.
	// Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
	Properties *structpb.Struct `protobuf:"bytes,3,opt,name=properties,proto3" json:"properties,omitempty"`
}

func (x *Step) Reset() {
	*x = Step{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Step) ProtoMessage() {}

func (x *Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Step.ProtoReflect.Descriptor instead.
func (*Step) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{14}
}

func (x *Step) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Step) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Step) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Additional information about how a Cloud Dataflow job will be executed that
// isn't contained in the submitted job.
type JobExecutionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A mapping from each stage to the information about that stage.
	Stages map[string]*JobExecutionStageInfo `protobuf:"bytes,1,rep,name=stages,proto3" json:"stages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *JobExecutionInfo) Reset() {
	*x = JobExecutionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobExecutionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobExecutionInfo) ProtoMessage() {}

func (x *JobExecutionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobExecutionInfo.ProtoReflect.Descriptor instead.
func (*JobExecutionInfo) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{15}
}

func (x *JobExecutionInfo) GetStages() map[string]*JobExecutionStageInfo {
	if x != nil {
		return x.Stages
	}
	return nil
}

// Contains information about how a particular
// [google.dataflow.v1beta3.Step][google.dataflow.v1beta3.Step] will be executed.
type JobExecutionStageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The steps associated with the execution stage.
	// Note that stages may have several steps, and that a given step
	// might be run by more than one stage.
	StepName []string `protobuf:"bytes,1,rep,name=step_name,json=stepName,proto3" json:"step_name,omitempty"`
}

func (x *JobExecutionStageInfo) Reset() {
	*x = JobExecutionStageInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobExecutionStageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobExecutionStageInfo) ProtoMessage() {}

func (x *JobExecutionStageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobExecutionStageInfo.ProtoReflect.Descriptor instead.
func (*JobExecutionStageInfo) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{16}
}

func (x *JobExecutionStageInfo) GetStepName() []string {
	if x != nil {
		return x.StepName
	}
	return nil
}

// Request to create a Cloud Dataflow job.
type CreateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to create.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	// The level of information requested in response.
	View JobView `protobuf:"varint,3,opt,name=view,proto3,enum=google.dataflow.v1beta3.JobView" json:"view,omitempty"`
	// Deprecated. This field is now in the Job message.
	ReplaceJobId string `protobuf:"bytes,4,opt,name=replace_job_id,json=replaceJobId,proto3" json:"replace_job_id,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains this job.
	Location string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *CreateJobRequest) Reset() {
	*x = CreateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobRequest) ProtoMessage() {}

func (x *CreateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobRequest.ProtoReflect.Descriptor instead.
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{17}
}

func (x *CreateJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateJobRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *CreateJobRequest) GetView() JobView {
	if x != nil {
		return x.View
	}
	return JobView_JOB_VIEW_UNKNOWN
}

func (x *CreateJobRequest) GetReplaceJobId() string {
	if x != nil {
		return x.ReplaceJobId
	}
	return ""
}

func (x *CreateJobRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Request to get the state of a Cloud Dataflow job.
type GetJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The level of information requested in response.
	View JobView `protobuf:"varint,3,opt,name=view,proto3,enum=google.dataflow.v1beta3.JobView" json:"view,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains this job.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GetJobRequest) Reset() {
	*x = GetJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobRequest) ProtoMessage() {}

func (x *GetJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobRequest.ProtoReflect.Descriptor instead.
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{18}
}

func (x *GetJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *GetJobRequest) GetView() JobView {
	if x != nil {
		return x.View
	}
	return JobView_JOB_VIEW_UNKNOWN
}

func (x *GetJobRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Request to update a Cloud Dataflow job.
type UpdateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The updated job.
	// Only the job state is updatable; other fields will be ignored.
	Job *Job `protobuf:"bytes,3,opt,name=job,proto3" json:"job,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains this job.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *UpdateJobRequest) Reset() {
	*x = UpdateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateJobRequest) ProtoMessage() {}

func (x *UpdateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{19}
}

func (x *UpdateJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *UpdateJobRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *UpdateJobRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Request to list Cloud Dataflow jobs.
type ListJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of filter to use.
	Filter ListJobsRequest_Filter `protobuf:"varint,5,opt,name=filter,proto3,enum=google.dataflow.v1beta3.ListJobsRequest_Filter" json:"filter,omitempty"`
	// The project which owns the jobs.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. ListJobs always returns summaries now.
	// Use GetJob for other JobViews.
	//
	// Deprecated: Marked as deprecated in google/dataflow/v1beta3/jobs.proto.
	View JobView `protobuf:"varint,2,opt,name=view,proto3,enum=google.dataflow.v1beta3.JobView" json:"view,omitempty"`
	// If there are many jobs, limit response to at most this many.
	// The actual number of jobs returned will be the lesser of max_responses
	// and an unspecified server-defined limit.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Set this to the 'next_page_token' field of a previous response
	// to request additional results in a long list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains this job.
	Location string `protobuf:"bytes,17,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *ListJobsRequest) Reset() {
	*x = ListJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsRequest) ProtoMessage() {}

func (x *ListJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsRequest.ProtoReflect.Descriptor instead.
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{20}
}

func (x *ListJobsRequest) GetFilter() ListJobsRequest_Filter {
	if x != nil {
		return x.Filter
	}
	return ListJobsRequest_UNKNOWN
}

func (x *ListJobsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/dataflow/v1beta3/jobs.proto.
func (x *ListJobsRequest) GetView() JobView {
	if x != nil {
		return x.View
	}
	return JobView_JOB_VIEW_UNKNOWN
}

func (x *ListJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Indicates which [regional endpoint]
// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) failed
// to respond to a request for data.
type FailedLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// failed to respond.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FailedLocation) Reset() {
	*x = FailedLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailedLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailedLocation) ProtoMessage() {}

func (x *FailedLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailedLocation.ProtoReflect.Descriptor instead.
func (*FailedLocation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{21}
}

func (x *FailedLocation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response to a request to list Cloud Dataflow jobs in a project. This might
// be a partial response, depending on the page size in the ListJobsRequest.
// However, if the project does not have any jobs, an instance of
// ListJobsResponse is not returned and the requests's response
// body is empty {}.
type ListJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A subset of the requested job information.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Set if there may be more results than fit in this response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Zero or more messages describing the [regional endpoints]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// failed to respond.
	FailedLocation []*FailedLocation `protobuf:"bytes,3,rep,name=failed_location,json=failedLocation,proto3" json:"failed_location,omitempty"`
}

func (x *ListJobsResponse) Reset() {
	*x = ListJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsResponse) ProtoMessage() {}

func (x *ListJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsResponse.ProtoReflect.Descriptor instead.
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{22}
}

func (x *ListJobsResponse) GetJobs() []*Job {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *ListJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListJobsResponse) GetFailedLocation() []*FailedLocation {
	if x != nil {
		return x.FailedLocation
	}
	return nil
}

// Request to create a snapshot of a job.
type SnapshotJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project which owns the job to be snapshotted.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to be snapshotted.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// TTL for the snapshot.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// The location that contains this job.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// If true, perform snapshots for sources which support this.
	SnapshotSources bool `protobuf:"varint,5,opt,name=snapshot_sources,json=snapshotSources,proto3" json:"snapshot_sources,omitempty"`
	// User specified description of the snapshot. Maybe empty.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *SnapshotJobRequest) Reset() {
	*x = SnapshotJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotJobRequest) ProtoMessage() {}

func (x *SnapshotJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotJobRequest.ProtoReflect.Descriptor instead.
func (*SnapshotJobRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{23}
}

func (x *SnapshotJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SnapshotJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *SnapshotJobRequest) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *SnapshotJobRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *SnapshotJobRequest) GetSnapshotSources() bool {
	if x != nil {
		return x.SnapshotSources
	}
	return false
}

func (x *SnapshotJobRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Request to check is active jobs exists for a project
type CheckActiveJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project which owns the jobs.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *CheckActiveJobsRequest) Reset() {
	*x = CheckActiveJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckActiveJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckActiveJobsRequest) ProtoMessage() {}

func (x *CheckActiveJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckActiveJobsRequest.ProtoReflect.Descriptor instead.
func (*CheckActiveJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{24}
}

func (x *CheckActiveJobsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Response for CheckActiveJobsRequest.
type CheckActiveJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If True, active jobs exists for project. False otherwise.
	ActiveJobsExist bool `protobuf:"varint,1,opt,name=active_jobs_exist,json=activeJobsExist,proto3" json:"active_jobs_exist,omitempty"`
}

func (x *CheckActiveJobsResponse) Reset() {
	*x = CheckActiveJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckActiveJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckActiveJobsResponse) ProtoMessage() {}

func (x *CheckActiveJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckActiveJobsResponse.ProtoReflect.Descriptor instead.
func (*CheckActiveJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{25}
}

func (x *CheckActiveJobsResponse) GetActiveJobsExist() bool {
	if x != nil {
		return x.ActiveJobsExist
	}
	return false
}

// Description of an input or output of an execution stage.
type ExecutionStageSummary_StageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-readable name for this source; may be user or system generated.
	UserName string `protobuf:"bytes,1,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Dataflow service generated name for this source.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// User name for the original user transform or collection with which this
	// source is most closely associated.
	OriginalTransformOrCollection string `protobuf:"bytes,3,opt,name=original_transform_or_collection,json=originalTransformOrCollection,proto3" json:"original_transform_or_collection,omitempty"`
	// Size of the source, if measurable.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *ExecutionStageSummary_StageSource) Reset() {
	*x = ExecutionStageSummary_StageSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStageSummary_StageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStageSummary_StageSource) ProtoMessage() {}

func (x *ExecutionStageSummary_StageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStageSummary_StageSource.ProtoReflect.Descriptor instead.
func (*ExecutionStageSummary_StageSource) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{12, 0}
}

func (x *ExecutionStageSummary_StageSource) GetUserName() string {
	if x != nil {
		return x.UserName
	}
	return ""
}

func (x *ExecutionStageSummary_StageSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionStageSummary_StageSource) GetOriginalTransformOrCollection() string {
	if x != nil {
		return x.OriginalTransformOrCollection
	}
	return ""
}

func (x *ExecutionStageSummary_StageSource) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

// Description of a transform executed as part of an execution stage.
type ExecutionStageSummary_ComponentTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-readable name for this transform; may be user or system generated.
	UserName string `protobuf:"bytes,1,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Dataflow service generated name for this source.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// User name for the original user transform with which this transform is
	// most closely associated.
	OriginalTransform string `protobuf:"bytes,3,opt,name=original_transform,json=originalTransform,proto3" json:"original_transform,omitempty"`
}

func (x *ExecutionStageSummary_ComponentTransform) Reset() {
	*x = ExecutionStageSummary_ComponentTransform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStageSummary_ComponentTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStageSummary_ComponentTransform) ProtoMessage() {}

func (x *ExecutionStageSummary_ComponentTransform) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStageSummary_ComponentTransform.ProtoReflect.Descriptor instead.
func (*ExecutionStageSummary_ComponentTransform) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{12, 1}
}

func (x *ExecutionStageSummary_ComponentTransform) GetUserName() string {
	if x != nil {
		return x.UserName
	}
	return ""
}

func (x *ExecutionStageSummary_ComponentTransform) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionStageSummary_ComponentTransform) GetOriginalTransform() string {
	if x != nil {
		return x.OriginalTransform
	}
	return ""
}

// Description of an interstitial value between transforms in an execution
// stage.
type ExecutionStageSummary_ComponentSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-readable name for this transform; may be user or system generated.
	UserName string `protobuf:"bytes,1,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Dataflow service generated name for this source.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// User name for the original user transform or collection with which this
	// source is most closely associated.
	OriginalTransformOrCollection string `protobuf:"bytes,3,opt,name=original_transform_or_collection,json=originalTransformOrCollection,proto3" json:"original_transform_or_collection,omitempty"`
}

func (x *ExecutionStageSummary_ComponentSource) Reset() {
	*x = ExecutionStageSummary_ComponentSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStageSummary_ComponentSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStageSummary_ComponentSource) ProtoMessage() {}

func (x *ExecutionStageSummary_ComponentSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_jobs_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStageSummary_ComponentSource.ProtoReflect.Descriptor instead.
func (*ExecutionStageSummary_ComponentSource) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP(), []int{12, 2}
}

func (x *ExecutionStageSummary_ComponentSource) GetUserName() string {
	if x != nil {
		return x.UserName
	}
	return ""
}

func (x *ExecutionStageSummary_ComponentSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionStageSummary_ComponentSource) GetOriginalTransformOrCollection() string {
	if x != nil {
		return x.OriginalTransformOrCollection
	}
	return ""
}

var File_google_dataflow_v1beta3_jobs_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_jobs_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91, 0x0c, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x34, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x33, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73,
	0x74, 0x65, 0x70, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0d,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f,
	0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a,
	0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12,
	0x6c, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a,
	0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x12, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x42,
	0x79, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x6d, 0x70,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x14, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x13, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0b, 0x6a, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x18, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x1a, 0x47, 0x0a, 0x19, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x12, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x4b,
	0x0a, 0x0f, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x32, 0x0a, 0x0d, 0x46,
	0x69, 0x6c, 0x65, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22,
	0x6e, 0x0a, 0x11, 0x42, 0x69, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x4f, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22,
	0x78, 0x0a, 0x11, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x4f, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x73, 0x0a, 0x10, 0x53, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0x98,
	0x02, 0x0a, 0x0a, 0x53, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x73, 0x64, 0x6b,
	0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x53, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x64, 0x6b, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x10, 0x73, 0x64, 0x6b,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x5a, 0x0a,
	0x10, 0x53, 0x64, 0x6b, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x53, 0x54, 0x41, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52,
	0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0xcc, 0x04, 0x0a, 0x0b, 0x4a, 0x6f,
	0x62, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x0b, 0x73, 0x64, 0x6b,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x73, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x52, 0x0a, 0x0f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x0e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x11, 0x62, 0x69,
	0x67, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x42, 0x69, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x49, 0x4f, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x4f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x58,
	0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x4f, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xe8, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x30, 0x0a, 0x14, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x55, 0x0a, 0x15, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x13, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0xb3, 0x02, 0x0a, 0x13, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x1b, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x19, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x68, 0x0a, 0x18, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67,
	0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x16, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x12, 0x47, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0xa0, 0x02, 0x0a, 0x10, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x35,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xed, 0x07, 0x0a,
	0x15, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x5d, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x5f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x70,
	0x72, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x12, 0x72, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x12, 0x69, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a,
	0xa6, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x47, 0x0a, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1d, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4f, 0x72, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73,
	0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x74, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x1b,
	0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x1a, 0x8b,
	0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1d, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x4f, 0x72, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd3, 0x03, 0x0a,
	0x0b, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1c,
	0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x09,
	0x73, 0x74, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21,
	0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6a, 0x61, 0x76, 0x61, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x6a,
	0x61, 0x76, 0x61, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a,
	0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09,
	0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x67, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xcc, 0x01, 0x0a, 0x10,
	0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x4d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x67,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x1a,
	0x69, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x44, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x34, 0x0a, 0x15, 0x4a, 0x6f,
	0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x65, 0x70, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0xd9, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x52,
	0x03, 0x6a, 0x6f, 0x62, 0x12, 0x34, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4a, 0x6f, 0x62, 0x49, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a,
	0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a,
	0x6f, 0x62, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49,
	0x64, 0x12, 0x2e, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f,
	0x62, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x02,
	0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x0a, 0x06, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x54,
	0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x22, 0x24, 0x0a, 0x0e, 0x46, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x50, 0x0a, 0x0f,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe0,
	0x01, 0x0a, 0x12, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x03, 0x74,
	0x74, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x37, 0x0a, 0x16, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x45, 0x0a, 0x17, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x6a, 0x6f, 0x62, 0x73, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x45, 0x78, 0x69, 0x73,
	0x74, 0x2a, 0xae, 0x01, 0x0a, 0x08, 0x4b, 0x69, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10,
	0x0a, 0x0c, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x41, 0x52, 0x5f, 0x44, 0x4f, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10,
	0x01, 0x12, 0x15, 0x0a, 0x11, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x4c, 0x41, 0x54,
	0x54, 0x45, 0x4e, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45,
	0x41, 0x44, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x57, 0x52, 0x49,
	0x54, 0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x54, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x10, 0x07,
	0x12, 0x10, 0x0a, 0x0c, 0x53, 0x48, 0x55, 0x46, 0x46, 0x4c, 0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44,
	0x10, 0x08, 0x2a, 0xc3, 0x02, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a,
	0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x4a, 0x4f, 0x42, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x17,
	0x0a, 0x13, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x16,
	0x0a, 0x12, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x52, 0x41, 0x49,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x44, 0x52, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x08, 0x12, 0x15, 0x0a,
	0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x14,
	0x0a, 0x10, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x45, 0x55,
	0x45, 0x44, 0x10, 0x0b, 0x12, 0x22, 0x0a, 0x1e, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x43, 0x4c, 0x45, 0x41, 0x4e,
	0x49, 0x4e, 0x47, 0x5f, 0x55, 0x50, 0x10, 0x0c, 0x2a, 0x61, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x14, 0x0a, 0x10, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4a, 0x4f, 0x42,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x41, 0x4c, 0x4c, 0x10,
	0x02, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x44, 0x45,
	0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x32, 0x91, 0x0c, 0x0a, 0x0b,
	0x4a, 0x6f, 0x62, 0x73, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0x12, 0xc1, 0x01, 0x0a, 0x09,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a,
	0x6f, 0x62, 0x22, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x3a, 0x03, 0x6a, 0x6f, 0x62, 0x5a,
	0x27, 0x3a, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x20, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x12,
	0xc3, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d, 0x5a, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x62,
	0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4a, 0x6f, 0x62, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x22, 0x7d, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x77, 0x3a, 0x03, 0x6a, 0x6f, 0x62, 0x5a, 0x30, 0x3a, 0x03, 0x6a, 0x6f, 0x62,
	0x1a, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x1a, 0x3e, 0x2f, 0x76, 0x31,
	0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x08,
	0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x5a, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x33,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73,
	0x12, 0x9e, 0x01, 0x0a, 0x12, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x4c,
	0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x76, 0x0a, 0x0f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0xec, 0x01, 0x0a, 0x0b, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x85, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31,
	0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22,
	0x47, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x3a,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x1a, 0xd4, 0x01, 0xca, 0x41, 0x17, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xb6, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x42,
	0xcc, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42,
	0x09, 0x4a, 0x6f, 0x62, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62,
	0x3b, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x20, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_dataflow_v1beta3_jobs_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_jobs_proto_rawDescData = file_google_dataflow_v1beta3_jobs_proto_rawDesc
)

func file_google_dataflow_v1beta3_jobs_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_jobs_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_jobs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_jobs_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_jobs_proto_rawDescData
}

var file_google_dataflow_v1beta3_jobs_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_dataflow_v1beta3_jobs_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_dataflow_v1beta3_jobs_proto_goTypes = []interface{}{
	(KindType)(0),                                    // 0: google.dataflow.v1beta3.KindType
	(JobState)(0),                                    // 1: google.dataflow.v1beta3.JobState
	(JobView)(0),                                     // 2: google.dataflow.v1beta3.JobView
	(SdkVersion_SdkSupportStatus)(0),                 // 3: google.dataflow.v1beta3.SdkVersion.SdkSupportStatus
	(ListJobsRequest_Filter)(0),                      // 4: google.dataflow.v1beta3.ListJobsRequest.Filter
	(*Job)(nil),                                      // 5: google.dataflow.v1beta3.Job
	(*DatastoreIODetails)(nil),                       // 6: google.dataflow.v1beta3.DatastoreIODetails
	(*PubSubIODetails)(nil),                          // 7: google.dataflow.v1beta3.PubSubIODetails
	(*FileIODetails)(nil),                            // 8: google.dataflow.v1beta3.FileIODetails
	(*BigTableIODetails)(nil),                        // 9: google.dataflow.v1beta3.BigTableIODetails
	(*BigQueryIODetails)(nil),                        // 10: google.dataflow.v1beta3.BigQueryIODetails
	(*SpannerIODetails)(nil),                         // 11: google.dataflow.v1beta3.SpannerIODetails
	(*SdkVersion)(nil),                               // 12: google.dataflow.v1beta3.SdkVersion
	(*JobMetadata)(nil),                              // 13: google.dataflow.v1beta3.JobMetadata
	(*ExecutionStageState)(nil),                      // 14: google.dataflow.v1beta3.ExecutionStageState
	(*PipelineDescription)(nil),                      // 15: google.dataflow.v1beta3.PipelineDescription
	(*TransformSummary)(nil),                         // 16: google.dataflow.v1beta3.TransformSummary
	(*ExecutionStageSummary)(nil),                    // 17: google.dataflow.v1beta3.ExecutionStageSummary
	(*DisplayData)(nil),                              // 18: google.dataflow.v1beta3.DisplayData
	(*Step)(nil),                                     // 19: google.dataflow.v1beta3.Step
	(*JobExecutionInfo)(nil),                         // 20: google.dataflow.v1beta3.JobExecutionInfo
	(*JobExecutionStageInfo)(nil),                    // 21: google.dataflow.v1beta3.JobExecutionStageInfo
	(*CreateJobRequest)(nil),                         // 22: google.dataflow.v1beta3.CreateJobRequest
	(*GetJobRequest)(nil),                            // 23: google.dataflow.v1beta3.GetJobRequest
	(*UpdateJobRequest)(nil),                         // 24: google.dataflow.v1beta3.UpdateJobRequest
	(*ListJobsRequest)(nil),                          // 25: google.dataflow.v1beta3.ListJobsRequest
	(*FailedLocation)(nil),                           // 26: google.dataflow.v1beta3.FailedLocation
	(*ListJobsResponse)(nil),                         // 27: google.dataflow.v1beta3.ListJobsResponse
	(*SnapshotJobRequest)(nil),                       // 28: google.dataflow.v1beta3.SnapshotJobRequest
	(*CheckActiveJobsRequest)(nil),                   // 29: google.dataflow.v1beta3.CheckActiveJobsRequest
	(*CheckActiveJobsResponse)(nil),                  // 30: google.dataflow.v1beta3.CheckActiveJobsResponse
	nil,                                              // 31: google.dataflow.v1beta3.Job.TransformNameMappingEntry
	nil,                                              // 32: google.dataflow.v1beta3.Job.LabelsEntry
	(*ExecutionStageSummary_StageSource)(nil),        // 33: google.dataflow.v1beta3.ExecutionStageSummary.StageSource
	(*ExecutionStageSummary_ComponentTransform)(nil), // 34: google.dataflow.v1beta3.ExecutionStageSummary.ComponentTransform
	(*ExecutionStageSummary_ComponentSource)(nil),    // 35: google.dataflow.v1beta3.ExecutionStageSummary.ComponentSource
	nil,                           // 36: google.dataflow.v1beta3.JobExecutionInfo.StagesEntry
	(JobType)(0),                  // 37: google.dataflow.v1beta3.JobType
	(*Environment)(nil),           // 38: google.dataflow.v1beta3.Environment
	(*timestamppb.Timestamp)(nil), // 39: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 40: google.protobuf.Duration
	(*structpb.Struct)(nil),       // 41: google.protobuf.Struct
	(*Snapshot)(nil),              // 42: google.dataflow.v1beta3.Snapshot
}
var file_google_dataflow_v1beta3_jobs_proto_depIdxs = []int32{
	37, // 0: google.dataflow.v1beta3.Job.type:type_name -> google.dataflow.v1beta3.JobType
	38, // 1: google.dataflow.v1beta3.Job.environment:type_name -> google.dataflow.v1beta3.Environment
	19, // 2: google.dataflow.v1beta3.Job.steps:type_name -> google.dataflow.v1beta3.Step
	1,  // 3: google.dataflow.v1beta3.Job.current_state:type_name -> google.dataflow.v1beta3.JobState
	39, // 4: google.dataflow.v1beta3.Job.current_state_time:type_name -> google.protobuf.Timestamp
	1,  // 5: google.dataflow.v1beta3.Job.requested_state:type_name -> google.dataflow.v1beta3.JobState
	20, // 6: google.dataflow.v1beta3.Job.execution_info:type_name -> google.dataflow.v1beta3.JobExecutionInfo
	39, // 7: google.dataflow.v1beta3.Job.create_time:type_name -> google.protobuf.Timestamp
	31, // 8: google.dataflow.v1beta3.Job.transform_name_mapping:type_name -> google.dataflow.v1beta3.Job.TransformNameMappingEntry
	32, // 9: google.dataflow.v1beta3.Job.labels:type_name -> google.dataflow.v1beta3.Job.LabelsEntry
	15, // 10: google.dataflow.v1beta3.Job.pipeline_description:type_name -> google.dataflow.v1beta3.PipelineDescription
	14, // 11: google.dataflow.v1beta3.Job.stage_states:type_name -> google.dataflow.v1beta3.ExecutionStageState
	13, // 12: google.dataflow.v1beta3.Job.job_metadata:type_name -> google.dataflow.v1beta3.JobMetadata
	39, // 13: google.dataflow.v1beta3.Job.start_time:type_name -> google.protobuf.Timestamp
	3,  // 14: google.dataflow.v1beta3.SdkVersion.sdk_support_status:type_name -> google.dataflow.v1beta3.SdkVersion.SdkSupportStatus
	12, // 15: google.dataflow.v1beta3.JobMetadata.sdk_version:type_name -> google.dataflow.v1beta3.SdkVersion
	11, // 16: google.dataflow.v1beta3.JobMetadata.spanner_details:type_name -> google.dataflow.v1beta3.SpannerIODetails
	10, // 17: google.dataflow.v1beta3.JobMetadata.bigquery_details:type_name -> google.dataflow.v1beta3.BigQueryIODetails
	9,  // 18: google.dataflow.v1beta3.JobMetadata.big_table_details:type_name -> google.dataflow.v1beta3.BigTableIODetails
	7,  // 19: google.dataflow.v1beta3.JobMetadata.pubsub_details:type_name -> google.dataflow.v1beta3.PubSubIODetails
	8,  // 20: google.dataflow.v1beta3.JobMetadata.file_details:type_name -> google.dataflow.v1beta3.FileIODetails
	6,  // 21: google.dataflow.v1beta3.JobMetadata.datastore_details:type_name -> google.dataflow.v1beta3.DatastoreIODetails
	1,  // 22: google.dataflow.v1beta3.ExecutionStageState.execution_stage_state:type_name -> google.dataflow.v1beta3.JobState
	39, // 23: google.dataflow.v1beta3.ExecutionStageState.current_state_time:type_name -> google.protobuf.Timestamp
	16, // 24: google.dataflow.v1beta3.PipelineDescription.original_pipeline_transform:type_name -> google.dataflow.v1beta3.TransformSummary
	17, // 25: google.dataflow.v1beta3.PipelineDescription.execution_pipeline_stage:type_name -> google.dataflow.v1beta3.ExecutionStageSummary
	18, // 26: google.dataflow.v1beta3.PipelineDescription.display_data:type_name -> google.dataflow.v1beta3.DisplayData
	0,  // 27: google.dataflow.v1beta3.TransformSummary.kind:type_name -> google.dataflow.v1beta3.KindType
	18, // 28: google.dataflow.v1beta3.TransformSummary.display_data:type_name -> google.dataflow.v1beta3.DisplayData
	0,  // 29: google.dataflow.v1beta3.ExecutionStageSummary.kind:type_name -> google.dataflow.v1beta3.KindType
	33, // 30: google.dataflow.v1beta3.ExecutionStageSummary.input_source:type_name -> google.dataflow.v1beta3.ExecutionStageSummary.StageSource
	33, // 31: google.dataflow.v1beta3.ExecutionStageSummary.output_source:type_name -> google.dataflow.v1beta3.ExecutionStageSummary.StageSource
	34, // 32: google.dataflow.v1beta3.ExecutionStageSummary.component_transform:type_name -> google.dataflow.v1beta3.ExecutionStageSummary.ComponentTransform
	35, // 33: google.dataflow.v1beta3.ExecutionStageSummary.component_source:type_name -> google.dataflow.v1beta3.ExecutionStageSummary.ComponentSource
	39, // 34: google.dataflow.v1beta3.DisplayData.timestamp_value:type_name -> google.protobuf.Timestamp
	40, // 35: google.dataflow.v1beta3.DisplayData.duration_value:type_name -> google.protobuf.Duration
	41, // 36: google.dataflow.v1beta3.Step.properties:type_name -> google.protobuf.Struct
	36, // 37: google.dataflow.v1beta3.JobExecutionInfo.stages:type_name -> google.dataflow.v1beta3.JobExecutionInfo.StagesEntry
	5,  // 38: google.dataflow.v1beta3.CreateJobRequest.job:type_name -> google.dataflow.v1beta3.Job
	2,  // 39: google.dataflow.v1beta3.CreateJobRequest.view:type_name -> google.dataflow.v1beta3.JobView
	2,  // 40: google.dataflow.v1beta3.GetJobRequest.view:type_name -> google.dataflow.v1beta3.JobView
	5,  // 41: google.dataflow.v1beta3.UpdateJobRequest.job:type_name -> google.dataflow.v1beta3.Job
	4,  // 42: google.dataflow.v1beta3.ListJobsRequest.filter:type_name -> google.dataflow.v1beta3.ListJobsRequest.Filter
	2,  // 43: google.dataflow.v1beta3.ListJobsRequest.view:type_name -> google.dataflow.v1beta3.JobView
	5,  // 44: google.dataflow.v1beta3.ListJobsResponse.jobs:type_name -> google.dataflow.v1beta3.Job
	26, // 45: google.dataflow.v1beta3.ListJobsResponse.failed_location:type_name -> google.dataflow.v1beta3.FailedLocation
	40, // 46: google.dataflow.v1beta3.SnapshotJobRequest.ttl:type_name -> google.protobuf.Duration
	21, // 47: google.dataflow.v1beta3.JobExecutionInfo.StagesEntry.value:type_name -> google.dataflow.v1beta3.JobExecutionStageInfo
	22, // 48: google.dataflow.v1beta3.JobsV1Beta3.CreateJob:input_type -> google.dataflow.v1beta3.CreateJobRequest
	23, // 49: google.dataflow.v1beta3.JobsV1Beta3.GetJob:input_type -> google.dataflow.v1beta3.GetJobRequest
	24, // 50: google.dataflow.v1beta3.JobsV1Beta3.UpdateJob:input_type -> google.dataflow.v1beta3.UpdateJobRequest
	25, // 51: google.dataflow.v1beta3.JobsV1Beta3.ListJobs:input_type -> google.dataflow.v1beta3.ListJobsRequest
	25, // 52: google.dataflow.v1beta3.JobsV1Beta3.AggregatedListJobs:input_type -> google.dataflow.v1beta3.ListJobsRequest
	29, // 53: google.dataflow.v1beta3.JobsV1Beta3.CheckActiveJobs:input_type -> google.dataflow.v1beta3.CheckActiveJobsRequest
	28, // 54: google.dataflow.v1beta3.JobsV1Beta3.SnapshotJob:input_type -> google.dataflow.v1beta3.SnapshotJobRequest
	5,  // 55: google.dataflow.v1beta3.JobsV1Beta3.CreateJob:output_type -> google.dataflow.v1beta3.Job
	5,  // 56: google.dataflow.v1beta3.JobsV1Beta3.GetJob:output_type -> google.dataflow.v1beta3.Job
	5,  // 57: google.dataflow.v1beta3.JobsV1Beta3.UpdateJob:output_type -> google.dataflow.v1beta3.Job
	27, // 58: google.dataflow.v1beta3.JobsV1Beta3.ListJobs:output_type -> google.dataflow.v1beta3.ListJobsResponse
	27, // 59: google.dataflow.v1beta3.JobsV1Beta3.AggregatedListJobs:output_type -> google.dataflow.v1beta3.ListJobsResponse
	30, // 60: google.dataflow.v1beta3.JobsV1Beta3.CheckActiveJobs:output_type -> google.dataflow.v1beta3.CheckActiveJobsResponse
	42, // 61: google.dataflow.v1beta3.JobsV1Beta3.SnapshotJob:output_type -> google.dataflow.v1beta3.Snapshot
	55, // [55:62] is the sub-list for method output_type
	48, // [48:55] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_jobs_proto_init() }
func file_google_dataflow_v1beta3_jobs_proto_init() {
	if File_google_dataflow_v1beta3_jobs_proto != nil {
		return
	}
	file_google_dataflow_v1beta3_environment_proto_init()
	file_google_dataflow_v1beta3_snapshots_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatastoreIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigTableIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpannerIODetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SdkVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStageState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStageSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisplayData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Step); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobExecutionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobExecutionStageInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailedLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckActiveJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckActiveJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStageSummary_StageSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStageSummary_ComponentTransform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_jobs_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStageSummary_ComponentSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_dataflow_v1beta3_jobs_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*DisplayData_StrValue)(nil),
		(*DisplayData_Int64Value)(nil),
		(*DisplayData_FloatValue)(nil),
		(*DisplayData_JavaClassValue)(nil),
		(*DisplayData_TimestampValue)(nil),
		(*DisplayData_DurationValue)(nil),
		(*DisplayData_BoolValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_jobs_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_dataflow_v1beta3_jobs_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_jobs_proto_depIdxs,
		EnumInfos:         file_google_dataflow_v1beta3_jobs_proto_enumTypes,
		MessageInfos:      file_google_dataflow_v1beta3_jobs_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_jobs_proto = out.File
	file_google_dataflow_v1beta3_jobs_proto_rawDesc = nil
	file_google_dataflow_v1beta3_jobs_proto_goTypes = nil
	file_google_dataflow_v1beta3_jobs_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobsV1Beta3Client is the client API for JobsV1Beta3 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobsV1Beta3Client interface {
	// Creates a Cloud Dataflow job.
	//
	// To create a job, we recommend using `projects.locations.jobs.create` with a
	// [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.create` is not recommended, as your job will always start
	// in `us-central1`.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Gets the state of the specified Cloud Dataflow job.
	//
	// To get the state of a job, we recommend using `projects.locations.jobs.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.get` is not recommended, as you can only get the state of
	// jobs that are running in `us-central1`.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates the state of an existing Cloud Dataflow job.
	//
	// To update the state of an existing job, we recommend using
	// `projects.locations.jobs.update` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.update` is not recommended, as you can only update the state
	// of jobs that are running in `us-central1`.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// List the jobs of a project.
	//
	// To list the jobs of a project in a region, we recommend using
	// `projects.locations.jobs.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
	// list the all jobs across all regions, use `projects.jobs.aggregated`. Using
	// `projects.jobs.list` is not recommended, as you can only get the list of
	// jobs that are running in `us-central1`.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// List the jobs of a project across all regions.
	AggregatedListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Check for existence of active jobs in the given project across all regions.
	CheckActiveJobs(ctx context.Context, in *CheckActiveJobsRequest, opts ...grpc.CallOption) (*CheckActiveJobsResponse, error)
	// Snapshot the state of a streaming job.
	SnapshotJob(ctx context.Context, in *SnapshotJobRequest, opts ...grpc.CallOption) (*Snapshot, error)
}

type jobsV1Beta3Client struct {
	cc grpc.ClientConnInterface
}

func NewJobsV1Beta3Client(cc grpc.ClientConnInterface) JobsV1Beta3Client {
	return &jobsV1Beta3Client{cc}
}

func (c *jobsV1Beta3Client) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) AggregatedListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/AggregatedListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) CheckActiveJobs(ctx context.Context, in *CheckActiveJobsRequest, opts ...grpc.CallOption) (*CheckActiveJobsResponse, error) {
	out := new(CheckActiveJobsResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/CheckActiveJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) SnapshotJob(ctx context.Context, in *SnapshotJobRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.JobsV1Beta3/SnapshotJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobsV1Beta3Server is the server API for JobsV1Beta3 service.
type JobsV1Beta3Server interface {
	// Creates a Cloud Dataflow job.
	//
	// To create a job, we recommend using `projects.locations.jobs.create` with a
	// [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.create` is not recommended, as your job will always start
	// in `us-central1`.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Gets the state of the specified Cloud Dataflow job.
	//
	// To get the state of a job, we recommend using `projects.locations.jobs.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.get` is not recommended, as you can only get the state of
	// jobs that are running in `us-central1`.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates the state of an existing Cloud Dataflow job.
	//
	// To update the state of an existing job, we recommend using
	// `projects.locations.jobs.update` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.update` is not recommended, as you can only update the state
	// of jobs that are running in `us-central1`.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// List the jobs of a project.
	//
	// To list the jobs of a project in a region, we recommend using
	// `projects.locations.jobs.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
	// list the all jobs across all regions, use `projects.jobs.aggregated`. Using
	// `projects.jobs.list` is not recommended, as you can only get the list of
	// jobs that are running in `us-central1`.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// List the jobs of a project across all regions.
	AggregatedListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Check for existence of active jobs in the given project across all regions.
	CheckActiveJobs(context.Context, *CheckActiveJobsRequest) (*CheckActiveJobsResponse, error)
	// Snapshot the state of a streaming job.
	SnapshotJob(context.Context, *SnapshotJobRequest) (*Snapshot, error)
}

// UnimplementedJobsV1Beta3Server can be embedded to have forward compatible implementations.
type UnimplementedJobsV1Beta3Server struct {
}

func (*UnimplementedJobsV1Beta3Server) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (*UnimplementedJobsV1Beta3Server) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (*UnimplementedJobsV1Beta3Server) UpdateJob(context.Context, *UpdateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (*UnimplementedJobsV1Beta3Server) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (*UnimplementedJobsV1Beta3Server) AggregatedListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedListJobs not implemented")
}
func (*UnimplementedJobsV1Beta3Server) CheckActiveJobs(context.Context, *CheckActiveJobsRequest) (*CheckActiveJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckActiveJobs not implemented")
}
func (*UnimplementedJobsV1Beta3Server) SnapshotJob(context.Context, *SnapshotJobRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SnapshotJob not implemented")
}

func RegisterJobsV1Beta3Server(s *grpc.Server, srv JobsV1Beta3Server) {
	s.RegisterService(&_JobsV1Beta3_serviceDesc, srv)
}

func _JobsV1Beta3_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_AggregatedListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).AggregatedListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/AggregatedListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).AggregatedListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_CheckActiveJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckActiveJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).CheckActiveJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/CheckActiveJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).CheckActiveJobs(ctx, req.(*CheckActiveJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_SnapshotJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).SnapshotJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.JobsV1Beta3/SnapshotJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).SnapshotJob(ctx, req.(*SnapshotJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobsV1Beta3_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.JobsV1Beta3",
	HandlerType: (*JobsV1Beta3Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobsV1Beta3_CreateJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobsV1Beta3_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobsV1Beta3_UpdateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobsV1Beta3_ListJobs_Handler,
		},
		{
			MethodName: "AggregatedListJobs",
			Handler:    _JobsV1Beta3_AggregatedListJobs_Handler,
		},
		{
			MethodName: "CheckActiveJobs",
			Handler:    _JobsV1Beta3_CheckActiveJobs_Handler,
		},
		{
			MethodName: "SnapshotJob",
			Handler:    _JobsV1Beta3_SnapshotJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/jobs.proto",
}
