// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Registers a user with an app client and requests a user name, password, and
// user attributes in the user pool.
//
// Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies
// in requests for this API operation. For this operation, you can't use IAM
// credentials to authorize requests, and you can't grant IAM permissions in
// policies. For more information about authorization models in Amazon Cognito, see
// [Using the Amazon Cognito user pools API and user pool endpoints].
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before you
// can send SMS messages to US phone numbers. If you use SMS text messages in
// Amazon Cognito, you must register a phone number with [Amazon Pinpoint]. Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts, or
// sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Services service, Amazon Simple Notification Service might place your
// account in the SMS sandbox. In [sandbox mode], you can send messages only to verified phone
// numbers. After you test your app while in the sandbox environment, you can move
// out of the sandbox and into production. For more information, see [SMS message settings for Amazon Cognito user pools]in the Amazon
// Cognito Developer Guide.
//
// You might receive a LimitExceeded exception in response to this request if you
// have exceeded a rate quota for email or SMS messages, and if your user pool
// automatically verifies email addresses or phone numbers. When you get this
// exception in the response, the user is successfully created and is in an
// UNCONFIRMED state.
//
// [SMS message settings for Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [sandbox mode]: https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html
// [Amazon Pinpoint]: https://console.aws.amazon.com/pinpoint/home/
func (c *Client) SignUp(ctx context.Context, params *SignUpInput, optFns ...func(*Options)) (*SignUpOutput, error) {
	if params == nil {
		params = &SignUpInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SignUp", params, optFns, c.addOperationSignUpMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SignUpOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the request to register a user.
type SignUpInput struct {

	// The ID of the app client where the user wants to sign up.
	//
	// This member is required.
	ClientId *string

	// The username of the user that you want to sign up. The value of this parameter
	// is typically a username, but can be any alias attribute in your user pool.
	//
	// This member is required.
	Username *string

	// Information that supports analytics outcomes with Amazon Pinpoint, including
	// the user's endpoint ID. The endpoint ID is a destination for Amazon Pinpoint
	// push notifications, for example a device identifier, email address, or phone
	// number.
	AnalyticsMetadata *types.AnalyticsMetadataType

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool
	// triggers. When you use the SignUp API action, Amazon Cognito invokes any
	// functions that are assigned to the following triggers: pre sign-up, custom
	// message, and post confirmation. When Amazon Cognito invokes any of these
	// functions, it passes a JSON payload, which the function receives as input. This
	// payload contains a clientMetadata attribute, which provides the data that you
	// assigned to the ClientMetadata parameter in your SignUp request. In your
	// function code in Lambda, you can process the clientMetadata value to enhance
	// your workflow for your specific needs.
	//
	// For more information, see [Using Lambda triggers] in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, note that Amazon Cognito won't do
	// the following:
	//
	//   - Store the ClientMetadata value. This data is available only to Lambda
	//   triggers that are assigned to a user pool to support custom workflows. If your
	//   user pool configuration doesn't include triggers, the ClientMetadata parameter
	//   serves no purpose.
	//
	//   - Validate the ClientMetadata value.
	//
	//   - Encrypt the ClientMetadata value. Don't send sensitive information in this
	//   parameter.
	//
	// [Using Lambda triggers]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
	ClientMetadata map[string]string

	// The user's proposed password. The password must comply with the [password requirements] of your user
	// pool.
	//
	// Users can sign up without a password when your user pool supports passwordless
	// sign-in with email or SMS OTPs. To create a user with no password, omit this
	// parameter or submit a blank value. You can only create a passwordless user when
	// passwordless sign-in is available.
	//
	// [password requirements]: https://docs.aws.amazon.com/cognito/latest/developerguide/managing-users-passwords.html
	Password *string

	// A keyed-hash message authentication code (HMAC) calculated using the secret key
	// of a user pool client and username plus the client ID in the message. For more
	// information about SecretHash , see [Computing secret hash values].
	//
	// [Computing secret hash values]: https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash
	SecretHash *string

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, include a custom: prefix in the attribute name, for
	// example custom:department .
	UserAttributes []types.AttributeType

	// Contextual data about your user session like the device fingerprint, IP
	// address, or location. Amazon Cognito threat protection evaluates the risk of an
	// authentication event based on the context that your app generates and passes to
	// Amazon Cognito when it makes API requests.
	//
	// For more information, see [Collecting data for threat protection in applications].
	//
	// [Collecting data for threat protection in applications]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-viewing-threat-protection-app.html
	UserContextData *types.UserContextDataType

	// Temporary user attributes that contribute to the outcomes of your pre sign-up
	// Lambda trigger. This set of key-value pairs are for custom validation of
	// information that you collect from your users but don't need to retain.
	//
	// Your Lambda function can analyze this additional data and act on it. Your
	// function can automatically confirm and verify select users or perform external
	// API operations like logging user attributes and validation data to Amazon
	// CloudWatch Logs.
	//
	// For more information about the pre sign-up Lambda trigger, see [Pre sign-up Lambda trigger].
	//
	// [Pre sign-up Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
	ValidationData []types.AttributeType

	noSmithyDocumentSerde
}

// The response from the server for a registration request.
type SignUpOutput struct {

	// Indicates whether the user was automatically confirmed. You can auto-confirm
	// users with a [pre sign-up Lambda trigger].
	//
	// [pre sign-up Lambda trigger]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
	//
	// This member is required.
	UserConfirmed bool

	// The unique identifier of the new user, for example
	// a1b2c3d4-5678-90ab-cdef-EXAMPLE11111 .
	//
	// This member is required.
	UserSub *string

	// In user pools that automatically verify and confirm new users, Amazon Cognito
	// sends users a message with a code or link that confirms ownership of the phone
	// number or email address that they entered. The CodeDeliveryDetails object is
	// information about the delivery destination for that link or code.
	CodeDeliveryDetails *types.CodeDeliveryDetailsType

	// A session Id that you can pass to ConfirmSignUp when you want to immediately
	// sign in your user with the USER_AUTH flow after they complete sign-up.
	Session *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSignUpMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpSignUp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpSignUp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SignUp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSignUpValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSignUp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSignUp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SignUp",
	}
}
