// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexruntimev2

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteSession = "DeleteSession"

// DeleteSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSession for more information on using the DeleteSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSessionRequest method.
//    req, resp := client.DeleteSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/DeleteSession
func (c *LexRuntimeV2) DeleteSessionRequest(input *DeleteSessionInput) (req *request.Request, output *DeleteSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteSession,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &DeleteSessionInput{}
	}

	output = &DeleteSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSession API operation for Amazon Lex Runtime V2.
//
// Removes session information for a specified bot, alias, and user ID.
//
// You can use this operation to restart a conversation with a bot. When you
// remove a session, the entire history of the session is removed so that you
// can start again.
//
// You don't need to delete a session. Sessions have a time limit and will expire.
// Set the session time limit when you create the bot. The default is 5 minutes,
// but you can specify anything between 1 minute and 24 hours.
//
// If you specify a bot or alias ID that doesn't exist, you receive a BadRequestException.
//
// If the locale doesn't exist in the bot, or if the locale hasn't been enables
// for the alias, you receive a BadRequestException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation DeleteSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/DeleteSession
func (c *LexRuntimeV2) DeleteSession(input *DeleteSessionInput) (*DeleteSessionOutput, error) {
	req, out := c.DeleteSessionRequest(input)
	return out, req.Send()
}

// DeleteSessionWithContext is the same as DeleteSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) DeleteSessionWithContext(ctx aws.Context, input *DeleteSessionInput, opts ...request.Option) (*DeleteSessionOutput, error) {
	req, out := c.DeleteSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSession = "GetSession"

// GetSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSession for more information on using the GetSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSessionRequest method.
//    req, resp := client.GetSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/GetSession
func (c *LexRuntimeV2) GetSessionRequest(input *GetSessionInput) (req *request.Request, output *GetSessionOutput) {
	op := &request.Operation{
		Name:       opGetSession,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &GetSessionInput{}
	}

	output = &GetSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSession API operation for Amazon Lex Runtime V2.
//
// Returns session information for a specified bot, alias, and user.
//
// For example, you can use this operation to retrieve session information for
// a user that has left a long-running session in use.
//
// If the bot, alias, or session identifier doesn't exist, Amazon Lex V2 returns
// a BadRequestException. If the locale doesn't exist or is not enabled for
// the alias, you receive a BadRequestException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation GetSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/GetSession
func (c *LexRuntimeV2) GetSession(input *GetSessionInput) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	return out, req.Send()
}

// GetSessionWithContext is the same as GetSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) GetSessionWithContext(ctx aws.Context, input *GetSessionInput, opts ...request.Option) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSession = "PutSession"

// PutSessionRequest generates a "aws/request.Request" representing the
// client's request for the PutSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSession for more information on using the PutSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSessionRequest method.
//    req, resp := client.PutSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/PutSession
func (c *LexRuntimeV2) PutSessionRequest(input *PutSessionInput) (req *request.Request, output *PutSessionOutput) {
	op := &request.Operation{
		Name:       opPutSession,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &PutSessionInput{}
	}

	output = &PutSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSession API operation for Amazon Lex Runtime V2.
//
// Creates a new session or modifies an existing session with an Amazon Lex
// V2 bot. Use this operation to enable your application to set the state of
// the bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation PutSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * DependencyFailedException
//
//   * BadGatewayException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/PutSession
func (c *LexRuntimeV2) PutSession(input *PutSessionInput) (*PutSessionOutput, error) {
	req, out := c.PutSessionRequest(input)
	return out, req.Send()
}

// PutSessionWithContext is the same as PutSession with the addition of
// the ability to pass a context and additional request options.
//
// See PutSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) PutSessionWithContext(ctx aws.Context, input *PutSessionInput, opts ...request.Option) (*PutSessionOutput, error) {
	req, out := c.PutSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecognizeText = "RecognizeText"

// RecognizeTextRequest generates a "aws/request.Request" representing the
// client's request for the RecognizeText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecognizeText for more information on using the RecognizeText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RecognizeTextRequest method.
//    req, resp := client.RecognizeTextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/RecognizeText
func (c *LexRuntimeV2) RecognizeTextRequest(input *RecognizeTextInput) (req *request.Request, output *RecognizeTextOutput) {
	op := &request.Operation{
		Name:       opRecognizeText,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/text",
	}

	if input == nil {
		input = &RecognizeTextInput{}
	}

	output = &RecognizeTextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RecognizeText API operation for Amazon Lex Runtime V2.
//
// Sends user input to Amazon Lex V2. Client applications use this API to send
// requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user
// input using the machine learning model that it build for the bot.
//
// In response, Amazon Lex V2 returns the next message to convey to the user
// and an optional response card to display.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation RecognizeText for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * DependencyFailedException
//
//   * BadGatewayException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/RecognizeText
func (c *LexRuntimeV2) RecognizeText(input *RecognizeTextInput) (*RecognizeTextOutput, error) {
	req, out := c.RecognizeTextRequest(input)
	return out, req.Send()
}

// RecognizeTextWithContext is the same as RecognizeText with the addition of
// the ability to pass a context and additional request options.
//
// See RecognizeText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) RecognizeTextWithContext(ctx aws.Context, input *RecognizeTextInput, opts ...request.Option) (*RecognizeTextOutput, error) {
	req, out := c.RecognizeTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecognizeUtterance = "RecognizeUtterance"

// RecognizeUtteranceRequest generates a "aws/request.Request" representing the
// client's request for the RecognizeUtterance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecognizeUtterance for more information on using the RecognizeUtterance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RecognizeUtteranceRequest method.
//    req, resp := client.RecognizeUtteranceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/RecognizeUtterance
func (c *LexRuntimeV2) RecognizeUtteranceRequest(input *RecognizeUtteranceInput) (req *request.Request, output *RecognizeUtteranceOutput) {
	op := &request.Operation{
		Name:       opRecognizeUtterance,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/utterance",
	}

	if input == nil {
		input = &RecognizeUtteranceInput{}
	}

	output = &RecognizeUtteranceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// RecognizeUtterance API operation for Amazon Lex Runtime V2.
//
// Sends user input to Amazon Lex V2. You can send text or speech. Clients use
// this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon
// Lex V2 interprets the user input using the machine learning model built for
// the bot.
//
// The following request fields must be compressed with gzip and then base64
// encoded before you send them to Amazon Lex V2.
//
//    * requestAttributes
//
//    * sessionState
//
// The following response fields are compressed using gzip and then base64 encoded
// by Amazon Lex V2. Before you can use these fields, you must decode and decompress
// them.
//
//    * inputTranscript
//
//    * interpretations
//
//    * messages
//
//    * requestAttributes
//
//    * sessionState
//
// The example contains a Java application that compresses and encodes a Java
// object to send to Amazon Lex V2, and a second that decodes and decompresses
// a response from Amazon Lex V2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation RecognizeUtterance for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * DependencyFailedException
//
//   * BadGatewayException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/RecognizeUtterance
func (c *LexRuntimeV2) RecognizeUtterance(input *RecognizeUtteranceInput) (*RecognizeUtteranceOutput, error) {
	req, out := c.RecognizeUtteranceRequest(input)
	return out, req.Send()
}

// RecognizeUtteranceWithContext is the same as RecognizeUtterance with the addition of
// the ability to pass a context and additional request options.
//
// See RecognizeUtterance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) RecognizeUtteranceWithContext(ctx aws.Context, input *RecognizeUtteranceInput, opts ...request.Option) (*RecognizeUtteranceOutput, error) {
	req, out := c.RecognizeUtteranceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConversation = "StartConversation"

// StartConversationRequest generates a "aws/request.Request" representing the
// client's request for the StartConversation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConversation for more information on using the StartConversation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConversationRequest method.
//    req, resp := client.StartConversationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/StartConversation
func (c *LexRuntimeV2) StartConversationRequest(input *StartConversationInput) (req *request.Request, output *StartConversationOutput) {
	op := &request.Operation{
		Name:       opStartConversation,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/conversation",
	}

	if input == nil {
		input = &StartConversationInput{}
	}

	output = &StartConversationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.UnmarshalMeta.PushBack(
		protocol.RequireHTTPMinProtocol{Major: 2}.Handler,
	)

	es := NewStartConversationEventStream()
	output.eventStream = es

	req.Handlers.Sign.PushFront(es.setupInputPipe)
	req.Handlers.UnmarshalError.PushBackNamed(request.NamedHandler{
		Name: "InputPipeCloser",
		Fn: func(r *request.Request) {
			err := es.closeInputPipe()
			if err != nil {
				r.Error = awserr.New(eventstreamapi.InputWriterCloseErrorCode, err.Error(), r.Error)
			}
		},
	})
	req.Handlers.Build.PushBack(request.WithSetRequestHeaders(map[string]string{
		"Content-Type":         "application/vnd.amazon.eventstream",
		"X-Amz-Content-Sha256": "STREAMING-AWS4-HMAC-SHA256-EVENTS",
	}))
	req.Handlers.Build.Swap(restjson.BuildHandler.Name, rest.BuildHandler)
	req.Handlers.Send.Swap(client.LogHTTPRequestHandler.Name, client.LogHTTPRequestHeaderHandler)
	req.Handlers.Unmarshal.PushBack(es.runInputStream)

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// StartConversation API operation for Amazon Lex Runtime V2.
//
// Starts an HTTP/2 bidirectional event stream that enables you to send audio,
// text, or DTMF input in real time. After your application starts a conversation,
// users send input to Amazon Lex V2 as a stream of events. Amazon Lex V2 processes
// the incoming events and responds with streaming text or audio events.
//
// Audio input must be in the following format: audio/lpcm sample-rate=8000
// sample-size-bits=16 channel-count=1; is-big-endian=false.
//
// The StartConversation operation is supported only in the following SDKs:
//
//    * AWS SDK for C++ (https://docs.aws.amazon.com/goto/SdkForCpp/runtime.lex.v2-2020-08-07/StartConversation)
//
//    * AWS SDK for Java V2 (https://docs.aws.amazon.com/goto/SdkForJavaV2/runtime.lex.v2-2020-08-07/StartConversation)
//
//    * AWS SDK for Ruby V3 (https://docs.aws.amazon.com/goto/SdkForRubyV3/runtime.lex.v2-2020-08-07/StartConversation)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Runtime V2's
// API operation StartConversation for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//
//   * ValidationException
//
//   * ThrottlingException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/runtime.lex.v2-2020-08-07/StartConversation
func (c *LexRuntimeV2) StartConversation(input *StartConversationInput) (*StartConversationOutput, error) {
	req, out := c.StartConversationRequest(input)
	return out, req.Send()
}

// StartConversationWithContext is the same as StartConversation with the addition of
// the ability to pass a context and additional request options.
//
// See StartConversation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexRuntimeV2) StartConversationWithContext(ctx aws.Context, input *StartConversationInput, opts ...request.Option) (*StartConversationOutput, error) {
	req, out := c.StartConversationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error

// StartConversationEventStream provides the event stream handling for the StartConversation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewStartConversationEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type StartConversationEventStream struct {

	// Writer is the EventStream writer for the StartConversationRequestEventStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Writer.
	//
	// Must not be nil.
	Writer StartConversationRequestEventStreamWriter

	inputWriter io.WriteCloser

	// Reader is the EventStream reader for the StartConversationResponseEventStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader StartConversationResponseEventStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewStartConversationEventStream initializes an StartConversationEventStream.
// This function should only be used for testing and mocking the StartConversationEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
//
//   es := NewStartConversationEventStream(func(o *StartConversationEventStream{
//       es.Writer = myMockStreamWriter
//       es.Reader = myMockStreamReader
//   })
func NewStartConversationEventStream(opts ...func(*StartConversationEventStream)) *StartConversationEventStream {
	es := &StartConversationEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *StartConversationEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *StartConversationEventStream) waitStreamPartClose() {
	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(interface{ ErrorSet() <-chan struct{} }); ok {
		inputErrCh = v.ErrorSet()
	}
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

func (es *StartConversationEventStream) setupInputPipe(r *request.Request) {
	inputReader, inputWriter := io.Pipe()
	r.SetStreamingBody(inputReader)
	es.inputWriter = inputWriter
}

// Closes the input-pipe writer
func (es *StartConversationEventStream) closeInputPipe() error {
	if es.inputWriter != nil {
		return es.inputWriter.Close()
	}
	return nil
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
//
// These events are:
//
//     * AudioInputEvent
//     * ConfigurationEvent
//     * DTMFInputEvent
//     * DisconnectionEvent
//     * PlaybackCompletionEvent
//     * TextInputEvent
func (es *StartConversationEventStream) Send(ctx aws.Context, event StartConversationRequestEventStreamEvent) error {
	return es.Writer.Send(ctx, event)
}

func (es *StartConversationEventStream) runInputStream(r *request.Request) {
	var opts []func(*eventstream.Encoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.EncodeWithLogger(r.Config.Logger))
	}
	var encoder eventstreamapi.Encoder = eventstream.NewEncoder(es.inputWriter, opts...)

	var closer aws.MultiCloser
	sigSeed, err := v4.GetSignedRequestSignature(r.HTTPRequest)
	if err != nil {
		r.Error = awserr.New(request.ErrCodeSerialization,
			"unable to get initial request's signature", err)
		return
	}
	signer := eventstreamapi.NewSignEncoder(
		v4.NewStreamSigner(r.ClientInfo.SigningRegion, r.ClientInfo.SigningName,
			sigSeed, r.Config.Credentials),
		encoder,
	)
	encoder = signer
	closer = append(closer, signer)
	closer = append(closer, es.inputWriter)

	eventWriter := eventstreamapi.NewEventWriter(encoder,
		protocol.HandlerPayloadMarshal{
			Marshalers: r.Handlers.BuildStream,
		},
		eventTypeForStartConversationRequestEventStreamEvent,
	)

	es.Writer = &writeStartConversationRequestEventStream{
		StreamWriter: eventstreamapi.NewStreamWriter(eventWriter, closer),
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//     * AudioResponseEvent
//     * HeartbeatEvent
//     * IntentResultEvent
//     * PlaybackInterruptionEvent
//     * TextResponseEvent
//     * TranscriptEvent
//     * StartConversationResponseEventStreamUnknownEvent
func (es *StartConversationEventStream) Events() <-chan StartConversationResponseEventStreamEvent {
	return es.Reader.Events()
}

func (es *StartConversationEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForStartConversationResponseEventStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadStartConversationResponseEventStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer, and no more events can be
// sent.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
//
func (es *StartConversationEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *StartConversationEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}
	if err := es.closeInputPipe(); err != nil {
		es.err.SetError(err)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *StartConversationEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Writer.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

// The AccessDeniedException is and event in the StartConversationResponseEventStream group of events.
func (s *AccessDeniedException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AccessDeniedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AccessDeniedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the contexts that a user is using in a session.
// You can configure Amazon Lex V2 to set a context when an intent is fulfilled,
// or you can set a context using the , , or operations.
//
// Use a context to indicate to Amazon Lex V2 intents that should be used as
// follow-up intents. For example, if the active context is order-fulfilled,
// only intents that have order-fulfilled configured as a trigger are considered
// for follow up.
type ActiveContext struct {
	_ struct{} `type:"structure"`

	// A lis tof contexts active for the request. A context can be activated when
	// a previous intent is fulfilled, or by including the context in the request.
	//
	// If you don't specify a list of contexts, Amazon Lex will use the current
	// list of contexts for the session. If you specify an empty list, all contexts
	// for the session are cleared.
	//
	// ContextAttributes is a required field
	ContextAttributes map[string]*string `locationName:"contextAttributes" type:"map" required:"true"`

	// The name of the context.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Indicates the number of turns or seconds that the context is active. Once
	// the time to live expires, the context is no longer returned in a response.
	//
	// TimeToLive is a required field
	TimeToLive *ActiveContextTimeToLive `locationName:"timeToLive" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActiveContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActiveContext"}
	if s.ContextAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("ContextAttributes"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TimeToLive == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeToLive"))
	}
	if s.TimeToLive != nil {
		if err := s.TimeToLive.Validate(); err != nil {
			invalidParams.AddNested("TimeToLive", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContextAttributes sets the ContextAttributes field's value.
func (s *ActiveContext) SetContextAttributes(v map[string]*string) *ActiveContext {
	s.ContextAttributes = v
	return s
}

// SetName sets the Name field's value.
func (s *ActiveContext) SetName(v string) *ActiveContext {
	s.Name = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *ActiveContext) SetTimeToLive(v *ActiveContextTimeToLive) *ActiveContext {
	s.TimeToLive = v
	return s
}

// The time that a context is active. You can specify the time to live in seconds
// or in conversation turns.
type ActiveContextTimeToLive struct {
	_ struct{} `type:"structure"`

	// The number of seconds that the context is active. You can specify between
	// 5 and 86400 seconds (24 hours).
	//
	// TimeToLiveInSeconds is a required field
	TimeToLiveInSeconds *int64 `locationName:"timeToLiveInSeconds" min:"5" type:"integer" required:"true"`

	// The number of turns that the context is active. You can specify up to 20
	// turns. Each request and response from the bot is a turn.
	//
	// TurnsToLive is a required field
	TurnsToLive *int64 `locationName:"turnsToLive" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContextTimeToLive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContextTimeToLive) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActiveContextTimeToLive) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActiveContextTimeToLive"}
	if s.TimeToLiveInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeToLiveInSeconds"))
	}
	if s.TimeToLiveInSeconds != nil && *s.TimeToLiveInSeconds < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeToLiveInSeconds", 5))
	}
	if s.TurnsToLive == nil {
		invalidParams.Add(request.NewErrParamRequired("TurnsToLive"))
	}
	if s.TurnsToLive != nil && *s.TurnsToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TurnsToLive", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimeToLiveInSeconds sets the TimeToLiveInSeconds field's value.
func (s *ActiveContextTimeToLive) SetTimeToLiveInSeconds(v int64) *ActiveContextTimeToLive {
	s.TimeToLiveInSeconds = &v
	return s
}

// SetTurnsToLive sets the TurnsToLive field's value.
func (s *ActiveContextTimeToLive) SetTurnsToLive(v int64) *ActiveContextTimeToLive {
	s.TurnsToLive = &v
	return s
}

// Represents a chunk of audio sent from the client application to Amazon Lex
// V2. The audio is all or part of an utterance from the user.
//
// Amazon Lex V2 accumulates audio chunks until it recognizes a natural pause
// in speech before processing the input.
type AudioInputEvent struct {
	_ struct{} `type:"structure"`

	// An encoded stream of audio.
	// AudioChunk is automatically base64 encoded/decoded by the SDK.
	AudioChunk []byte `locationName:"audioChunk" type:"blob"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// The encoding used for the audio chunk. You must use 8 KHz PCM 16-bit mono-channel
	// little-endian format. The value of the field should be:
	//
	// audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" min:"1" type:"string" required:"true"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioInputEvent) GoString() string {
	return s.String()
}

// SetAudioChunk sets the AudioChunk field's value.
func (s *AudioInputEvent) SetAudioChunk(v []byte) *AudioInputEvent {
	s.AudioChunk = v
	return s
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *AudioInputEvent) SetClientTimestampMillis(v int64) *AudioInputEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *AudioInputEvent) SetContentType(v string) *AudioInputEvent {
	s.ContentType = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *AudioInputEvent) SetEventId(v string) *AudioInputEvent {
	s.EventId = &v
	return s
}

// The AudioInputEvent is and event in the StartConversationRequestEventStream group of events.
func (s *AudioInputEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AudioInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AudioInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AudioInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// An event sent from Amazon Lex V2 to your client application containing audio
// to play to the user.
type AudioResponseEvent struct {
	_ struct{} `type:"structure"`

	// A chunk of the audio to play.
	// AudioChunk is automatically base64 encoded/decoded by the SDK.
	AudioChunk []byte `locationName:"audioChunk" type:"blob"`

	// The encoding of the audio chunk. This is the same as the encoding configure
	// in the contentType field of the ConfigurationEvent.
	ContentType *string `locationName:"contentType" min:"1" type:"string"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioResponseEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioResponseEvent) GoString() string {
	return s.String()
}

// SetAudioChunk sets the AudioChunk field's value.
func (s *AudioResponseEvent) SetAudioChunk(v []byte) *AudioResponseEvent {
	s.AudioChunk = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *AudioResponseEvent) SetContentType(v string) *AudioResponseEvent {
	s.ContentType = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *AudioResponseEvent) SetEventId(v string) *AudioResponseEvent {
	s.EventId = &v
	return s
}

// The AudioResponseEvent is and event in the StartConversationResponseEventStream group of events.
func (s *AudioResponseEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AudioResponseEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AudioResponseEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AudioResponseEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type BadGatewayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) GoString() string {
	return s.String()
}

// The BadGatewayException is and event in the StartConversationResponseEventStream group of events.
func (s *BadGatewayException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the BadGatewayException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *BadGatewayException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorBadGatewayException(v protocol.ResponseMetadata) error {
	return &BadGatewayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadGatewayException) Code() string {
	return "BadGatewayException"
}

// Message returns the exception's message.
func (s *BadGatewayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadGatewayException) OrigErr() error {
	return nil
}

func (s *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadGatewayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadGatewayException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A button that appears on a response card show to the user.
type Button struct {
	_ struct{} `type:"structure"`

	// The text that is displayed on the button.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`

	// The value returned to Amazon Lex V2 when a user chooses the button.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Button) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Button"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Button) SetText(v string) *Button {
	s.Text = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Button) SetValue(v string) *Button {
	s.Value = &v
	return s
}

// Provides a score that indicates the confidence that Amazon Lex V2 has that
// an intent is the one that satisfies the user's intent.
type ConfidenceScore struct {
	_ struct{} `type:"structure"`

	// A score that indicates how confident Amazon Lex V2 is that an intent satisfies
	// the user's intent. Ranges between 0.00 and 1.00. Higher scores indicate higher
	// confidence.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfidenceScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfidenceScore) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *ConfidenceScore) SetScore(v float64) *ConfidenceScore {
	s.Score = &v
	return s
}

// The initial event sent from the application to Amazon Lex V2 to configure
// the conversation, including session and request attributes and the response
// content type.
type ConfigurationEvent struct {
	_ struct{} `type:"structure"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// Determines whether Amazon Lex V2 should send audio responses to the client
	// application. When this parameter if false, the client application needs to
	// create responses for the user.
	DisablePlayback *bool `locationName:"disablePlayback" type:"boolean"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// Request-specific information passed between the client application and Amazon
	// Lex V2.
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes for prefix x-amz-lex:.
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map"`

	// The message that Amazon Lex V2 returns in the response can be either text
	// or speech based on the responseContentType value.
	//
	//    * If the value is text/plain;charset=utf-8, Amazon Lex V2 returns text
	//    in the response.
	//
	//    * If the value begins with audio/, Amazon Lex V2 returns speech in the
	//    response. Amazon Lex V2 uses Amazon Polly to generate the speech using
	//    the configuration that you specified in the requestContentType parameter.
	//    For example, if you specify audio/mpeg as the value, Amazon Lex V2 returns
	//    speech in the MPEG format.
	//
	//    * If the value is audio/pcm, the speech returned is audio/pcm in 16-bit,
	//    little-endian format.
	//
	//    * The following are the accepted values: audio/mpeg audio/ogg audio/pcm
	//    audio/* (defaults to mpeg) text/plain; charset=utf-8
	//
	// ResponseContentType is a required field
	ResponseContentType *string `locationName:"responseContentType" min:"1" type:"string" required:"true"`

	// The state of the user's session with Amazon Lex V2.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`

	// A list of messages to send to the user.
	WelcomeMessages []*Message `locationName:"welcomeMessages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) GoString() string {
	return s.String()
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *ConfigurationEvent) SetClientTimestampMillis(v int64) *ConfigurationEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetDisablePlayback sets the DisablePlayback field's value.
func (s *ConfigurationEvent) SetDisablePlayback(v bool) *ConfigurationEvent {
	s.DisablePlayback = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *ConfigurationEvent) SetEventId(v string) *ConfigurationEvent {
	s.EventId = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *ConfigurationEvent) SetRequestAttributes(v map[string]*string) *ConfigurationEvent {
	s.RequestAttributes = v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *ConfigurationEvent) SetResponseContentType(v string) *ConfigurationEvent {
	s.ResponseContentType = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *ConfigurationEvent) SetSessionState(v *SessionState) *ConfigurationEvent {
	s.SessionState = v
	return s
}

// SetWelcomeMessages sets the WelcomeMessages field's value.
func (s *ConfigurationEvent) SetWelcomeMessages(v []*Message) *ConfigurationEvent {
	s.WelcomeMessages = v
	return s
}

// The ConfigurationEvent is and event in the StartConversationRequestEventStream group of events.
func (s *ConfigurationEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConfigurationEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

// The ConflictException is and event in the StartConversationResponseEventStream group of events.
func (s *ConflictException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConflictException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConflictException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConflictException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A DTMF character sent from the client application. DTMF characters are typically
// sent from a phone keypad to represent numbers. For example, you can have
// Amazon Lex V2 process a credit card number input from a phone.
type DTMFInputEvent struct {
	_ struct{} `type:"structure"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// The DTMF character that the user pressed. The allowed characters are A -
	// D, 0 - 9, # and *.
	//
	// InputCharacter is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DTMFInputEvent's
	// String and GoString methods.
	//
	// InputCharacter is a required field
	InputCharacter *string `locationName:"inputCharacter" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFInputEvent) GoString() string {
	return s.String()
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *DTMFInputEvent) SetClientTimestampMillis(v int64) *DTMFInputEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *DTMFInputEvent) SetEventId(v string) *DTMFInputEvent {
	s.EventId = &v
	return s
}

// SetInputCharacter sets the InputCharacter field's value.
func (s *DTMFInputEvent) SetInputCharacter(v string) *DTMFInputEvent {
	s.InputCharacter = &v
	return s
}

// The DTMFInputEvent is and event in the StartConversationRequestEventStream group of events.
func (s *DTMFInputEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the DTMFInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *DTMFInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *DTMFInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type DeleteSessionInput struct {
	_ struct{} `type:"structure"`

	// The alias identifier in use for the bot that contains the session data.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot that contains the session data.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// The identifier of the session to delete.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSessionInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteSessionInput) SetBotAliasId(v string) *DeleteSessionInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteSessionInput) SetBotId(v string) *DeleteSessionInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSessionInput) SetLocaleId(v string) *DeleteSessionInput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteSessionInput) SetSessionId(v string) *DeleteSessionInput {
	s.SessionId = &v
	return s
}

type DeleteSessionOutput struct {
	_ struct{} `type:"structure"`

	// The alias identifier in use for the bot that contained the session data.
	BotAliasId *string `locationName:"botAliasId" type:"string"`

	// The identifier of the bot that contained the session data.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The locale where the session was used.
	LocaleId *string `locationName:"localeId" min:"1" type:"string"`

	// The identifier of the deleted session.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSessionOutput) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteSessionOutput) SetBotAliasId(v string) *DeleteSessionOutput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteSessionOutput) SetBotId(v string) *DeleteSessionOutput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSessionOutput) SetLocaleId(v string) *DeleteSessionOutput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteSessionOutput) SetSessionId(v string) *DeleteSessionOutput {
	s.SessionId = &v
	return s
}

type DependencyFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailedException) GoString() string {
	return s.String()
}

// The DependencyFailedException is and event in the StartConversationResponseEventStream group of events.
func (s *DependencyFailedException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the DependencyFailedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *DependencyFailedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorDependencyFailedException(v protocol.ResponseMetadata) error {
	return &DependencyFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyFailedException) Code() string {
	return "DependencyFailedException"
}

// Message returns the exception's message.
func (s *DependencyFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyFailedException) OrigErr() error {
	return nil
}

func (s *DependencyFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The next action that Amazon Lex V2 should take.
type DialogAction struct {
	_ struct{} `type:"structure"`

	// The name of the slot that should be elicited from the user.
	SlotToElicit *string `locationName:"slotToElicit" min:"1" type:"string"`

	// The next action that the bot should take in its interaction with the user.
	// The possible values are:
	//
	//    * Close - Indicates that there will not be a response from the user. For
	//    example, the statement "Your order has been placed" does not require a
	//    response.
	//
	//    * ConfirmIntent - The next action is asking the user if the intent is
	//    complete and ready to be fulfilled. This is a yes/no question such as
	//    "Place the order?"
	//
	//    * Delegate - The next action is determined by Amazon Lex V2.
	//
	//    * ElicitSlot - The next action is to elicit a slot value from the user.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DialogActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialogAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialogAction"}
	if s.SlotToElicit != nil && len(*s.SlotToElicit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotToElicit", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSlotToElicit sets the SlotToElicit field's value.
func (s *DialogAction) SetSlotToElicit(v string) *DialogAction {
	s.SlotToElicit = &v
	return s
}

// SetType sets the Type field's value.
func (s *DialogAction) SetType(v string) *DialogAction {
	s.Type = &v
	return s
}

// A notification from the client that it is disconnecting from Amazon Lex V2.
// Sending a DisconnectionEvent event is optional, but can help identify a conversation
// in logs.
type DisconnectionEvent struct {
	_ struct{} `type:"structure"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectionEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectionEvent) GoString() string {
	return s.String()
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *DisconnectionEvent) SetClientTimestampMillis(v int64) *DisconnectionEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *DisconnectionEvent) SetEventId(v string) *DisconnectionEvent {
	s.EventId = &v
	return s
}

// The DisconnectionEvent is and event in the StartConversationRequestEventStream group of events.
func (s *DisconnectionEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the DisconnectionEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *DisconnectionEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *DisconnectionEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type GetSessionInput struct {
	_ struct{} `type:"structure"`

	// The alias identifier in use for the bot that contains the session data.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot that contains the session data.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// The identifier of the session to return.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *GetSessionInput) SetBotAliasId(v string) *GetSessionInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *GetSessionInput) SetBotId(v string) *GetSessionInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *GetSessionInput) SetLocaleId(v string) *GetSessionInput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionInput) SetSessionId(v string) *GetSessionInput {
	s.SessionId = &v
	return s
}

type GetSessionOutput struct {
	_ struct{} `type:"structure"`

	// A list of intents that Amazon Lex V2 determined might satisfy the user's
	// utterance.
	//
	// Each interpretation includes the intent, a score that indicates how confident
	// Amazon Lex V2 is that the interpretation is the correct one, and an optional
	// sentiment response that indicates the sentiment expressed in the utterance.
	Interpretations []*Interpretation `locationName:"interpretations" type:"list"`

	// A list of messages that were last sent to the user. The messages are ordered
	// based on the order that your returned the messages from your Lambda function
	// or the order that messages are defined in the bot.
	Messages []*Message `locationName:"messages" type:"list"`

	// The identifier of the returned session.
	SessionId *string `locationName:"sessionId" min:"1" type:"string"`

	// Represents the current state of the dialog between the user and the bot.
	//
	// You can use this to determine the progress of the conversation and what the
	// next action might be.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) GoString() string {
	return s.String()
}

// SetInterpretations sets the Interpretations field's value.
func (s *GetSessionOutput) SetInterpretations(v []*Interpretation) *GetSessionOutput {
	s.Interpretations = v
	return s
}

// SetMessages sets the Messages field's value.
func (s *GetSessionOutput) SetMessages(v []*Message) *GetSessionOutput {
	s.Messages = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionOutput) SetSessionId(v string) *GetSessionOutput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *GetSessionOutput) SetSessionState(v *SessionState) *GetSessionOutput {
	s.SessionState = v
	return s
}

// Event that Amazon Lex V2 sends to indicate that the stream is still open
// between the client application and Amazon Lex V2
type HeartbeatEvent struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeartbeatEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeartbeatEvent) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *HeartbeatEvent) SetEventId(v string) *HeartbeatEvent {
	s.EventId = &v
	return s
}

// The HeartbeatEvent is and event in the StartConversationResponseEventStream group of events.
func (s *HeartbeatEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the HeartbeatEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *HeartbeatEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *HeartbeatEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// A card that is shown to the user by a messaging platform. You define the
// contents of the card, the card is displayed by the platform.
//
// When you use a response card, the response from the user is constrained to
// the text associated with a button on the card.
type ImageResponseCard struct {
	_ struct{} `type:"structure"`

	// A list of buttons that should be displayed on the response card. The arrangement
	// of the buttons is determined by the platform that displays the button.
	Buttons []*Button `locationName:"buttons" type:"list"`

	// The URL of an image to display on the response card. The image URL must be
	// publicly available so that the platform displaying the response card has
	// access to the image.
	ImageUrl *string `locationName:"imageUrl" min:"1" type:"string"`

	// The subtitle to display on the response card. The format of the subtitle
	// is determined by the platform displaying the response card.
	Subtitle *string `locationName:"subtitle" min:"1" type:"string"`

	// The title to display on the response card. The format of the title is determined
	// by the platform displaying the response card.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResponseCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResponseCard) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageResponseCard) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageResponseCard"}
	if s.ImageUrl != nil && len(*s.ImageUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageUrl", 1))
	}
	if s.Subtitle != nil && len(*s.Subtitle) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subtitle", 1))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.Buttons != nil {
		for i, v := range s.Buttons {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Buttons", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetButtons sets the Buttons field's value.
func (s *ImageResponseCard) SetButtons(v []*Button) *ImageResponseCard {
	s.Buttons = v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *ImageResponseCard) SetImageUrl(v string) *ImageResponseCard {
	s.ImageUrl = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *ImageResponseCard) SetSubtitle(v string) *ImageResponseCard {
	s.Subtitle = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ImageResponseCard) SetTitle(v string) *ImageResponseCard {
	s.Title = &v
	return s
}

// The current intent that Amazon Lex V2 is attempting to fulfill.
type Intent struct {
	_ struct{} `type:"structure"`

	// Contains information about whether fulfillment of the intent has been confirmed.
	ConfirmationState *string `locationName:"confirmationState" type:"string" enum:"ConfirmationState"`

	// The name of the intent.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A map of all of the slots for the intent. The name of the slot maps to the
	// value of the slot. If a slot has not been filled, the value is null.
	Slots map[string]*Slot `locationName:"slots" type:"map"`

	// Contains fulfillment information for the intent.
	State *string `locationName:"state" type:"string" enum:"IntentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Intent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Intent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Intent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Intent"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Slots != nil {
		for i, v := range s.Slots {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Slots", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfirmationState sets the ConfirmationState field's value.
func (s *Intent) SetConfirmationState(v string) *Intent {
	s.ConfirmationState = &v
	return s
}

// SetName sets the Name field's value.
func (s *Intent) SetName(v string) *Intent {
	s.Name = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *Intent) SetSlots(v map[string]*Slot) *Intent {
	s.Slots = v
	return s
}

// SetState sets the State field's value.
func (s *Intent) SetState(v string) *Intent {
	s.State = &v
	return s
}

// Contains the current state of the conversation between the client application
// and Amazon Lex V2.
type IntentResultEvent struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// Indicates whether the input to the operation was text or speech.
	InputMode *string `locationName:"inputMode" type:"string" enum:"InputMode"`

	// A list of intents that Amazon Lex V2 determined might satisfy the user's
	// utterance.
	//
	// Each interpretation includes the intent, a score that indicates how confident
	// Amazon Lex V2 is that the interpretation is the correct one, and an optional
	// sentiment response that indicates the sentiment expressed in the utterance.
	Interpretations []*Interpretation `locationName:"interpretations" type:"list"`

	// The attributes sent in the request.
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map"`

	// The identifier of the session in use.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`

	// The state of the user's session with Amazon Lex V2.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentResultEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentResultEvent) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *IntentResultEvent) SetEventId(v string) *IntentResultEvent {
	s.EventId = &v
	return s
}

// SetInputMode sets the InputMode field's value.
func (s *IntentResultEvent) SetInputMode(v string) *IntentResultEvent {
	s.InputMode = &v
	return s
}

// SetInterpretations sets the Interpretations field's value.
func (s *IntentResultEvent) SetInterpretations(v []*Interpretation) *IntentResultEvent {
	s.Interpretations = v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *IntentResultEvent) SetRequestAttributes(v map[string]*string) *IntentResultEvent {
	s.RequestAttributes = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *IntentResultEvent) SetSessionId(v string) *IntentResultEvent {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *IntentResultEvent) SetSessionState(v *SessionState) *IntentResultEvent {
	s.SessionState = v
	return s
}

// The IntentResultEvent is and event in the StartConversationResponseEventStream group of events.
func (s *IntentResultEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the IntentResultEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *IntentResultEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *IntentResultEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

// The InternalServerException is and event in the StartConversationResponseEventStream group of events.
func (s *InternalServerException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalServerException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalServerException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalServerException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An intent that Amazon Lex V2 determined might satisfy the user's utterance.
// The intents are ordered by the confidence score.
type Interpretation struct {
	_ struct{} `type:"structure"`

	// A list of intents that might satisfy the user's utterance. The intents are
	// ordered by the confidence score.
	Intent *Intent `locationName:"intent" type:"structure"`

	// Determines the threshold where Amazon Lex V2 will insert the AMAZON.FallbackIntent,
	// AMAZON.KendraSearchIntent, or both when returning alternative intents in
	// a response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only
	// inserted if they are configured for the bot.
	NluConfidence *ConfidenceScore `locationName:"nluConfidence" type:"structure"`

	// The sentiment expressed in an utterance.
	//
	// When the bot is configured to send utterances to Amazon Comprehend for sentiment
	// analysis, this field contains the result of the analysis.
	SentimentResponse *SentimentResponse `locationName:"sentimentResponse" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interpretation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interpretation) GoString() string {
	return s.String()
}

// SetIntent sets the Intent field's value.
func (s *Interpretation) SetIntent(v *Intent) *Interpretation {
	s.Intent = v
	return s
}

// SetNluConfidence sets the NluConfidence field's value.
func (s *Interpretation) SetNluConfidence(v *ConfidenceScore) *Interpretation {
	s.NluConfidence = v
	return s
}

// SetSentimentResponse sets the SentimentResponse field's value.
func (s *Interpretation) SetSentimentResponse(v *SentimentResponse) *Interpretation {
	s.SentimentResponse = v
	return s
}

// Container for text that is returned to the customer..
type Message struct {
	_ struct{} `type:"structure"`

	// The text of the message.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Message's
	// String and GoString methods.
	Content *string `locationName:"content" min:"1" type:"string" sensitive:"true"`

	// Indicates the type of response.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true" enum:"MessageContentType"`

	// A card that is shown to the user by a messaging platform. You define the
	// contents of the card, the card is displayed by the platform.
	//
	// When you use a response card, the response from the user is constrained to
	// the text associated with a button on the card.
	ImageResponseCard *ImageResponseCard `locationName:"imageResponseCard" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ImageResponseCard != nil {
		if err := s.ImageResponseCard.Validate(); err != nil {
			invalidParams.AddNested("ImageResponseCard", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *Message) SetContent(v string) *Message {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Message) SetContentType(v string) *Message {
	s.ContentType = &v
	return s
}

// SetImageResponseCard sets the ImageResponseCard field's value.
func (s *Message) SetImageResponseCard(v *ImageResponseCard) *Message {
	s.ImageResponseCard = v
	return s
}

// Event sent from the client application to Amazon Lex V2 to indicate that
// playback of audio is complete and that Amazon Lex V2 should start processing
// the user's input.
type PlaybackCompletionEvent struct {
	_ struct{} `type:"structure"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackCompletionEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackCompletionEvent) GoString() string {
	return s.String()
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *PlaybackCompletionEvent) SetClientTimestampMillis(v int64) *PlaybackCompletionEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PlaybackCompletionEvent) SetEventId(v string) *PlaybackCompletionEvent {
	s.EventId = &v
	return s
}

// The PlaybackCompletionEvent is and event in the StartConversationRequestEventStream group of events.
func (s *PlaybackCompletionEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the PlaybackCompletionEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *PlaybackCompletionEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *PlaybackCompletionEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Event sent from Amazon Lex V2 to indicate to the client application should
// stop playback of audio. For example, if the client is playing a prompt that
// asks for the user's telephone number, the user might start to say the phone
// number before the prompt is complete. Amazon Lex V2 sends this event to the
// client application to indicate that the user is responding and that Amazon
// Lex V2 is processing their input.
type PlaybackInterruptionEvent struct {
	_ struct{} `type:"structure"`

	// The identifier of the event that contained the audio, DTMF, or text that
	// caused the interruption.
	CausedByEventId *string `locationName:"causedByEventId" min:"2" type:"string"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// Indicates the type of user input that Amazon Lex V2 detected.
	EventReason *string `locationName:"eventReason" type:"string" enum:"PlaybackInterruptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackInterruptionEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlaybackInterruptionEvent) GoString() string {
	return s.String()
}

// SetCausedByEventId sets the CausedByEventId field's value.
func (s *PlaybackInterruptionEvent) SetCausedByEventId(v string) *PlaybackInterruptionEvent {
	s.CausedByEventId = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PlaybackInterruptionEvent) SetEventId(v string) *PlaybackInterruptionEvent {
	s.EventId = &v
	return s
}

// SetEventReason sets the EventReason field's value.
func (s *PlaybackInterruptionEvent) SetEventReason(v string) *PlaybackInterruptionEvent {
	s.EventReason = &v
	return s
}

// The PlaybackInterruptionEvent is and event in the StartConversationResponseEventStream group of events.
func (s *PlaybackInterruptionEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the PlaybackInterruptionEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *PlaybackInterruptionEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *PlaybackInterruptionEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type PutSessionInput struct {
	_ struct{} `type:"structure"`

	// The alias identifier of the bot that receives the session data.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot that receives the session data.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// A list of messages to send to the user. Messages are sent in the order that
	// they are defined in the list.
	Messages []*Message `locationName:"messages" type:"list"`

	// Request-specific information passed between Amazon Lex V2 and the client
	// application.
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes with the prefix x-amz-lex:.
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map"`

	// The message that Amazon Lex V2 returns in the response can be either text
	// or speech depending on the value of this parameter.
	//
	//    * If the value is text/plain; charset=utf-8, Amazon Lex V2 returns text
	//    in the response.
	ResponseContentType *string `location:"header" locationName:"ResponseContentType" min:"1" type:"string"`

	// The identifier of the session that receives the session data.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`

	// Sets the state of the session with the user. You can use this to set the
	// current intent, attributes, context, and dialog action. Use the dialog action
	// to determine the next step that Amazon Lex V2 should use in the conversation
	// with the user.
	//
	// SessionState is a required field
	SessionState *SessionState `locationName:"sessionState" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSessionInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.ResponseContentType != nil && len(*s.ResponseContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseContentType", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}
	if s.SessionState == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionState"))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SessionState != nil {
		if err := s.SessionState.Validate(); err != nil {
			invalidParams.AddNested("SessionState", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *PutSessionInput) SetBotAliasId(v string) *PutSessionInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *PutSessionInput) SetBotId(v string) *PutSessionInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *PutSessionInput) SetLocaleId(v string) *PutSessionInput {
	s.LocaleId = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *PutSessionInput) SetMessages(v []*Message) *PutSessionInput {
	s.Messages = v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *PutSessionInput) SetRequestAttributes(v map[string]*string) *PutSessionInput {
	s.RequestAttributes = v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *PutSessionInput) SetResponseContentType(v string) *PutSessionInput {
	s.ResponseContentType = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *PutSessionInput) SetSessionId(v string) *PutSessionInput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *PutSessionInput) SetSessionState(v *SessionState) *PutSessionInput {
	s.SessionState = v
	return s
}

type PutSessionOutput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// If the requested content type was audio, the audio version of the message
	// to convey to the user.
	AudioStream io.ReadCloser `locationName:"audioStream" type:"blob"`

	// The type of response. Same as the type specified in the responseContentType
	// field in the request.
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// A list of messages that were last sent to the user. The messages are ordered
	// based on how you return the messages from you Lambda function or the order
	// that the messages are defined in the bot.
	Messages *string `location:"header" locationName:"x-amz-lex-messages" min:"1" type:"string"`

	// Request-specific information passed between the client application and Amazon
	// Lex V2. These are the same as the requestAttribute parameter in the call
	// to the PutSession operation.
	RequestAttributes *string `location:"header" locationName:"x-amz-lex-request-attributes" min:"1" type:"string"`

	// The identifier of the session that received the data.
	SessionId *string `location:"header" locationName:"x-amz-lex-session-id" min:"2" type:"string"`

	// Represents the current state of the dialog between the user and the bot.
	//
	// Use this to determine the progress of the conversation and what the next
	// action may be.
	SessionState *string `location:"header" locationName:"x-amz-lex-session-state" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSessionOutput) GoString() string {
	return s.String()
}

// SetAudioStream sets the AudioStream field's value.
func (s *PutSessionOutput) SetAudioStream(v io.ReadCloser) *PutSessionOutput {
	s.AudioStream = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PutSessionOutput) SetContentType(v string) *PutSessionOutput {
	s.ContentType = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *PutSessionOutput) SetMessages(v string) *PutSessionOutput {
	s.Messages = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *PutSessionOutput) SetRequestAttributes(v string) *PutSessionOutput {
	s.RequestAttributes = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *PutSessionOutput) SetSessionId(v string) *PutSessionOutput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *PutSessionOutput) SetSessionState(v string) *PutSessionOutput {
	s.SessionState = &v
	return s
}

type RecognizeTextInput struct {
	_ struct{} `type:"structure"`

	// The alias identifier in use for the bot that processes the request.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot that processes the request.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// Request-specific information passed between the client application and Amazon
	// Lex V2
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes with the prefix x-amz-lex:.
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map"`

	// The identifier of the user session that is having the conversation.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`

	// The current state of the dialog between the user and the bot.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`

	// The text that the user entered. Amazon Lex V2 interprets this text.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RecognizeTextInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecognizeTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecognizeTextInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.SessionState != nil {
		if err := s.SessionState.Validate(); err != nil {
			invalidParams.AddNested("SessionState", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *RecognizeTextInput) SetBotAliasId(v string) *RecognizeTextInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *RecognizeTextInput) SetBotId(v string) *RecognizeTextInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *RecognizeTextInput) SetLocaleId(v string) *RecognizeTextInput {
	s.LocaleId = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *RecognizeTextInput) SetRequestAttributes(v map[string]*string) *RecognizeTextInput {
	s.RequestAttributes = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RecognizeTextInput) SetSessionId(v string) *RecognizeTextInput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *RecognizeTextInput) SetSessionState(v *SessionState) *RecognizeTextInput {
	s.SessionState = v
	return s
}

// SetText sets the Text field's value.
func (s *RecognizeTextInput) SetText(v string) *RecognizeTextInput {
	s.Text = &v
	return s
}

type RecognizeTextOutput struct {
	_ struct{} `type:"structure"`

	// A list of intents that Amazon Lex V2 determined might satisfy the user's
	// utterance.
	//
	// Each interpretation includes the intent, a score that indicates now confident
	// Amazon Lex V2 is that the interpretation is the correct one, and an optional
	// sentiment response that indicates the sentiment expressed in the utterance.
	Interpretations []*Interpretation `locationName:"interpretations" type:"list"`

	// A list of messages last sent to the user. The messages are ordered based
	// on the order that you returned the messages from your Lambda function or
	// the order that the messages are defined in the bot.
	Messages []*Message `locationName:"messages" type:"list"`

	// The attributes sent in the request.
	RequestAttributes map[string]*string `locationName:"requestAttributes" type:"map"`

	// The identifier of the session in use.
	SessionId *string `locationName:"sessionId" min:"2" type:"string"`

	// Represents the current state of the dialog between the user and the bot.
	//
	// Use this to determine the progress of the conversation and what the next
	// action may be.
	SessionState *SessionState `locationName:"sessionState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeTextOutput) GoString() string {
	return s.String()
}

// SetInterpretations sets the Interpretations field's value.
func (s *RecognizeTextOutput) SetInterpretations(v []*Interpretation) *RecognizeTextOutput {
	s.Interpretations = v
	return s
}

// SetMessages sets the Messages field's value.
func (s *RecognizeTextOutput) SetMessages(v []*Message) *RecognizeTextOutput {
	s.Messages = v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *RecognizeTextOutput) SetRequestAttributes(v map[string]*string) *RecognizeTextOutput {
	s.RequestAttributes = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RecognizeTextOutput) SetSessionId(v string) *RecognizeTextOutput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *RecognizeTextOutput) SetSessionState(v *SessionState) *RecognizeTextOutput {
	s.SessionState = v
	return s
}

type RecognizeUtteranceInput struct {
	_ struct{} `type:"structure" payload:"InputStream"`

	// The alias identifier in use for the bot that should receive the request.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot that should receive the request.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// User input in PCM or Opus audio format or text format as described in the
	// requestContentType parameter.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	InputStream io.ReadSeeker `locationName:"inputStream" type:"blob"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// Request-specific information passed between the client application and Amazon
	// Lex V2
	//
	// The namespace x-amz-lex: is reserved for special attributes. Don't create
	// any request attributes for prefix x-amz-lex:.
	//
	// The requestAttributes field must be compressed using gzip and then base64
	// encoded before sending to Amazon Lex V2.
	//
	// RequestAttributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RecognizeUtteranceInput's
	// String and GoString methods.
	RequestAttributes *string `location:"header" locationName:"x-amz-lex-request-attributes" type:"string" sensitive:"true"`

	// Indicates the format for audio input or that the content is text. The header
	// must start with one of the following prefixes:
	//
	//    * PCM format, audio data must be in little-endian byte order. audio/l16;
	//    rate=16000; channels=1 audio/x-l16; sample-rate=16000; channel-count=1
	//    audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false
	//
	//    * Opus format audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
	//
	//    * Text format text/plain; charset=utf-8
	//
	// RequestContentType is a required field
	RequestContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string" required:"true"`

	// The message that Amazon Lex V2 returns in the response can be either text
	// or speech based on the responseContentType value.
	//
	//    * If the value is text/plain;charset=utf-8, Amazon Lex V2 returns text
	//    in the response.
	//
	//    * If the value begins with audio/, Amazon Lex V2 returns speech in the
	//    response. Amazon Lex V2 uses Amazon Polly to generate the speech using
	//    the configuration that you specified in the requestContentType parameter.
	//    For example, if you specify audio/mpeg as the value, Amazon Lex V2 returns
	//    speech in the MPEG format.
	//
	//    * If the value is audio/pcm, the speech returned is audio/pcm at 16 KHz
	//    in 16-bit, little-endian format.
	//
	//    * The following are the accepted values: audio/mpeg audio/ogg audio/pcm
	//    (16 KHz) audio/* (defaults to mpeg) text/plain; charset=utf-8
	ResponseContentType *string `location:"header" locationName:"Response-Content-Type" min:"1" type:"string"`

	// The identifier of the session in use.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`

	// Sets the state of the session with the user. You can use this to set the
	// current intent, attributes, context, and dialog action. Use the dialog action
	// to determine the next step that Amazon Lex V2 should use in the conversation
	// with the user.
	//
	// The sessionState field must be compressed using gzip and then base64 encoded
	// before sending to Amazon Lex V2.
	//
	// SessionState is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RecognizeUtteranceInput's
	// String and GoString methods.
	SessionState *string `location:"header" locationName:"x-amz-lex-session-state" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeUtteranceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeUtteranceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecognizeUtteranceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecognizeUtteranceInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.RequestContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestContentType"))
	}
	if s.RequestContentType != nil && len(*s.RequestContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestContentType", 1))
	}
	if s.ResponseContentType != nil && len(*s.ResponseContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseContentType", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *RecognizeUtteranceInput) SetBotAliasId(v string) *RecognizeUtteranceInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *RecognizeUtteranceInput) SetBotId(v string) *RecognizeUtteranceInput {
	s.BotId = &v
	return s
}

// SetInputStream sets the InputStream field's value.
func (s *RecognizeUtteranceInput) SetInputStream(v io.ReadSeeker) *RecognizeUtteranceInput {
	s.InputStream = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *RecognizeUtteranceInput) SetLocaleId(v string) *RecognizeUtteranceInput {
	s.LocaleId = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *RecognizeUtteranceInput) SetRequestAttributes(v string) *RecognizeUtteranceInput {
	s.RequestAttributes = &v
	return s
}

// SetRequestContentType sets the RequestContentType field's value.
func (s *RecognizeUtteranceInput) SetRequestContentType(v string) *RecognizeUtteranceInput {
	s.RequestContentType = &v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *RecognizeUtteranceInput) SetResponseContentType(v string) *RecognizeUtteranceInput {
	s.ResponseContentType = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RecognizeUtteranceInput) SetSessionId(v string) *RecognizeUtteranceInput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *RecognizeUtteranceInput) SetSessionState(v string) *RecognizeUtteranceInput {
	s.SessionState = &v
	return s
}

type RecognizeUtteranceOutput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// The prompt or statement to send to the user. This is based on the bot configuration
	// and context. For example, if Amazon Lex V2 did not understand the user intent,
	// it sends the clarificationPrompt configured for the bot. If the intent requires
	// confirmation before taking the fulfillment action, it sends the confirmationPrompt.
	// Another example: Suppose that the Lambda function successfully fulfilled
	// the intent, and sent a message to convey to the user. Then Amazon Lex V2
	// sends that message in the response.
	AudioStream io.ReadCloser `locationName:"audioStream" type:"blob"`

	// Content type as specified in the responseContentType in the request.
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// Indicates whether the input mode to the operation was text or speech.
	InputMode *string `location:"header" locationName:"x-amz-lex-input-mode" min:"1" type:"string"`

	// The text used to process the request.
	//
	// If the input was an audio stream, the inputTranscript field contains the
	// text extracted from the audio stream. This is the text that is actually processed
	// to recognize intents and slot values. You can use this information to determine
	// if Amazon Lex V2 is correctly processing the audio that you send.
	//
	// The inputTranscript field is compressed with gzip and then base64 encoded.
	// Before you can use the contents of the field, you must decode and decompress
	// the contents. See the example for a simple function to decode and decompress
	// the contents.
	InputTranscript *string `location:"header" locationName:"x-amz-lex-input-transcript" min:"1" type:"string"`

	// A list of intents that Amazon Lex V2 determined might satisfy the user's
	// utterance.
	//
	// Each interpretation includes the intent, a score that indicates how confident
	// Amazon Lex V2 is that the interpretation is the correct one, and an optional
	// sentiment response that indicates the sentiment expressed in the utterance.
	//
	// The interpretations field is compressed with gzip and then base64 encoded.
	// Before you can use the contents of the field, you must decode and decompress
	// the contents. See the example for a simple function to decode and decompress
	// the contents.
	Interpretations *string `location:"header" locationName:"x-amz-lex-interpretations" min:"1" type:"string"`

	// A list of messages that were last sent to the user. The messages are ordered
	// based on the order that you returned the messages from your Lambda function
	// or the order that the messages are defined in the bot.
	//
	// The messages field is compressed with gzip and then base64 encoded. Before
	// you can use the contents of the field, you must decode and decompress the
	// contents. See the example for a simple function to decode and decompress
	// the contents.
	Messages *string `location:"header" locationName:"x-amz-lex-messages" min:"1" type:"string"`

	// The attributes sent in the request.
	//
	// The requestAttributes field is compressed with gzip and then base64 encoded.
	// Before you can use the contents of the field, you must decode and decompress
	// the contents.
	RequestAttributes *string `location:"header" locationName:"x-amz-lex-request-attributes" min:"1" type:"string"`

	// The identifier of the session in use.
	SessionId *string `location:"header" locationName:"x-amz-lex-session-id" min:"2" type:"string"`

	// Represents the current state of the dialog between the user and the bot.
	//
	// Use this to determine the progress of the conversation and what the next
	// action might be.
	//
	// The sessionState field is compressed with gzip and then base64 encoded. Before
	// you can use the contents of the field, you must decode and decompress the
	// contents. See the example for a simple function to decode and decompress
	// the contents.
	SessionState *string `location:"header" locationName:"x-amz-lex-session-state" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeUtteranceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeUtteranceOutput) GoString() string {
	return s.String()
}

// SetAudioStream sets the AudioStream field's value.
func (s *RecognizeUtteranceOutput) SetAudioStream(v io.ReadCloser) *RecognizeUtteranceOutput {
	s.AudioStream = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *RecognizeUtteranceOutput) SetContentType(v string) *RecognizeUtteranceOutput {
	s.ContentType = &v
	return s
}

// SetInputMode sets the InputMode field's value.
func (s *RecognizeUtteranceOutput) SetInputMode(v string) *RecognizeUtteranceOutput {
	s.InputMode = &v
	return s
}

// SetInputTranscript sets the InputTranscript field's value.
func (s *RecognizeUtteranceOutput) SetInputTranscript(v string) *RecognizeUtteranceOutput {
	s.InputTranscript = &v
	return s
}

// SetInterpretations sets the Interpretations field's value.
func (s *RecognizeUtteranceOutput) SetInterpretations(v string) *RecognizeUtteranceOutput {
	s.Interpretations = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *RecognizeUtteranceOutput) SetMessages(v string) *RecognizeUtteranceOutput {
	s.Messages = &v
	return s
}

// SetRequestAttributes sets the RequestAttributes field's value.
func (s *RecognizeUtteranceOutput) SetRequestAttributes(v string) *RecognizeUtteranceOutput {
	s.RequestAttributes = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *RecognizeUtteranceOutput) SetSessionId(v string) *RecognizeUtteranceOutput {
	s.SessionId = &v
	return s
}

// SetSessionState sets the SessionState field's value.
func (s *RecognizeUtteranceOutput) SetSessionState(v string) *RecognizeUtteranceOutput {
	s.SessionState = &v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

// The ResourceNotFoundException is and event in the StartConversationResponseEventStream group of events.
func (s *ResourceNotFoundException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ResourceNotFoundException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the sentiment expressed in a user's response in
// a conversation. Sentiments are determined using Amazon Comprehend. Sentiments
// are only returned if they are enabled for the bot.
//
// For more information, see Determine Sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-sentiment.html)
// in the Amazon Comprehend developer guide.
type SentimentResponse struct {
	_ struct{} `type:"structure"`

	// The overall sentiment expressed in the user's response. This is the sentiment
	// most likely expressed by the user based on the analysis by Amazon Comprehend.
	Sentiment *string `locationName:"sentiment" type:"string" enum:"SentimentType"`

	// The individual sentiment responses for the utterance.
	SentimentScore *SentimentScore `locationName:"sentimentScore" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentResponse) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *SentimentResponse) SetSentiment(v string) *SentimentResponse {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *SentimentResponse) SetSentimentScore(v *SentimentScore) *SentimentResponse {
	s.SentimentScore = v
	return s
}

// The individual sentiment responses for the utterance.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `locationName:"mixed" type:"double"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `locationName:"negative" type:"double"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `locationName:"neutral" type:"double"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `locationName:"positive" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentScore) GoString() string {
	return s.String()
}

// SetMixed sets the Mixed field's value.
func (s *SentimentScore) SetMixed(v float64) *SentimentScore {
	s.Mixed = &v
	return s
}

// SetNegative sets the Negative field's value.
func (s *SentimentScore) SetNegative(v float64) *SentimentScore {
	s.Negative = &v
	return s
}

// SetNeutral sets the Neutral field's value.
func (s *SentimentScore) SetNeutral(v float64) *SentimentScore {
	s.Neutral = &v
	return s
}

// SetPositive sets the Positive field's value.
func (s *SentimentScore) SetPositive(v float64) *SentimentScore {
	s.Positive = &v
	return s
}

// The state of the user's session with Amazon Lex V2.
type SessionState struct {
	_ struct{} `type:"structure"`

	// One or more contexts that indicate to Amazon Lex V2 the context of a request.
	// When a context is active, Amazon Lex V2 considers intents with the matching
	// context as a trigger as the next intent in a session.
	ActiveContexts []*ActiveContext `locationName:"activeContexts" type:"list"`

	// The next step that Amazon Lex V2 should take in the conversation with a user.
	DialogAction *DialogAction `locationName:"dialogAction" type:"structure"`

	// The active intent that Amazon Lex V2 is processing.
	Intent *Intent `locationName:"intent" type:"structure"`

	OriginatingRequestId *string `locationName:"originatingRequestId" min:"1" type:"string"`

	// Map of key/value pairs representing session-specific context information.
	// It contains application information passed between Amazon Lex V2 and a client
	// application.
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionState) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionState) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionState"}
	if s.OriginatingRequestId != nil && len(*s.OriginatingRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginatingRequestId", 1))
	}
	if s.ActiveContexts != nil {
		for i, v := range s.ActiveContexts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ActiveContexts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DialogAction != nil {
		if err := s.DialogAction.Validate(); err != nil {
			invalidParams.AddNested("DialogAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Intent != nil {
		if err := s.Intent.Validate(); err != nil {
			invalidParams.AddNested("Intent", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveContexts sets the ActiveContexts field's value.
func (s *SessionState) SetActiveContexts(v []*ActiveContext) *SessionState {
	s.ActiveContexts = v
	return s
}

// SetDialogAction sets the DialogAction field's value.
func (s *SessionState) SetDialogAction(v *DialogAction) *SessionState {
	s.DialogAction = v
	return s
}

// SetIntent sets the Intent field's value.
func (s *SessionState) SetIntent(v *Intent) *SessionState {
	s.Intent = v
	return s
}

// SetOriginatingRequestId sets the OriginatingRequestId field's value.
func (s *SessionState) SetOriginatingRequestId(v string) *SessionState {
	s.OriginatingRequestId = &v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *SessionState) SetSessionAttributes(v map[string]*string) *SessionState {
	s.SessionAttributes = v
	return s
}

// A value that Amazon Lex V2 uses to fulfill an intent.
type Slot struct {
	_ struct{} `type:"structure"`

	// When the shape value is List, it indicates that the values field contains
	// a list of slot values. When the value is Scalar, it indicates that the value
	// field contains a single value.
	Shape *string `locationName:"shape" type:"string" enum:"Shape"`

	// The current value of the slot.
	Value *Value `locationName:"value" type:"structure"`

	// A list of one or more values that the user provided for the slot. For example,
	// if a for a slot that elicits pizza toppings, the values might be "pepperoni"
	// and "pineapple."
	Values []*Slot `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Slot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Slot) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Slot) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Slot"}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}
	if s.Values != nil {
		for i, v := range s.Values {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Values", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShape sets the Shape field's value.
func (s *Slot) SetShape(v string) *Slot {
	s.Shape = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Slot) SetValue(v *Value) *Slot {
	s.Value = v
	return s
}

// SetValues sets the Values field's value.
func (s *Slot) SetValues(v []*Slot) *Slot {
	s.Values = v
	return s
}

type StartConversationInput struct {
	_ struct{} `type:"structure" payload:"RequestEventStream"`

	// The alias identifier in use for the bot that processes the request.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" type:"string" required:"true"`

	// The identifier of the bot to process the request.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The conversation type that you are using the Amazon Lex V2. If the conversation
	// mode is AUDIO you can send both audio and DTMF information. If the mode is
	// TEXT you can only send text.
	ConversationMode *string `location:"header" locationName:"x-amz-lex-conversation-mode" type:"string" enum:"ConversationMode"`

	// The locale where the session is in use.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" min:"1" type:"string" required:"true"`

	// The identifier of the user session that is having the conversation.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartConversationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartConversationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConversationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartConversationInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *StartConversationInput) SetBotAliasId(v string) *StartConversationInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *StartConversationInput) SetBotId(v string) *StartConversationInput {
	s.BotId = &v
	return s
}

// SetConversationMode sets the ConversationMode field's value.
func (s *StartConversationInput) SetConversationMode(v string) *StartConversationInput {
	s.ConversationMode = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *StartConversationInput) SetLocaleId(v string) *StartConversationInput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartConversationInput) SetSessionId(v string) *StartConversationInput {
	s.SessionId = &v
	return s
}

type StartConversationOutput struct {
	_ struct{} `type:"structure" payload:"ResponseEventStream"`

	eventStream *StartConversationEventStream
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartConversationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartConversationOutput) GoString() string {
	return s.String()
}

// GetStream returns the type to interact with the event stream.
func (s *StartConversationOutput) GetStream() *StartConversationEventStream {
	return s.eventStream
}

// StartConversationRequestEventStreamEvent groups together all EventStream
// events writes for StartConversationRequestEventStream.
//
// These events are:
//
//     * AudioInputEvent
//     * ConfigurationEvent
//     * DTMFInputEvent
//     * DisconnectionEvent
//     * PlaybackCompletionEvent
//     * TextInputEvent
type StartConversationRequestEventStreamEvent interface {
	eventStartConversationRequestEventStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// StartConversationRequestEventStreamWriter provides the interface for writing events to the stream.
// The default implementation for this interface will be StartConversationRequestEventStream.
//
// The writer's Close method must allow multiple concurrent calls.
//
// These events are:
//
//     * AudioInputEvent
//     * ConfigurationEvent
//     * DTMFInputEvent
//     * DisconnectionEvent
//     * PlaybackCompletionEvent
//     * TextInputEvent
type StartConversationRequestEventStreamWriter interface {
	// Sends writes events to the stream blocking until the event has been
	// written. An error is returned if the write fails.
	Send(aws.Context, StartConversationRequestEventStreamEvent) error

	// Close will stop the writer writing to the event stream.
	Close() error

	// Returns any error that has occurred while writing to the event stream.
	Err() error
}

type writeStartConversationRequestEventStream struct {
	*eventstreamapi.StreamWriter
}

func (w *writeStartConversationRequestEventStream) Send(ctx aws.Context, event StartConversationRequestEventStreamEvent) error {
	return w.StreamWriter.Send(ctx, event)
}

func eventTypeForStartConversationRequestEventStreamEvent(event eventstreamapi.Marshaler) (string, error) {
	switch event.(type) {
	case *AudioInputEvent:
		return "AudioInputEvent", nil
	case *ConfigurationEvent:
		return "ConfigurationEvent", nil
	case *DTMFInputEvent:
		return "DTMFInputEvent", nil
	case *DisconnectionEvent:
		return "DisconnectionEvent", nil
	case *PlaybackCompletionEvent:
		return "PlaybackCompletionEvent", nil
	case *TextInputEvent:
		return "TextInputEvent", nil
	default:
		return "", awserr.New(
			request.ErrCodeSerialization,
			fmt.Sprintf("unknown event type, %T, for StartConversationRequestEventStream", event),
			nil,
		)
	}
}

// StartConversationResponseEventStreamEvent groups together all EventStream
// events writes for StartConversationResponseEventStream.
//
// These events are:
//
//     * AudioResponseEvent
//     * HeartbeatEvent
//     * IntentResultEvent
//     * PlaybackInterruptionEvent
//     * TextResponseEvent
//     * TranscriptEvent
type StartConversationResponseEventStreamEvent interface {
	eventStartConversationResponseEventStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// StartConversationResponseEventStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be StartConversationResponseEventStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//     * AudioResponseEvent
//     * HeartbeatEvent
//     * IntentResultEvent
//     * PlaybackInterruptionEvent
//     * TextResponseEvent
//     * TranscriptEvent
//     * StartConversationResponseEventStreamUnknownEvent
type StartConversationResponseEventStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan StartConversationResponseEventStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readStartConversationResponseEventStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan StartConversationResponseEventStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadStartConversationResponseEventStream(eventReader *eventstreamapi.EventReader) *readStartConversationResponseEventStream {
	r := &readStartConversationResponseEventStream{
		eventReader: eventReader,
		stream:      make(chan StartConversationResponseEventStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readStartConversationResponseEventStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readStartConversationResponseEventStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readStartConversationResponseEventStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readStartConversationResponseEventStream) safeClose() {
	close(r.done)
}

func (r *readStartConversationResponseEventStream) Err() error {
	return r.err.Err()
}

func (r *readStartConversationResponseEventStream) Events() <-chan StartConversationResponseEventStreamEvent {
	return r.stream
}

func (r *readStartConversationResponseEventStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(StartConversationResponseEventStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForStartConversationResponseEventStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForStartConversationResponseEventStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "AudioResponseEvent":
		return &AudioResponseEvent{}, nil
	case "HeartbeatEvent":
		return &HeartbeatEvent{}, nil
	case "IntentResultEvent":
		return &IntentResultEvent{}, nil
	case "PlaybackInterruptionEvent":
		return &PlaybackInterruptionEvent{}, nil
	case "TextResponseEvent":
		return &TextResponseEvent{}, nil
	case "TranscriptEvent":
		return &TranscriptEvent{}, nil
	case "AccessDeniedException":
		return newErrorAccessDeniedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "BadGatewayException":
		return newErrorBadGatewayException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ConflictException":
		return newErrorConflictException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "DependencyFailedException":
		return newErrorDependencyFailedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "InternalServerException":
		return newErrorInternalServerException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ResourceNotFoundException":
		return newErrorResourceNotFoundException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ThrottlingException":
		return newErrorThrottlingException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ValidationException":
		return newErrorValidationException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &StartConversationResponseEventStreamUnknownEvent{Type: eventType}, nil
	}
}

// StartConversationResponseEventStreamUnknownEvent provides a failsafe event for the
// StartConversationResponseEventStream group of events when an unknown event is received.
type StartConversationResponseEventStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The StartConversationResponseEventStreamUnknownEvent is and event in the StartConversationResponseEventStream
// group of events.
func (s *StartConversationResponseEventStreamUnknownEvent) eventStartConversationResponseEventStream() {
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *StartConversationResponseEventStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the StartConversationResponseEventStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *StartConversationResponseEventStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// The event sent from your client application to Amazon Lex V2 with text input
// from the user.
type TextInputEvent struct {
	_ struct{} `type:"structure"`

	// A timestamp set by the client of the date and time that the event was sent
	// to Amazon Lex V2.
	ClientTimestampMillis *int64 `locationName:"clientTimestampMillis" type:"long"`

	// A unique identifier that your application assigns to the event. You can use
	// this to identify events in logs.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// The text from the user. Amazon Lex V2 processes this as a complete statement.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TextInputEvent's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputEvent) GoString() string {
	return s.String()
}

// SetClientTimestampMillis sets the ClientTimestampMillis field's value.
func (s *TextInputEvent) SetClientTimestampMillis(v int64) *TextInputEvent {
	s.ClientTimestampMillis = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *TextInputEvent) SetEventId(v string) *TextInputEvent {
	s.EventId = &v
	return s
}

// SetText sets the Text field's value.
func (s *TextInputEvent) SetText(v string) *TextInputEvent {
	s.Text = &v
	return s
}

// The TextInputEvent is and event in the StartConversationRequestEventStream group of events.
func (s *TextInputEvent) eventStartConversationRequestEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TextInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TextInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TextInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// The event sent from Amazon Lex V2 to your application with text to present
// to the user.
type TextResponseEvent struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// A list of messages to send to the user. Messages are ordered based on the
	// order that you returned the messages from your Lambda function or the order
	// that the messages are defined in the bot.
	Messages []*Message `locationName:"messages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponseEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextResponseEvent) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *TextResponseEvent) SetEventId(v string) *TextResponseEvent {
	s.EventId = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *TextResponseEvent) SetMessages(v []*Message) *TextResponseEvent {
	s.Messages = v
	return s
}

// The TextResponseEvent is and event in the StartConversationResponseEventStream group of events.
func (s *TextResponseEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TextResponseEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TextResponseEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TextResponseEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

// The ThrottlingException is and event in the StartConversationResponseEventStream group of events.
func (s *ThrottlingException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ThrottlingException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Event sent from Amazon Lex V2 to your client application that contains a
// transcript of voice audio.
type TranscriptEvent struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the event sent by Amazon Lex V2. The identifier is
	// in the form RESPONSE-N, where N is a number starting with one and incremented
	// for each event sent by Amazon Lex V2 in the current session.
	EventId *string `locationName:"eventId" min:"2" type:"string"`

	// The transcript of the voice audio from the user.
	Transcript *string `locationName:"transcript" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptEvent) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *TranscriptEvent) SetEventId(v string) *TranscriptEvent {
	s.EventId = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptEvent) SetTranscript(v string) *TranscriptEvent {
	s.Transcript = &v
	return s
}

// The TranscriptEvent is and event in the StartConversationResponseEventStream group of events.
func (s *TranscriptEvent) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TranscriptEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TranscriptEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TranscriptEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

// The ValidationException is and event in the StartConversationResponseEventStream group of events.
func (s *ValidationException) eventStartConversationResponseEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ValidationException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ValidationException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ValidationException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value of a slot.
type Value struct {
	_ struct{} `type:"structure"`

	// The value that Amazon Lex V2 determines for the slot. The actual value depends
	// on the setting of the value selection strategy for the bot. You can choose
	// to use the value entered by the user, or you can have Amazon Lex V2 choose
	// the first value in the resolvedValues list.
	//
	// InterpretedValue is a required field
	InterpretedValue *string `locationName:"interpretedValue" min:"1" type:"string" required:"true"`

	// The text of the utterance from the user that was entered for the slot.
	OriginalValue *string `locationName:"originalValue" min:"1" type:"string"`

	// A list of additional values that have been recognized for the slot.
	ResolvedValues []*string `locationName:"resolvedValues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Value) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Value) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Value) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Value"}
	if s.InterpretedValue == nil {
		invalidParams.Add(request.NewErrParamRequired("InterpretedValue"))
	}
	if s.InterpretedValue != nil && len(*s.InterpretedValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InterpretedValue", 1))
	}
	if s.OriginalValue != nil && len(*s.OriginalValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginalValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterpretedValue sets the InterpretedValue field's value.
func (s *Value) SetInterpretedValue(v string) *Value {
	s.InterpretedValue = &v
	return s
}

// SetOriginalValue sets the OriginalValue field's value.
func (s *Value) SetOriginalValue(v string) *Value {
	s.OriginalValue = &v
	return s
}

// SetResolvedValues sets the ResolvedValues field's value.
func (s *Value) SetResolvedValues(v []*string) *Value {
	s.ResolvedValues = v
	return s
}

const (
	// ConfirmationStateConfirmed is a ConfirmationState enum value
	ConfirmationStateConfirmed = "Confirmed"

	// ConfirmationStateDenied is a ConfirmationState enum value
	ConfirmationStateDenied = "Denied"

	// ConfirmationStateNone is a ConfirmationState enum value
	ConfirmationStateNone = "None"
)

// ConfirmationState_Values returns all elements of the ConfirmationState enum
func ConfirmationState_Values() []string {
	return []string{
		ConfirmationStateConfirmed,
		ConfirmationStateDenied,
		ConfirmationStateNone,
	}
}

const (
	// ConversationModeAudio is a ConversationMode enum value
	ConversationModeAudio = "AUDIO"

	// ConversationModeText is a ConversationMode enum value
	ConversationModeText = "TEXT"
)

// ConversationMode_Values returns all elements of the ConversationMode enum
func ConversationMode_Values() []string {
	return []string{
		ConversationModeAudio,
		ConversationModeText,
	}
}

const (
	// DialogActionTypeClose is a DialogActionType enum value
	DialogActionTypeClose = "Close"

	// DialogActionTypeConfirmIntent is a DialogActionType enum value
	DialogActionTypeConfirmIntent = "ConfirmIntent"

	// DialogActionTypeDelegate is a DialogActionType enum value
	DialogActionTypeDelegate = "Delegate"

	// DialogActionTypeElicitIntent is a DialogActionType enum value
	DialogActionTypeElicitIntent = "ElicitIntent"

	// DialogActionTypeElicitSlot is a DialogActionType enum value
	DialogActionTypeElicitSlot = "ElicitSlot"
)

// DialogActionType_Values returns all elements of the DialogActionType enum
func DialogActionType_Values() []string {
	return []string{
		DialogActionTypeClose,
		DialogActionTypeConfirmIntent,
		DialogActionTypeDelegate,
		DialogActionTypeElicitIntent,
		DialogActionTypeElicitSlot,
	}
}

const (
	// InputModeText is a InputMode enum value
	InputModeText = "Text"

	// InputModeSpeech is a InputMode enum value
	InputModeSpeech = "Speech"

	// InputModeDtmf is a InputMode enum value
	InputModeDtmf = "DTMF"
)

// InputMode_Values returns all elements of the InputMode enum
func InputMode_Values() []string {
	return []string{
		InputModeText,
		InputModeSpeech,
		InputModeDtmf,
	}
}

const (
	// IntentStateFailed is a IntentState enum value
	IntentStateFailed = "Failed"

	// IntentStateFulfilled is a IntentState enum value
	IntentStateFulfilled = "Fulfilled"

	// IntentStateInProgress is a IntentState enum value
	IntentStateInProgress = "InProgress"

	// IntentStateReadyForFulfillment is a IntentState enum value
	IntentStateReadyForFulfillment = "ReadyForFulfillment"

	// IntentStateWaiting is a IntentState enum value
	IntentStateWaiting = "Waiting"
)

// IntentState_Values returns all elements of the IntentState enum
func IntentState_Values() []string {
	return []string{
		IntentStateFailed,
		IntentStateFulfilled,
		IntentStateInProgress,
		IntentStateReadyForFulfillment,
		IntentStateWaiting,
	}
}

const (
	// MessageContentTypeCustomPayload is a MessageContentType enum value
	MessageContentTypeCustomPayload = "CustomPayload"

	// MessageContentTypeImageResponseCard is a MessageContentType enum value
	MessageContentTypeImageResponseCard = "ImageResponseCard"

	// MessageContentTypePlainText is a MessageContentType enum value
	MessageContentTypePlainText = "PlainText"

	// MessageContentTypeSsml is a MessageContentType enum value
	MessageContentTypeSsml = "SSML"
)

// MessageContentType_Values returns all elements of the MessageContentType enum
func MessageContentType_Values() []string {
	return []string{
		MessageContentTypeCustomPayload,
		MessageContentTypeImageResponseCard,
		MessageContentTypePlainText,
		MessageContentTypeSsml,
	}
}

const (
	// PlaybackInterruptionReasonDtmfStartDetected is a PlaybackInterruptionReason enum value
	PlaybackInterruptionReasonDtmfStartDetected = "DTMF_START_DETECTED"

	// PlaybackInterruptionReasonTextDetected is a PlaybackInterruptionReason enum value
	PlaybackInterruptionReasonTextDetected = "TEXT_DETECTED"

	// PlaybackInterruptionReasonVoiceStartDetected is a PlaybackInterruptionReason enum value
	PlaybackInterruptionReasonVoiceStartDetected = "VOICE_START_DETECTED"
)

// PlaybackInterruptionReason_Values returns all elements of the PlaybackInterruptionReason enum
func PlaybackInterruptionReason_Values() []string {
	return []string{
		PlaybackInterruptionReasonDtmfStartDetected,
		PlaybackInterruptionReasonTextDetected,
		PlaybackInterruptionReasonVoiceStartDetected,
	}
}

const (
	// SentimentTypeMixed is a SentimentType enum value
	SentimentTypeMixed = "MIXED"

	// SentimentTypeNegative is a SentimentType enum value
	SentimentTypeNegative = "NEGATIVE"

	// SentimentTypeNeutral is a SentimentType enum value
	SentimentTypeNeutral = "NEUTRAL"

	// SentimentTypePositive is a SentimentType enum value
	SentimentTypePositive = "POSITIVE"
)

// SentimentType_Values returns all elements of the SentimentType enum
func SentimentType_Values() []string {
	return []string{
		SentimentTypeMixed,
		SentimentTypeNegative,
		SentimentTypeNeutral,
		SentimentTypePositive,
	}
}

const (
	// ShapeScalar is a Shape enum value
	ShapeScalar = "Scalar"

	// ShapeList is a Shape enum value
	ShapeList = "List"
)

// Shape_Values returns all elements of the Shape enum
func Shape_Values() []string {
	return []string{
		ShapeScalar,
		ShapeList,
	}
}
