// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/run/v2/instance_split.proto

package runpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of instance split allocation.
type InstanceSplitAllocationType int32

const (
	// Unspecified instance allocation type.
	InstanceSplitAllocationType_INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED InstanceSplitAllocationType = 0
	// Allocates instances to the Service's latest ready Revision.
	InstanceSplitAllocationType_INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST InstanceSplitAllocationType = 1
	// Allocates instances to a Revision by name.
	InstanceSplitAllocationType_INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION InstanceSplitAllocationType = 2
)

// Enum value maps for InstanceSplitAllocationType.
var (
	InstanceSplitAllocationType_name = map[int32]string{
		0: "INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED",
		1: "INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST",
		2: "INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION",
	}
	InstanceSplitAllocationType_value = map[string]int32{
		"INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED": 0,
		"INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST":      1,
		"INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION":    2,
	}
)

func (x InstanceSplitAllocationType) Enum() *InstanceSplitAllocationType {
	p := new(InstanceSplitAllocationType)
	*p = x
	return p
}

func (x InstanceSplitAllocationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceSplitAllocationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_run_v2_instance_split_proto_enumTypes[0].Descriptor()
}

func (InstanceSplitAllocationType) Type() protoreflect.EnumType {
	return &file_google_cloud_run_v2_instance_split_proto_enumTypes[0]
}

func (x InstanceSplitAllocationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceSplitAllocationType.Descriptor instead.
func (InstanceSplitAllocationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_instance_split_proto_rawDescGZIP(), []int{0}
}

// Holds a single instance split entry for the Worker. Allocations can be done
// to a specific Revision name, or pointing to the latest Ready Revision.
type InstanceSplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allocation type for this instance split.
	Type InstanceSplitAllocationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.run.v2.InstanceSplitAllocationType" json:"type,omitempty"`
	// Revision to which to assign this portion of instances, if split allocation
	// is by revision.
	Revision string `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	// Specifies percent of the instance split to this Revision.
	// This defaults to zero if unspecified.
	Percent int32 `protobuf:"varint,3,opt,name=percent,proto3" json:"percent,omitempty"`
}

func (x *InstanceSplit) Reset() {
	*x = InstanceSplit{}
	mi := &file_google_cloud_run_v2_instance_split_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceSplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceSplit) ProtoMessage() {}

func (x *InstanceSplit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_instance_split_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceSplit.ProtoReflect.Descriptor instead.
func (*InstanceSplit) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_instance_split_proto_rawDescGZIP(), []int{0}
}

func (x *InstanceSplit) GetType() InstanceSplitAllocationType {
	if x != nil {
		return x.Type
	}
	return InstanceSplitAllocationType_INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED
}

func (x *InstanceSplit) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *InstanceSplit) GetPercent() int32 {
	if x != nil {
		return x.Percent
	}
	return 0
}

// Represents the observed state of a single `InstanceSplit` entry.
type InstanceSplitStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allocation type for this instance split.
	Type InstanceSplitAllocationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.run.v2.InstanceSplitAllocationType" json:"type,omitempty"`
	// Revision to which this instance split is assigned.
	Revision string `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	// Specifies percent of the instance split to this Revision.
	Percent int32 `protobuf:"varint,3,opt,name=percent,proto3" json:"percent,omitempty"`
}

func (x *InstanceSplitStatus) Reset() {
	*x = InstanceSplitStatus{}
	mi := &file_google_cloud_run_v2_instance_split_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceSplitStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceSplitStatus) ProtoMessage() {}

func (x *InstanceSplitStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_instance_split_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceSplitStatus.ProtoReflect.Descriptor instead.
func (*InstanceSplitStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_instance_split_proto_rawDescGZIP(), []int{1}
}

func (x *InstanceSplitStatus) GetType() InstanceSplitAllocationType {
	if x != nil {
		return x.Type
	}
	return InstanceSplitAllocationType_INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED
}

func (x *InstanceSplitStatus) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *InstanceSplitStatus) GetPercent() int32 {
	if x != nil {
		return x.Percent
	}
	return 0
}

var File_google_cloud_run_v2_instance_split_proto protoreflect.FileDescriptor

var file_google_cloud_run_v2_instance_split_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad, 0x01, 0x0a, 0x0d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x72, 0x75, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0xb3, 0x01, 0x0a, 0x13, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a,
	0x1b, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x72, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x2a, 0xa5, 0x01, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2e, 0x0a, 0x2a, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x50, 0x4c,
	0x49, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x29, 0x0a, 0x25, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x50, 0x4c,
	0x49, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x41, 0x4c,
	0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0x5a, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x2e, 0x76, 0x32, 0x42, 0x12, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x3b, 0x72,
	0x75, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_run_v2_instance_split_proto_rawDescOnce sync.Once
	file_google_cloud_run_v2_instance_split_proto_rawDescData = file_google_cloud_run_v2_instance_split_proto_rawDesc
)

func file_google_cloud_run_v2_instance_split_proto_rawDescGZIP() []byte {
	file_google_cloud_run_v2_instance_split_proto_rawDescOnce.Do(func() {
		file_google_cloud_run_v2_instance_split_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_run_v2_instance_split_proto_rawDescData)
	})
	return file_google_cloud_run_v2_instance_split_proto_rawDescData
}

var file_google_cloud_run_v2_instance_split_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_run_v2_instance_split_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_run_v2_instance_split_proto_goTypes = []any{
	(InstanceSplitAllocationType)(0), // 0: google.cloud.run.v2.InstanceSplitAllocationType
	(*InstanceSplit)(nil),            // 1: google.cloud.run.v2.InstanceSplit
	(*InstanceSplitStatus)(nil),      // 2: google.cloud.run.v2.InstanceSplitStatus
}
var file_google_cloud_run_v2_instance_split_proto_depIdxs = []int32{
	0, // 0: google.cloud.run.v2.InstanceSplit.type:type_name -> google.cloud.run.v2.InstanceSplitAllocationType
	0, // 1: google.cloud.run.v2.InstanceSplitStatus.type:type_name -> google.cloud.run.v2.InstanceSplitAllocationType
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_run_v2_instance_split_proto_init() }
func file_google_cloud_run_v2_instance_split_proto_init() {
	if File_google_cloud_run_v2_instance_split_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_run_v2_instance_split_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_run_v2_instance_split_proto_goTypes,
		DependencyIndexes: file_google_cloud_run_v2_instance_split_proto_depIdxs,
		EnumInfos:         file_google_cloud_run_v2_instance_split_proto_enumTypes,
		MessageInfos:      file_google_cloud_run_v2_instance_split_proto_msgTypes,
	}.Build()
	File_google_cloud_run_v2_instance_split_proto = out.File
	file_google_cloud_run_v2_instance_split_proto_rawDesc = nil
	file_google_cloud_run_v2_instance_split_proto_goTypes = nil
	file_google_cloud_run_v2_instance_split_proto_depIdxs = nil
}
