// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/speech/v1/cloud_speech.proto

package speechpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Speech_Recognize_FullMethodName            = "/google.cloud.speech.v1.Speech/Recognize"
	Speech_LongRunningRecognize_FullMethodName = "/google.cloud.speech.v1.Speech/LongRunningRecognize"
	Speech_StreamingRecognize_FullMethodName   = "/google.cloud.speech.v1.Speech/StreamingRecognize"
)

// SpeechClient is the client API for Speech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpeechClient interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	// For more information on asynchronous speech recognition, see the
	// [how-to](https://cloud.google.com/speech-to-text/docs/async-recognize).
	LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
}

type speechClient struct {
	cc grpc.ClientConnInterface
}

func NewSpeechClient(cc grpc.ClientConnInterface) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error) {
	out := new(RecognizeResponse)
	err := c.cc.Invoke(ctx, Speech_Recognize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_LongRunningRecognize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &Speech_ServiceDesc.Streams[0], Speech_StreamingRecognize_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechServer is the server API for Speech service.
// All implementations should embed UnimplementedSpeechServer
// for forward compatibility
type SpeechServer interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	// For more information on asynchronous speech recognition, see the
	// [how-to](https://cloud.google.com/speech-to-text/docs/async-recognize).
	LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunningpb.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
}

// UnimplementedSpeechServer should be embedded to have forward compatible implementations.
type UnimplementedSpeechServer struct {
}

func (UnimplementedSpeechServer) Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Recognize not implemented")
}
func (UnimplementedSpeechServer) LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LongRunningRecognize not implemented")
}
func (UnimplementedSpeechServer) StreamingRecognize(Speech_StreamingRecognizeServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingRecognize not implemented")
}

// UnsafeSpeechServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpeechServer will
// result in compilation errors.
type UnsafeSpeechServer interface {
	mustEmbedUnimplementedSpeechServer()
}

func RegisterSpeechServer(s grpc.ServiceRegistrar, srv SpeechServer) {
	s.RegisterService(&Speech_ServiceDesc, srv)
}

func _Speech_Recognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).Recognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_Recognize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).Recognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_LongRunningRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LongRunningRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).LongRunningRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_LongRunningRecognize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).LongRunningRecognize(ctx, req.(*LongRunningRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Speech_ServiceDesc is the grpc.ServiceDesc for Speech service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Speech_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Recognize",
			Handler:    _Speech_Recognize_Handler,
		},
		{
			MethodName: "LongRunningRecognize",
			Handler:    _Speech_LongRunningRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/speech/v1/cloud_speech.proto",
}
